/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: ilu-franz-skin.c,v 1.2 1994/05/11 18:42:47 janssen Exp $
*/

#include <ilu.h>

/* set up technology for blocking on read and write appropriately */

static int (*read_fn) (int fd, unsigned long msec) = NULL;
static int (*write_fn) (int fd, unsigned long msec) = NULL;

#ifdef ALLEGRO_4_2
#define FixnumToInt(v)	((v)>>2)
#else
#define FixnumToInt(v)	((v)>>3)
#endif /* ALLEGRO_4_2 */

#define MILLISECONDS(x)	(((x)==NULL)?0:((x)->ft_s * 1000 + (x)->ft_t))

static void internal_read_wait (int fd, ilu_boolean *sure, ilu_FineTime *limit)
{
  if (read_fn != NULL)
    *sure = FixnumToInt((*read_fn)(fd, (limit == NULL) ? 0 : MILLISECONDS(limit)));
  else
    *sure = 0;
}

static void internal_write_wait (int fd, ilu_boolean *sure, ilu_FineTime *limit)
{
  if (write_fn != NULL)
    *sure = FixnumToInt((*write_fn)(fd, (limit == NULL) ? 0 : MILLISECONDS(limit)));
  else
    *sure = 0;
}

void ilufranz_SetWaitTech (int (*read_wait) (int fd, unsigned long timetowait),
			   int (*write_wait) (int fd, unsigned long timetowait))
{
  static ilu_WaitTech wait_tech;

  ilu_FineTimeRate = 1000;	/* claim that milliseconds are what we deal in */

  read_fn = read_wait;
  write_fn = write_wait;
  wait_tech.wt_read_wait = internal_read_wait;
  wait_tech.wt_write_wait = internal_write_wait;
  ilu_SetWaitTech (&wait_tech);
}

/* these functions are used for locking and condition variables */

typedef long (*franzCreateFn) (ilu_string, ilu_string);

static franzCreateFn internal_mcreate;

static ilu_private franz_mcreate (ilu_string d1, ilu_string d2)
{
  long retval;
  retval = (*internal_mcreate) (d1, d2);
  return ((ilu_private) FixnumToInt(retval));
}

static franzCreateFn internal_ccreate;

static ilu_private franz_ccreate (ilu_string d1, ilu_string d2)
{
  long retval;
  retval = (*internal_ccreate) (d1, d2);
  return ((ilu_private) FixnumToInt(retval));
}

void ilufranz_SetLockTech (long (*mcreate)(ilu_string d1, ilu_string d2),
			   void (*macquire) (ilu_private m),
			   void (*mhold) (ilu_private m),
			   void (*mrelease) (ilu_private m),
			   void (*mdestroy) (ilu_private m),
			   long (*ccreate)(ilu_string d1, ilu_string d2),
			   void (*cnotify) (ilu_private c),
			   void (*cdestroy) (ilu_private c),
			   void (*cwait) (ilu_private c, ilu_private m))
{
  static ilu_LockTech franzLockTech;

  internal_mcreate = mcreate;
  internal_ccreate = ccreate;

  franzLockTech.lt_mcreate = franz_mcreate;
  franzLockTech.lt_acquire = macquire;
  franzLockTech.lt_hold = mhold;
  franzLockTech.lt_release = mrelease;
  franzLockTech.lt_mdestroy = mdestroy;
  franzLockTech.lt_ccreate = franz_ccreate;
  franzLockTech.lt_notify = cnotify;
  franzLockTech.lt_cdestroy = cdestroy;
  franzLockTech.lt_wait = cwait;

  ilu_RegisterLockTech (&franzLockTech);
}

void ilufranz_CallAlarmClosure (void (*proc) (ilu_private rock), ilu_private rock)
{
  (*proc)(rock);
}

static int (*internal_create_alarm)();

static ilu_refany franz_create_alarm ()
{
  return ((ilu_refany) (FixnumToInt((*internal_create_alarm)())));
}

static void (*internal_set_alarm) (int alarm, unsigned long time, void *p1, void *p2);

static void franz_set_alarm (ilu_refany alarm, ilu_FineTime t,
			     void (*proc)(ilu_private rock), ilu_private rock)
{
  (*internal_set_alarm) ((int) alarm, MILLISECONDS(&t), (void *) proc, (void *) proc);
}

void ilufranz_SetAlarms (int (*create_alarm) (),
			 void (*set_alarm) (int alarm, unsigned long time, void *p1, void *p2),
			 void (*unset_alarm) (ilu_refany alarm))
{
  static ilu_MainLoop ml;

  internal_create_alarm = create_alarm;
  internal_set_alarm = set_alarm;

  ml.ml_run = NULL;
  ml.ml_exit = NULL;
  ml.ml_register_input = NULL;
  ml.ml_unregister_input = NULL;
  ml.ml_register_output = NULL;
  ml.ml_unregister_output = NULL;

  ml.ml_create_alarm = franz_create_alarm;
  ml.ml_set_alarm = franz_set_alarm;
  ml.ml_unset_alarm = unset_alarm;

  ilu_SetMainLoop (&ml);
}
