/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: packet.h,v 1.9 1994/01/20 05:02:17 janssen Exp $ */
/* Last tweaked by Mike Spreitzer November 7, 1993 8:58 pm PST */

typedef struct ilu_packet_s *PACKET;

struct ilu_packet_s {
  /*for access and calling: L2 >= {call's conn's iomu};
			    L1, Main unconstrained*/
  unsigned char *buf;
  unsigned char *next;
  unsigned int count;

  ilu_boolean (*put_byte)  (PACKET p, char l );
  ilu_boolean (*put_short) (PACKET p, short l );
  ilu_boolean (*put_long)  (PACKET p, long l );
  ilu_boolean (*put_u_byte)  (PACKET p, unsigned char l );
  ilu_boolean (*put_u_short) (PACKET p, unsigned short l );
  ilu_boolean (*put_u_long)  (PACKET p, unsigned long l );
  ilu_boolean (*put_float) (PACKET p, float l );
  ilu_boolean (*put_double)(PACKET p, double l );
  ilu_boolean (*put_bytes) (PACKET p, unsigned char *bytes,
			    unsigned long int l);
  ilu_boolean (*put_opaque) (PACKET p, unsigned char *bytes,
			     unsigned long int l);

  ilu_boolean (*get_byte)  (PACKET p, char *l);
  ilu_boolean (*get_short) (PACKET p, short *l);
  ilu_boolean (*get_long)  (PACKET p, long *l );
  ilu_boolean (*get_u_byte)  (PACKET p, unsigned char *l );
  ilu_boolean (*get_u_short) (PACKET p, unsigned short *l );
  ilu_boolean (*get_u_long)  (PACKET p, unsigned long *l );
  ilu_boolean (*get_float) (PACKET p, float *l );
  ilu_boolean (*get_double)(PACKET p, double *l );
  ilu_boolean (*get_bytes) (PACKET p, unsigned char **bytes,
			    unsigned long int *l,
			    unsigned long int max_size);
  ilu_boolean (*get_opaque)(PACKET p, unsigned char **bytes,
			    unsigned long int l );

  void (*destroy)(PACKET p);
};

/*L2 >= {call's conn's iomu}; L1, Main unconstrained*/

#define packet_put_byte(p,b)	((*(p)->put_byte)((p),(b)))
#define packet_put_short(p,b)	((*(p)->put_short)((p),(b)))
#define packet_put_long(p,b)	((*(p)->put_long)((p),(b)))
#define packet_put_u_byte(p,b)	((*(p)->put_u_byte)((p),(b)))
#define packet_put_u_short(p,b)	((*(p)->put_u_short)((p),(b)))
#define packet_put_u_long(p,b)	((*(p)->put_u_long)((p),(b)))
#define packet_put_float(p,b)	((*(p)->put_float)((p),(b)))
#define packet_put_double(p,b)	((*(p)->put_double)((p),(b)))
#define packet_put_bytes(p,b,l)	((*(p)->put_bytes)((p),(b),(l)))
#define packet_put_opaque(p,b,l)	((*(p)->put_opaque)((p),(b),(l)))

#define packet_get_byte(p,b)	((*(p)->get_byte)((p),(b)))
#define packet_get_short(p,b)	((*(p)->get_short)((p),(b)))
#define packet_get_long(p,b)	((*(p)->get_long)((p),(b)))
#define packet_get_u_byte(p,b)	((*(p)->get_u_byte)((p),(b)))
#define packet_get_u_short(p,b)	((*(p)->get_u_short)((p),(b)))
#define packet_get_u_long(p,b)	((*(p)->get_u_long)((p),(b)))
#define packet_get_float(p,b)	((*(p)->get_float)((p),(b)))
#define packet_get_double(p,b)	((*(p)->get_double)((p),(b)))
#define packet_get_bytes(p,b,l,lim)	((*(p)->get_bytes)((p),(b),(l),(lim)))
#define packet_get_opaque(p,b,l)	((*(p)->get_opaque)((p),(b),(l)))

#define packet_destroy(p)	((*(p)->destroy)(p))

#define packet_buffer(p)	((p)->buf)
#define packet_size(p)		(((p)->next)-((p)->buf))
#define packet_allocation(p)	((p)->count)
#define packet_pointer(p)	((p)->next)
