/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: llist.c,v 1.2 1993/09/11 01:02:53 janssen Exp $
*/
/*
 * llist.c -- routines for manipulating general doubly-linked lists in C
 *
 * Antony A. Courtney, 8/31/93
 */

#include <stdio.h>
#include "llist.h"

/* llist_add -- add an element to the end of a linked list */
void _ilu_llist_add(ilu_llist_entry *ele,ilu_llist_entry **head,
		ilu_llist_entry **tail)
{
  ilu_llist_entry *trav;

  if (*head==NULL) {
    *head=ele;
    (*head)->next=NULL;
    (*head)->prev=NULL;
    if (tail!=NULL) {
      (*tail)=*head;
    }
    return;
  } 
  /* there is at least one element */
  for (trav=*head; trav->next!=NULL; trav=trav->next) {
  }
  trav->next=ele;
  ele->prev=trav;
  ele->next=NULL;
  if (tail!=NULL) {
    *tail=ele;
  }
}

/* llist_del() -- delete a given entry from a linked list */
void _ilu_llist_del(ilu_llist_entry *ele,ilu_llist_entry **head,
		ilu_llist_entry **tail)
{
  ilu_llist_entry *trav;

  trav=ele;
  if (trav==*head) {
    /* it could be the tail also! */
    if (tail!=NULL) 
      if (trav==*tail)
	*tail=NULL;
    *head=trav->next;
  } else {
    /* not the head, but is it the tail? */
    if (trav->next==NULL) {
      if (tail!=NULL) {
	*tail=(trav->prev);
      }
      (trav->prev)->next=NULL;
    } else {
      /* an element in the middle */
      trav->prev->next=trav->next;
      trav->next->prev=trav->prev;
    }
  }
  
}
