/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: hash.h,v 1.9 1994/01/20 05:02:17 janssen Exp $ */
/* Last tweaked by Mike Spreitzer November 10, 1993 8:35 am PST */

/*L2, Main unconstrained*/

struct hashEntry {
  /*L1 >= {some mutex that protects the table}*/

  ilu_string he_key;
  ilu_refany he_data;
};

struct hashTableSlot {
  /*L1 >= {some mutex that protects the table}*/

  ilu_shortcardinal hs_count;
  ilu_shortcardinal hs_allocated;
  struct hashEntry *hs_entries;
};

typedef struct hashTable {
  /*L1 >= {some mutex that protects the table}*/

  ilu_cardinal ht_size, ht_nPairs;
  ilu_cardinal (*ht_hashfn)(ilu_refany key, ilu_cardinal ht_size);
  ilu_boolean  (*ht_compfn)(ilu_refany key1, ilu_refany key2);
  struct hashTableSlot *ht_slots;
} *HashTable;

typedef struct {
  /*L1 >= {some mutex that protects the table}*/

  HashTable hn_ht;
  ilu_cardinal hn_index, hn_count;
} HashEnumerator;

/*L1 >= {some mutex that protects the table}*/

#define hashtable_slot(ht,index)	(&((ht)->ht_slots[index]))
#define hashtable_size(ht)		((ht)->ht_size)
#define hashtable_hash_index(ht,key)	((*((ht)->ht_hashfn))(key,(ht)->ht_size))
#define hashtable_compare_keys(ht, key1, key2)	((*((ht)->ht_compfn))((key1),(key2)))

typedef ilu_cardinal (*ilu_hashfnptr)(ilu_refany,ilu_cardinal);
typedef ilu_boolean  (*ilu_compfnptr)(ilu_refany,ilu_refany);

#define HASH_INCREMENT_SIZE	5


