#include <stdio.h>

#include "error.h"

ILU_DECL_ERR(NonOrdinal) {
  int val;
};

ILU_DECL_ERR(TooBig) {
  int val;	/* the value that was too big */
  char *s;	/* just for testing, give it a string */
};

ILU_DEF_ERR(NonOrdinal, "A Non-ordinal value was passed to fib") {
  /* no need to free anything */
}

ILU_DEF_ERR(TooBig, "Specified ordinal value was too big") {
  free(e->s);
}

ILU_QUADEF(NonOrdinal)

void ilu_Assert (int v, char *msg)
{
  if (!v)
    printf ("Assert failed:  message is <%s>\n", msg);
}

unsigned int fib (int n, ilu_Error *error)
{
  if (n > 20)
    {
      ILU_ERR_BIND(error, TooBig, ev)
	{
	  ev->val = n;
	  ev->s = (char *) malloc(4);
	  strcpy (ev->s, "foo");
	}
      return 0;
    }
  else if (n < 1)
    {
      ILU_ERR_BIND(error, NonOrdinal, ev)
	{
	  ev->val = n;
	}
      return 0;
    }
  else if (n == 1 || n == 2)
    return 1;
  else
    {
      return (fib(n-1, NULL) + fib(n-2, NULL));
    }
}

main (int ac, char **av)
{
  ilu_Error err1 = NULL;
  unsigned int n;
  int i;

  if (ac < 2)
    {
      fprintf (stderr, "Usage:  %s NUMBER => NUMBER'th Fibonacci number\n", av[0]);
      exit(1);
    }
  i = atoi(av[1]);
  n = fib (i, &err1);

  if (err1 != NULL)
    {
      ILU_ERR_SWITCH (err1)
	ILU_ERR_CASE (NonOrdinal, ev)
	  printf ("Non-ordinal value %d specified\n", ev->val);
        ILU_ERR_ELSE
	  printf ("Unknown error <%s> -- <%s>\n", ILU_ERR_NAME(err1), ILU_ERR_DESCRIPTION(err1))
      ILU_ERR_ENDSWITCH;
      ilu_FreeError (err1);
      exit(1);
    }
  else
    {
      printf ("the %u%s fibonacci number is %u\n", i, (i == 1) ? "st" : (i == 2) ? "nd" : (i == 3) ? "rd" : "th", n);
      exit(0);
    }
}

