/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: dcerpc.h,v 1.2 1994/04/06 22:31:22 printis Exp $ */
/* Last tweaked by Mike Spreitzer November 7, 1993 9:08 pm PST */

#include <stdio.h>

#include <sys/types.h>

#include <fcntl.h>

/*  DCE uses Network Data Representation(NDR) format originated in 
**  the Apollo Domain Architecture. Anyway the struct below is
**  a place holder for the real dce struct.  This will be true
**  for all dce constructs in ilu for some time.  If this looks
**  suspiciously like sunrpc, it is!  (RPrintis 4/6/94)
*/
struct dceRPC {
  /*L2 >= {call's connection's iomu}; L1, Main unconstrained*/
  
  PACKET dce_in;		/* NDR for input from socket */
  PACKET dce_out;		/* NDR for output to socket */
};

typedef struct {
  /*L1 >= {prmu}; L2, Main unconstrained */

  ilu_Class sui_class;
  ilu_string sui_type_id;
  ilu_cardinal sui_pnumber, sui_version;
} dcerpcinfo;

#define DCERPC(conn)	((struct dceRPC *)((conn)->co_protocol_data))

#define PROGRAM_NUMBER_REGISTRY_NAME		"SunRPCRegistry"

#define dcerpc_in(connection)	(DCERPC(connection)->dce_in)
#define dcerpc_out(connection)	(DCERPC(connection)->dce_out)


