(* GooM3Client.m3 *)
(* Last tweaked by Mike Spreitzer April 4, 1994 3:20 pm PDT *)

MODULE GooM3Client EXPORTS Main;
IMPORT Goo, Fmt, IluBasics, ParseParams, RTMisc, Scan, Stdio, Text,
       Thread, Time, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

PROCEDURE FmtIS (is: Goo.IS): TEXT =
  VAR ans := "<";
  BEGIN
    FOR i := 0 TO NUMBER(is^) - 1 DO
      IF i # 0 THEN ans := ans & ", " END;
      ans := ans & "`" & Fmt.Int(is[i]) & "'";
    END (*for*);
    RETURN ans & ">";
  END FmtIS;

VAR sbh, mstid, method: TEXT;
VAR o: Goo.O;
VAR p: Goo.P;
VAR n: INTEGER;
VAR res: Goo.IS;

BEGIN
  TRY
    ParseParams.BeginParsing(Stdio.stderr);
    sbh := ParseParams.GetNext();
    mstid := ParseParams.GetNext();
    method := ParseParams.GetNext();
    IF Text.Equal(method, "m1") THEN
      n := ParseParams.GetNextInt();
      o := Goo.ILU_SBH_To_O(sbh, mstid);
      res := o.m1(n);
      Wr.PutText(Stdio.stdout, "Got " & FmtIS(res) & "\n");
    ELSIF Text.Equal(method, "m2") THEN
      n := ParseParams.GetNextInt();
      p := Goo.ILU_SBH_To_P(sbh, mstid);
      o := p;
      res := p.m2(n);
      Wr.PutText(Stdio.stdout, "Got " & FmtIS(res) & "\n");
    END (*if*);
    ParseParams.EndParsing();
    Wr.Flush(Stdio.stdout);
    Time.LongPause(60);
    Wr.PutText(Stdio.stdout, "Closing surrogate...\n");
    Wr.Flush(Stdio.stdout);
    o.ILU_Close();
    Time.LongPause(30);
  EXCEPT
  | Scan.BadFormat =>
      Wr.PutText(
        Stdio.stderr, "Usage: GooM3Client SBH mstid (m1 i | m2 i)\n");
      RTMisc.Exit(1);
  | IluBasics.Failed (f) =>
      Wr.PutText(
        Stdio.stderr,
        "IluBasics.Failed(" & IluBasics.FullInfo(f) & ")\n");
      RTMisc.Exit(1);
  | Thread.Alerted =>
      Wr.PutText(Stdio.stderr, "Thread.Alerted\n");
      RTMisc.Exit(1);
  | Goo.E1 (v) =>
      Wr.PutText(Stdio.stderr, "Goo.E1(" & FmtIS(v) & ")\n");
      RTMisc.Exit(1);
  END (*try*);
END GooM3Client.
