(* BarM3Client.m3 *)
(* Last tweaked by Mike Spreitzer September 8, 1993 10:37 am PDT *)

MODULE BarM3Client EXPORTS Main;
IMPORT Bar, Fmt, IluBasics, ParseParams, RTMisc, Scan,
       Stdio, Thread, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

VAR sbh, mstid: TEXT;
VAR p: Bar.P;
VAR n, m: INTEGER;

BEGIN
  TRY
    ParseParams.BeginParsing(Stdio.stderr);
    sbh := ParseParams.GetNext();
    mstid := ParseParams.GetNext();
    n := ParseParams.GetNextInt();
    ParseParams.EndParsing();
    p := Bar.ILU_SBH_To_P(sbh, mstid);
    m := p.P1(n);
    Wr.PutText(Stdio.stdout, "Got " & Fmt.Int(m) & "\n");
  EXCEPT
  | Scan.BadFormat =>
      Wr.PutText(
        Stdio.stderr, "Usage: BarPM3Client SBH mstid n\n");
      RTMisc.Exit(1);
  | IluBasics.Failed (f) =>
      Wr.PutText(
        Stdio.stderr,
        "IluBasics.Failed(" & IluBasics.FullInfo(f) & ")\n");
      RTMisc.Exit(1);
  | Thread.Alerted =>
      Wr.PutText(Stdio.stderr, "Thread.Alerted\n");
      RTMisc.Exit(1);
  END (*try*);
END BarM3Client.
