D,#TD1PsT[Begin using 006 escapes](1 0 (NIL 0) (NIL :ITALIC NIL) "CPTFONTI");;; -*- Mode:Common-Lisp; Package:(TETRIS :colon-mode :external); Base:10 -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;       Explorer Double Tetris
;
;       Author:         John Nguyen
;
;       Address:        545 Technology Square, Room 626
;                       Cambridge, MA  02139
;                       (617) 253-6028
;
;       E-mail:         johnn@lcs.mit.edu
;
;       (based on an early version by Joe Morrison)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Brought to Symbolix by Claus Riemann --cla
;; E-mail: riemann@gmdzi.gmd.de

0;; To do for playing Tetris:
;; Set (2 0 (NIL 0) (NIL :BOLD NIL) "CPTFONTCB")*tetris-font-path*0 to your tetris font, compile and load this file,
;; press SELECT #\Space and enjoy

(eval-when (compile load eval)
  (defparameter 2*tetris-font-path* 0"rb:>cla>jwz>tetris>tetris24.bfd.newest")
)

(defmacro 2defmethodd0 (function args 2&body0 body)
  #+Explorer `(defmethod ,function ,args ,@body)
  #-Explorer `(defmethod ,(if (= 2 (length function))
                              (reverse function) 1;; (board :reset) => (:reset board)
0                              (list (nth 2 function) (nth 0 function) (nth 1 function))
                              1;; (board :after :init) => (:init board :after)
0                              ) ,args ,@body))

(defconstant 2*block-size*0 24)

(defconstant 2*score-row*0 80)
(defconstant 2*lines-row*0 120)
(defconstant 2*unnice-lines-row*0 160)
(defconstant 2*level-row*0 200)

(defconstant 2*next-piece-x-offset*0 30)
(defconstant 2*next-piece-y-offset*0 260)

(defconstant 2*normal-bottom-delay*0 30)

#-Explorer
(defvar 2*delaying-time*0 .01
1  "At GAME OVER the looser's board is inverted. This variable handles the speed of it.")

0#-Explorer
(defvar 2*erase-aluf*0 2) 1;; On symbolix there is no w:erase....

0#-Explorer
(defmacro 2backtranslate-bfd0 (font-name)
  1;; Sometimes I load x:>xx>foo.bfd and fonts:foo isn't bound to the loaded font!
0  1;; This macro patches this!
0  `(si:backtranslate-font (fed::find-fontname (fed:bfd-name (fed::font-get-bfd ,font-name)))))
  
#-Explorer
(eval-when (load compile eval)
  (unless (fed::font-get-bfd '43vxms :if-does-not-exist nil)
    (fed::try-to-load-font '43vxms))
  (unless (fed::font-get-bfd 'tr18 :if-does-not-exist nil)
    (fed::try-to-load-font 'tr18))
  (unless (fed::font-get-bfd 'tr18b :if-does-not-exist nil)
    (fed::try-to-load-font 'tr18b))
  (unless (fed::font-get-bfd 'fonts:tetris24 :if-does-not-exist nil)
    (load *tetris-font-path*)
    (si:define-character-style-families
                       si:*b&w-screen* si:*standard-character-set*
                       '(:family :tetris (:size :normal (:face :cla fonts:tetris24)))))
)

(defvar 2*43vxms*
0        #+Explorer 'fonts:43vxms
        #-Explorer (backtranslate-bfd '43vxms))

(defvar 2*tr18*
0        #+Explorer 'fonts:tr18
        #-Explorer (backtranslate-bfd 'tr18))

(defvar 2*tr18b*
0        #+Explorer 'fonts:tr18b
        #-Explorer (backtranslate-bfd 'tr18b))


#+(and Explorer MIT) (require 1"tetris-font" 0"sys:mit.hacks;tetris-font")
#+(and Explorer (not MIT)) (or (load "sys:fonts;tetris-font.xld#>" :if-does-not-exist nil)
                               (load "sys:mit.hacks;tetris-font.xld#>" :if-does-not-exist t))

(defvar 2*tetris-font*
0        #+Explorer fonts:tetris
        #-Explorer (backtranslate-bfd 'fonts:tetris24))


#-Explorer
(defvar 2*device*0 si:*b&w-screen*) 1;; for color -> color-screen


0(defstruct 2options
0  board-width board-height initial-level initial-lines play-mode delay nice-lines
  key-left key-right key-rotate key-drop key-next key-swap use-other-keys)

1;;;==================================================
;;; Function to define the Tetris shapes:
;;;==================================================

0(defvar 2*tetris-shapes*
0        '((((-1  0) ( 0  0) ( 1  0) ( 0  1))    1; XXX
0           (( 0 -1) ( 0  0) ( 0  1) ( 1  0))    1;  X
0           ((-1  0) ( 0  0) ( 1  0) ( 0 -1))
           ((-1  0) ( 0 -1) ( 0  0) ( 0  1)))
          (((-1  0) ( 0  0) ( 1  0) ( 2  0))    1; XXXX
0           (( 0 -1) ( 0  0) ( 0  1) ( 0  2))
           ((-1  0) ( 0  0) ( 1  0) ( 2  0))
           (( 0 -1) ( 0  0) ( 0  1) ( 0  2)))
          (((-1  0) ( 0  0) ( 0 -1) ( 1 -1))    1;  XX
0           ((-1 -1) (-1  0) ( 0  0) ( 0  1))    1; XX
0           ((-1  0) ( 0  0) ( 0 -1) ( 1 -1))
           ((-1 -1) (-1  0) ( 0  0) ( 0  1)))
          (((-1 -1) ( 0 -1) ( 0  0) ( 1  0))    1; XX
0           (( 0 -1) ( 0  0) (-1  0) (-1  1))    1;  XX
0           ((-1 -1) ( 0 -1) ( 0  0) ( 1  0))
           (( 0 -1) ( 0  0) (-1  0) (-1  1)))
          (((-1  0) (-1  1) ( 0  0) ( 1  0))    1; XXX
0           (( 0 -1) ( 0  0) ( 0  1) ( 1  1))    1; X
0           ((-1  0) ( 0  0) ( 1  0) ( 1 -1))
           ((-1 -1) ( 0 -1) ( 0  0) ( 0  1)))
          (((-1  0) ( 0  0) ( 1  0) ( 1  1))    1; XXX
0           (( 0 -1) ( 0  0) ( 0  1) ( 1 -1))    1;   X
0           ((-1 -1) (-1  0) ( 0  0) ( 1  0))
           (( 0 -1) ( 0  0) ( 0  1) (-1  1)))
          (((-1  0) (-1 -1) ( 0  0) ( 0 -1))    1; XX
0           ((-1  0) (-1 -1) ( 0  0) ( 0 -1))    1; XX
0           ((-1  0) (-1 -1) ( 0  0) ( 0 -1))
           ((-1  0) (-1 -1) ( 0  0) ( 0 -1)))))

(defvar 2*shape-bottoms*0 (make-array (list (length *tetris-shapes*) 4 4) :initial-element nil))

(defun 2init-shape-bottoms0 ()
  (dotimes (n (length *tetris-shapes*))
    (dotimes (rot 4)
      (let ((coord-list (nth rot (nth n *tetris-shapes*))))
        (dolist (coord coord-list)
          (let* ((x (car coord))
                 (y (second coord))
                 (low-y (aref *shape-bottoms* n rot (1+ x))))
            (setf (aref *shape-bottoms* n rot (1+ x))
                  (if low-y (max low-y y) y))))))))
(init-shape-bottoms)

(defvar 2*shape-y-offsets*0 '(0 0 1 1 0 0 1))
(defvar 2*shape-x-offsets*0 '(1 1 1 1 1 1 2))

(defvar 2*shape-asymmetric-rotations*0 '(4 2 2 2 4 4 1))

(defparameter 2*level-lines*0 `(10 20 30 40 50 60 70 90 105 ,most-positive-fixnum))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


0(defflavor 2shape
0        (char
         type
         rotation
         coord-list
         x-pos
         y-pos
         x-offset
         y-offset
         array
         delay
         board
         board-width
         board-height
         flash
         flash-count
         flash-length
         draw?
         )
        ()
  :gettable-instance-variables
  :settable-instance-variables
  #+Explorer :inittable-instance-variables
  #-Explorer :initable-instance-variables)

(defvar 2*temp*0 1)

(defun 2my-random0 (ignore)
  (if (>= (incf *temp*) (length *tetris-shapes*))
      (setq *temp* 0))
  *temp*)

(defmethodd (2shape :reset0) ()
  (setq draw? t)
  (setq type (random (length *tetris-shapes*)))
  (setq char type)
  (setq board-width (send board :board-width)
        board-height (send board :board-height))
  (setq delay nil)
  (setq rotation 0)
  (setq x-pos (nth type *shape-x-offsets*)
        y-pos (nth type *shape-y-offsets*))
  (setq array (send (send board :window) :screen-array))
  (setq x-offset *next-piece-x-offset*
        y-offset *next-piece-y-offset*)
  (setq flash nil)
  (send self :init-coord-list)
  )

(defmethodd (2shape :start0) ()
  (setq x-pos (1- (lsh board-width -1))
        y-pos 0)
  (setq x-offset (send board :x-offset)
        y-offset (send board :y-offset)))

(defmethodd (2shape :init-coord-list0) ()
  (setq coord-list (nth rotation (nth type *tetris-shapes*))))

(defmethodd (2shape :draw-block0) (x y alu screen-array)
  (when (and (<= 0 x (- board-width 1))
             (<= 0 y (- board-height 1)))
    #+Explorer
    (w:%draw-character fonts:tetris char nil
                       (+ x-offset (* *block-size* x))
                       (+ y-offset (* *block-size* y))
                       alu
                       screen-array)
    #-Explorer
    (sys:%draw-char (int-char char)
                    (+ x-offset (* *block-size* x)) (+ y-offset (* *block-size* y))
                    alu screen-array *tetris-font*
                    *device*)))

(defmethodd (2shape :draw0) (alu 2&optional0 screen-array)
  (when draw?
    (mapc #'(lambda (coord)
              (send self :draw-block
                    (+ x-pos (first coord)) (+ y-pos (second coord))
                    alu (or screen-array array)))
          coord-list)))

(defmethodd (2shape :flash-on0) ()
  (setq flash :on
        flash-count 3
        flash-length 7))

(defmethodd (2shape :flash-off0) ()
  (setq flash nil))

(defmethodd (2shape :maybe-flash0) ()
  (when flash
    (when (zerop (decf flash-count))
      (case flash
        (:on (send self :draw #+Explorer w:erase #-Explorer *erase-aluf*)
         (setq flash :off))
        (:off (send self :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
         (setq flash :on)))
      (setq flash-count 3)
      (when (zerop (decf flash-length))
        (send board :maybe-swap-pieces)))))

#-Explorer
(defun 2!and0 (2&rest0 body)
  1;; On Symbolix I can't say: (apply #'and '(t t nil))
0  (if body
      (loop while (cdr body)
            unless (eval (pop body)) return nil
            finally (return (eval (car body))))
      t))
  
(defmethodd (2shape :check0) (blocks)
  1;; this let is needed for lexical binding
0  (let ((bwidth (send self :board-width))
        (bheight (send self :board-height)))
    (apply #+Explorer #'and #-Explorer #'!and
           (mapcar #'(lambda (coord)
                       (check-coord (+ (first coord) x-pos)
                                    (+ (second coord) y-pos)
                                    bwidth
                                    bheight
                                    blocks))
                   coord-list))))

(defun 2check-coord0 (x y board-width board-height blocks)
  (and (<= 0 x (1- board-width))
       (< y board-height)
       (or (< y 0) (= (aref blocks y x) 0))))   1; Not on another piece!

0(defmethodd (2shape :check-down0) (blocks)
  (incf y-pos 1)
  (let ((result (send self :check blocks)))
    (decf y-pos 1)
    result))

(defmethodd (2shape :down0) (blocks)
  (if (send self :check-down blocks)
      (progn
        (send self :draw #+Explorer w:erase #-Explorer *erase-aluf*)
        (incf y-pos 1)
        (send self :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
        (setq delay nil)
        t)
      (unless delay
        (setq delay t))))

(defmethodd (2shape :down-all0) (blocks)
  (loop for rows from -1
        while (and (not delay) (send self :down blocks))
        finally
          (return rows)))

(defmethodd (2shape :check-horiz0) (blocks delta)
  (incf x-pos delta)
  (let ((result (send self :check blocks)))
    (decf x-pos delta)
    result))

(defmethodd (2shape :horiz0) (blocks delta)
  (if (send self :check-horiz blocks delta)
      (progn
        (send self :draw #+Explorer w:erase #-Explorer *erase-aluf*)
        (incf x-pos delta)
        (send self :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
        (when (send self :check-down blocks)
          (setq delay nil))
        t)
      nil))

(defmethodd (2shape :left0) (blocks)
  (send self :horiz blocks -1))

(defmethodd (2shape :right0) (blocks)
  (send self :horiz blocks 1))

(defmethodd (2shape :check-rotate0) (blocks)
  (setq rotation (mod (1+ rotation) 4))
  (send self :init-coord-list)
  (let ((result (send self :check blocks)))
    (setq rotation (mod (1- rotation) 4))
    (send self :init-coord-list)
    result))

(defmethodd (2shape :rotate0) (blocks)
  (if (send self :check-rotate blocks)
      (progn
        (send self :draw #+Explorer w:erase #-Explorer *erase-aluf*)
        (setq rotation (mod (1+ rotation) 4))
        (send self :init-coord-list)
        (send self :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
        (when (send self :check-down blocks)
          (setq delay nil))
        t)
      nil))

(defmethodd (2shape :add-to-blocks0) (blocks)
  (send self :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
  (block add-to-blocks
    (mapc #'(lambda (coord)
              (if (< (+ (second coord) y-pos) 0)
                  (return-from add-to-blocks nil)
                  (setf (aref blocks (+ (second coord) y-pos) (+ (car coord) x-pos))
                        1)))
          coord-list)
    t))

(defmethodd (2shape :add-to-tblocks0) (blocks)
  (mapc #'(lambda (coord)
            (unless (< (+ (second coord) y-pos) 0)
              (setf (aref blocks (+ (car coord) x-pos) (- board-height (+ (second coord) y-pos) 1))
                    1)))
        coord-list))

(defmethodd (2shape :remove-from-tblocks0) (blocks)
  (mapc #'(lambda (coord)
            (unless (< (+ (second coord) y-pos) 0)
              (setf (aref blocks (+ (car coord) x-pos) (- board-height (+ (second coord) y-pos) 1))
                    0)))
        coord-list))

(defmethodd (2shape :line-range0) ()
  (let ((coords (mapcar #'(lambda (c) (+ (second c) y-pos)) coord-list)))
    (values (apply #'min coords) (apply #'max coords))))


1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;==================================================
;;; The physical Tetris display:
;;;==================================================

0(defflavor 2board
0        (window                                 1; The physical lispM window to use
0         stats-window
         board-height
         board-width
         x-offset
         y-offset
         last-timeout                           1; Last time the block dropped
0         drop-delay                             1; Time between drops (60th of a sec)
0         bottom-delay                           1; Time at bottom
0         blocks                                 1; The blocks in place already
0         block-rows
         line-status
         shape                                  1; The current shape that's falling
0         next-shape                             1; The next shape
0         mode
         show-next
         count
         score
         level
         num-lines
         unnice-lines
         key-left
         key-right
         key-rotate
         key-drop
         key-next
         key-swap
         swappable?
         options
         opponent
         auto-player
1;           (process nil)
0         )
        ()
  :gettable-instance-variables
  :settable-instance-variables
  #+Explorer :inittable-instance-variables
  #-Explorer :initable-instance-variables)


1;;;==================================================
;;; Initializing the display:
;;;==================================================

;; The method (board :after :init) has been moved after (defflavor auto-player ...),
;; coz' then the compiler recognizes auto-player has a flavor!

0(defmethodd (2board :reset0) (x-off y-off op)
  (setq board-width (options-board-width options)
        board-height (options-board-height options))
  (setq opponent op)
  (let ((width (* *block-size* board-width))
        (height (* *block-size* board-height)))
    (setq x-offset x-off
          y-offset y-off)
    (let ((x1 (- x-offset 5))
          (y1 (- y-offset 5))
          (width1 (+ width 8))
          (height1 (+ height 8)))
      #+Explorer (send window :draw-rectangle x1 y1 width1 height1 3)
      #-Explorer (send window :draw-rectangle (- width1 2) (- height1 2) x1 y1 tv:alu-seta)
      #+Explorer (send window :draw-rectangle x1 y1 width1 height1 1 w:black w:erase)
      #-Explorer (send window :draw-rectangle (- width1 8) (- height1 8)
                       (+ 3 x1) (+ 3 y1) *erase-aluf*)))

  1;; Initialize the time (used for input):
0  (setf last-timeout #+Explorer (time) #-Explorer (zl:time))
  
  (send self :set-level
        #+Explorer (- (char-int (options-initial-level options)) 48)
        #-Explorer (options-initial-level options))

  1;; Initialize the "blocks world":

0  #+Explorer (w:%draw-rectangle 32 32 0 0 w:erase blocks)
  #-Explorer (sys:%draw-rectangle 32 32 0 0 *ERASE-ALUF* blocks)
  
  (setq bottom-delay
        (if (eq (options-play-mode options) :advanced)
            (lsh *normal-bottom-delay* -1)
            *normal-bottom-delay*))

  (when (eq (options-play-mode options) :auto)
    (send auto-player :initialize)
1;    (unless process
;      (setq process (process-run-function '(:name "Auto Tetris"); :priority -10 :quantum 10)
;                                         auto-player :wait)))
0    )

  (let ((key-options (if (and (options-use-other-keys options) opponent)
                         (send opponent :options)
                         options)))
    (setq key-left (options-key-left key-options)
          key-right (options-key-right key-options)
          key-rotate (options-key-rotate key-options)
          key-drop (options-key-drop key-options)
          key-next (options-key-next key-options)
          key-swap (options-key-swap key-options)))

  (send self :setup-blocks (options-initial-lines options))

  (setq score 0)
  (setq num-lines 0)
  (setq unnice-lines 0)
  (send stats-window :update-score score)
  (send stats-window :update-lines num-lines unnice-lines)

  (setq swappable? nil)
  (setq show-next nil)
  (send next-shape :reset)
  (send self :start-new-object)
  (setq mode :normal)

  )

(defmethodd (2board :after :set-level0) (l)
  (send stats-window :update-level l)
  (setq drop-delay (floor (* (+ 3 (* 5 (- 9 l)))
                             (if (eq (options-play-mode options) :advanced) .5 1)))))

(defmethodd (2board :up-level0) ()
  (when (< level 9)
    (send self :set-level (1+ level))))

(defmethodd (2board :setup-blocks0) (lines)
  (loop for y from (- board-height lines) below board-height
        do
    (loop with cnt = 0
          until (= cnt 4)
          for x = (random board-width)
          when (zerop (aref blocks y x))
            do
              (send self :add-block x y)
              (incf cnt))))

(defmethodd (2board :check-timeout0) ()
  (let ((time #+Explorer (time) #-Explorer (zl:time)))
    (when (> (time-difference time last-timeout)
             (if (send shape :delay) bottom-delay drop-delay))
      (setf last-timeout time)
      t)))


1;;;==================================================
;;; Start a new object falling:
;;;==================================================

0(defmethodd (2board :start-new-object0) ()
  (setq swappable? t)
  (when show-next
    (send stats-window :draw-next-piece next-shape
          #+Explorer w:erase #-Explorer *ERASE-ALUF*))
  (let ((old-shape shape))
    (setq shape next-shape)
    (setq next-shape old-shape))
  (send shape :start)
  (send next-shape :reset)
  (when show-next
    (send stats-window :draw-next-piece next-shape
          #+Explorer w:normal #-Explorer TV:ALU-SETA))
  (if (send shape :check blocks)
      (progn
        (send shape :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
        (setq mode :normal))
      (progn
        (loop until (send shape :check blocks) do
          (send shape :set-y-pos (1- (send shape :y-pos))))
        (send shape :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
        (setq mode :end)))
  (when (eq (options-play-mode options) :auto)
1;    (send process :preset auto-player :new-piece)))
0    (send auto-player :new-piece)))

(defmethodd (2board :toggle-show-next0) ()
  (when show-next
    (send stats-window :draw-next-piece next-shape
          #+Explorer w:erase #-Explorer *ERASE-ALUF*))
  (setq show-next (not show-next))
  (when show-next
    (send stats-window :draw-next-piece next-shape
          #+Explorer w:normal #-Explorer TV:ALU-SETA)))

(defmethodd (2board :swap-pieces0) (this-shape that-shape)
  (let ((this-type (send this-shape :type))
        (that-type (send that-shape :type))
        (this-rot (send this-shape :rotation))
        (that-rot (send that-shape :rotation)))
    (send this-shape :set-type that-type)
    (send that-shape :set-type this-type)
    (send this-shape :set-char that-type)
    (send that-shape :set-char this-type)
    (send this-shape :set-rotation that-rot)
    (send that-shape :set-rotation this-rot)
    (send this-shape :init-coord-list)
    (send that-shape :init-coord-list)))

(defmethodd (2board :start-swap-pieces0) ()
  (when (and opponent swappable?
             (eq mode :normal)
             (eq (send opponent :mode) :normal))
    (setq swappable? nil)
    (let* ((that-shape shape)
           (this-shape (send opponent :shape)))
      (send this-shape :flash-on)
      (send that-shape :flash-on))))

(defmethodd (2board :maybe-swap-pieces0) ()
  (let* ((that-shape shape)
         (this-shape (send opponent :shape)))
    (when (and (eq mode :normal)
               (eq (send opponent :mode) :normal))
      (send this-shape :draw #+Explorer w:erase #-Explorer *ERASE-ALUF*)
      (send that-shape :draw #+Explorer w:erase #-Explorer *ERASE-ALUF*)
      (send self :swap-pieces this-shape that-shape)
      (if (and (send this-shape :check blocks)
               (send that-shape :check (send opponent :blocks)))
          (progn
            (setq swappable? nil)
            (send opponent :set-swappable? nil))
          (progn
            (send self :swap-pieces this-shape that-shape)))
      (send this-shape :draw #+Explorer w:normal #-Explorer TV:ALU-SETA)
      (send that-shape :draw #+Explorer w:normal #-Explorer TV:ALU-SETA))
    (send this-shape :flash-off)
    (send that-shape :flash-off)))

(defmethodd (2board :drop-object0) ()
  (unless (send shape :down blocks)
    (send self :add-object-to-blocks 0)))

(defmethodd (2board :drop-object-all0) ()
  (let ((bonus (send shape :down-all blocks)))
    (send self :add-object-to-blocks bonus)))

(defmethodd (2board :move-object-left0) ()
  (send shape :left blocks))

(defmethodd (2board :move-object-right0) ()
  (send shape :right blocks))

(defmethodd (2board :rotate-object0) ()
  (send shape :rotate blocks))

(defmethodd (2board :add-object-to-blocks0) (bonus)
  (when opponent
    (send shape :flash-off)
    (send (send opponent :shape) :flash-off))
  (if (send shape :add-to-blocks blocks)
      (multiple-value-bind (line-top line-bottom)
          (send shape :line-range)
        (incf score (floor (* (+ 4 (* level 2) bonus (- board-height (send shape :y-pos)))
                              (if show-next .75 1))))
        (if (send self :find-full-lines line-top line-bottom)
            (progn
              (setq mode :flash)
              (setq count 12))
            (send self :start-new-object))
        (send stats-window :update-score score))
      (setq mode :end)))

(defmethodd (2board :flash0) ()
  (if (> count 0)
      (progn
        (if (evenp count)
            (loop for row from 0 below board-height
                  when (aref line-status row)
                    do
                      #+Explorer 
                      (w:%draw-rectangle (* *block-size* board-width) *block-size*
                                         x-offset (+ y-offset (* *block-size* row)) w:opposite
                                         (send window :screen-array))
                      #-Explorer 
                      (sys:%draw-rectangle (* *block-size* board-width) *block-size*
                                           x-offset (+ y-offset (* *block-size* row))
                                           TV:ALU-XOR (send window :screen-array))))
        (decf count))
      (progn
        (loop for row from 0 below board-height
              when (aref line-status row)
                do
                  #+Explorer
                  (w:%draw-rectangle (* *block-size* board-width) *block-size*
                                     x-offset (+ y-offset (* *block-size* row)) w:erase
                                     (send window :screen-array))
                  #-Explorer
                  (sys:%draw-rectangle (* *block-size* board-width) *block-size*
                                       x-offset (+ y-offset (* *block-size* row))
                                       *ERASE-ALUF* (send window :screen-array)))
        (setq mode :clear-wait)
        (setq count 6))))

(defmethodd (2board :clear-wait0) ()
  (if (> count 0)
      (decf count)
      (progn
        (send self :clear-lines)
        (send self :start-new-object))))

(defmethodd (2board :clear-lines0) ()
  (loop with line-count = 0
        for row from 0 below board-height
        when (aref line-status row)
          do
            (incf num-lines)
            (incf line-count)
            (when (and (< level 9)
                       (>= num-lines (nth level *level-lines*))
                       (or (not opponent) (>= (send opponent :num-lines) num-lines)))
              (send self :up-level)
              (when (and opponent (< (send opponent :level) level))
                (send opponent :up-level)))
            (send self :move-rows 0 1 (- row))
            (send self :blank-row 0)
            (when (> line-count (options-nice-lines options))
              (incf unnice-lines)
              (when opponent
                (send opponent :add-row))))
  (send stats-window :update-lines num-lines unnice-lines))

(defmethodd (2board :move-rows0) (from to height)
  (bitblt #+Explorer w:normal #-Explorer TV:ALU-SETA
          board-width height blocks 0 from blocks 0 to)
  (bitblt #+Explorer w:normal #-Explorer TV:ALU-SETA
          (* *block-size* board-width) (* *block-size* height)
          (send window :screen-array) x-offset (+ y-offset (* *block-size* from))
          (send window :screen-array) x-offset (+ y-offset (* *block-size* to))))

(defmethodd (2board :blank-row0) (row)
  #+Explorer
  (w:%draw-line 0 row (1- board-width) row w:erase t blocks)
  #-Explorer
  (sys:%draw-line 0 row (1- board-width) row *ERASE-ALUF* t blocks)
  #+Explorer
  (w:%draw-rectangle (* *block-size* board-width) *block-size*
                     x-offset (+ y-offset (* *block-size* row)) w:erase
                     (send window :screen-array))
  #-Explorer
  (sys:%draw-rectangle (* *block-size* board-width) *block-size*
                       x-offset (+ y-offset (* *block-size* row)) *ERASE-ALUF*
                       (send window :screen-array)))

(defmethodd (2board :add-block0) (x y)
  #+Explorer
  (w:%draw-character fonts:tetris (random (length *tetris-shapes*)) nil
                     (+ x-offset (* x *block-size*))
                     (+ y-offset (* y *block-size*))
                     w:normal (send window :screen-array))
  #-Explorer
  (sys:%draw-char (int-char (random (length *tetris-shapes*)))
                  (+ x-offset (* x *block-size*)) (+ y-offset (* y *block-size*))
                  TV:ALU-SETA (send window :screen-array) *tetris-font* *device*)
  (setf (aref blocks y x) 1))

(defmethodd (2board :add-row0) ()
  (send shape :draw #+Explorer w:erase #-Explorer *ERASE-ALUF*)
  (dotimes (i board-width)
    (when (plusp (aref blocks 0 i))
      (setq mode :end)))
  (send self :move-rows 1 0 (- board-height 1))
  (send self :blank-row (- board-height 1))
  (dotimes (row (1- board-height))
    (setf (aref line-status row)
          (aref line-status (1+ row))))
  (setf (aref line-status (1- board-height)) nil)
  (let ((hole (random board-width)))
    (dotimes (i board-width)
      (when (/= i hole)
        (send self :add-block i (- board-height 1)))))
  (unless (send shape :check blocks)
    (if (< (send shape :y-pos) 1)
        (setq mode :end)
        (send shape :set-y-pos (1- (send shape :y-pos)))))
  (send shape :draw #+Explorer w:normal #-Explorer TV:ALU-SETA))

1;;;==================================================
;;; Find all the lines that are full (i.e. that should
;;; disappear):
;;;==================================================

0#-Explorer
(defun 2array-initialize0 (array cont)
  (loop for i below (array-dimension array 0)
        do (setf (aref array i) cont)))

(defmethodd (2board :find-full-lines0) (top bottom)
  (array-initialize line-status nil)
  (loop with flag = nil and full-value = (1- (ash 1 board-width ))
        for row from bottom downto top do
    (when (= (aref block-rows row) full-value)
      (setq flag t)
      (setf (aref line-status row) t))
        finally
          (return flag)))
                      
(defmethodd (2board :peek-char0) ()
  (send window :listen))

(defmethodd (2board :tick0) (char)
  (block tick
    (case mode
      (:normal
        (when (eq (options-play-mode options) :auto)
          (let ((time #+Explorer (time) #-Explorer (zl:time)))
            (loop with go = t
                  while (and (zerop (time-difference #+Explorer (time) #-Explorer (zl:time)
                                                     time))
                             go)
                  do
              (setq go (and (not (send self :peek-char))
                            (send auto-player :tick))))))
        (select char
          (key-left (send self :move-object-left))
          (key-right (send self :move-object-right))
          (key-rotate (send self :rotate-object))
          (key-drop (send self :drop-object-all))
          (key-next (send self :toggle-show-next))
          (key-swap (send self :start-swap-pieces))
          )
        (send shape :maybe-flash)
        (when (send self :check-timeout) (send self :drop-object)))
      (:flash
        (send self :flash))
      (:clear-wait
        (send self :clear-wait))
      (:end
        (let ((width (* *block-size* board-width))
              (height (* *block-size* board-height)))
          (loop for i from 0 below (lsh height -1) do
            #+Explorer 
            (w:%draw-line x-offset (+ y-offset i)
                          (+ x-offset width -1) (+ y-offset i)
                          w:opposite t (send window :screen-array))
            #-Explorer
            (sys:%draw-line x-offset (+ y-offset i) (+ x-offset width -1) (+ y-offset i)
                            TV:ALU-XOR t (send window :screen-array))
            #+Explorer
            (w:%draw-line x-offset (+ y-offset (- height i 1))
                          (+ x-offset width -1) (+ y-offset (- height i 1))
                          w:opposite t (send window :screen-array))
            #-Explorer
            (sys:%draw-line x-offset (+ y-offset (- height i 1))
                            (+ x-offset width -1) (+ y-offset (- height i 1))
                            TV:ALU-XOR t (send window :screen-array))
            #+Explorer (tv:delay 3000)
            #-Explorer (sleep *delaying-time* :sleep-reason "Game Over")
            )
          #+Explorer (process-sleep 10)
          #-Explorer (zl:process-sleep 10)
          #+Explorer
          (w:%draw-rectangle width height x-offset y-offset
                             w:opposite (send window :screen-array))
          #-Explorer
          (sys:%draw-rectangle width height x-offset y-offset
                               TV:ALU-XOR (send window :screen-array)))
        (return-from tick nil)))
    t))


1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

0(defflavor 2options-window0 (options other-options)
           (#+Explorer w:choose-variable-values-pane #-Explorer tv:choose-variable-values-pane)
  :gettable-instance-variables
  :settable-instance-variables
  #+Explorer :inittable-instance-variables
  #-Explorer :initable-instance-variables
  (:default-init-plist
   #+Explorer :scroll-bar-side #+Explorer :right
   #+Explorer :scroll-bar-mode #+Explorer :maximum
   :margin-choices nil
   :variables nil
   #+Explorer :value-tab #+Explorer 80
   :name-font fonts:cptfont
   :value-font fonts:hl12
   :string-font fonts:hl12b
   :unselected-choice-font fonts:tr10
   :selected-choice-font fonts:tr10b
   :label nil
   #+Explorer :stack-group #+Explorer current-stack-group
   ))

1;; We've a problem:
;; On symbolix there seems to be no :constraint-option for :set-variables
;; so I hack it without thinking... Status: works and dirty

0#-Explorer
tv:(progn
(defprop :constraint constrainter
         CHOOSE-VARIABLE-VALUES-KEYWORD-FUNCTION)

(defun 2constrainter0 (kwd-and-args)
  (values #'(lambda (obj stream) 1;; seems to be not needed, but who knows?
0                (if obj
                    (let ((base 10))
                      (prin1 obj stream))
                    (princ "none" stream)))
            #'(lambda (stream)
                (funcall (getf kwd-and-args :constraint) stream))
            nil nil nil "huhu"))
)

#+Explorer 
(defun 2options-check-width0 (window var old-value new-value)
  (ignore var old-value)
  (let ((window-width (send (send (send window :superior) :graphics-pane) :inside-width)))
    (when (> (* *block-size* new-value) window-width)
      (format nil "Width must be less than ~d" (floor window-width *block-size*)))))

#-Explorer
(defun 2options-check-width0 (window) 1;; name of def isn't correct ...
0  (si:read-integer window 10 nil 5
                            (1- (ceiling (send (send (send window :superior) :graphics-pane)
                                               :inside-width) *block-size*))))

#+Explorer
(defun 2options-check-height0 (window var old-value new-value)
  (ignore var old-value)
  (let ((window-height (send (send (send window :superior) :graphics-pane) :inside-height)))
    (when (> (* *block-size* new-value) window-height)
      (format nil "Height must be less than ~d" (floor window-height *block-size*)))))

#-Explorer
(defun 2options-check-height0 (window)
  (si:read-integer window 10 nil 5
                            (1- (ceiling (send (send (send window :superior) :graphics-pane)
                                               :inside-height) *block-size*))))

#+Explorer
(defun 2options-check-level0 (window var old-value new-value)
  (ignore window var old-value)
  (unless (<= #\0 new-value #\9)
    (format nil "Level must be between 0 and 9")))

#-Explorer 
(defun 2options-check-level0 (window)
  (si:read-integer window 10 nil 0 9))
  
(defmethodd (2options-window :initialize0) (keys)
  (setq options
        (make-options :board-height 20
                      :board-width 10
                      :initial-level #+Explorer #\5 #-Explorer 5
                      :initial-lines 0
                      :play-mode :normal
                      :nice-lines 1
                      :delay 1
                      :key-left (first keys)
                      :key-right (second keys)
                      :key-rotate (third keys)
                      :key-drop (fourth keys)
                      :key-next (fifth keys)
                      :key-swap (sixth keys)
                      :use-other-keys nil
                      ))
  (send self :set-variables
        `(""
          (,(locf (options-board-width  options)) " Width"
           :documentation "Width of playing board"
           :constraint options-check-width
           #+Explorer :typep #+Explorer (integer 5 32)
           )
          (,(locf (options-board-height options)) " Height"
           :documentation "Height of playing board"
           :constraint options-check-height
           #+Explorer :typep #+Explorer (integer 5 32)
           )
          ""
          (,(locf (options-initial-level options)) " Level"
           :documentation "Initial level"
           :constraint options-check-level #+Explorer :character #-Explorer :integer)
          (,(locf (options-initial-lines options)) " Lines"
           :documentation "Initial lines with random blocks" :choose (0 4 7 10 13))
          ""
          (,(locf (options-play-mode options)) " Mode"
           :documentation "Active or deactivate board"
           :choose (:normal :advanced :auto :inactive))
          ""
          (,(locf (options-delay options)) " Delay"
           :documentation "Delay for piece movement in auto mode (in 1/60 sec)"
           #+Explorer :typep #+Explorer (integer 0 20))
          ""
          (,(locf (options-nice-lines options)) " Nice"
           :documentation "Number of cleared lines that do not show up on opponent"
           :choose (0 1 2 3 4))
          ""
          (,(locf (options-key-left   options)) " Left"
           :documentation "Move left character" :character)
          (,(locf (options-key-right  options)) " Right"
           :documentation "Move right character" :character)
          (,(locf (options-key-rotate options)) " Rotate"
           :documentation "Rotate character" :character)
          (,(locf (options-key-drop   options)) " Drop"
           :documentation "Drop piece character" :character)
          (,(locf (options-key-next   options)) " Next"
           :documentation "Toggle show next piece character" :character)
          (,(locf (options-key-swap   options)) " Swap"
           :documentation "Swap pieces character" :character)
          (,(locf (options-use-other-keys options)) " Use other"
           :documentation "Use key definitions of other board" :boolean)
          )))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

0(defflavor 2tetris-window
0        (board1
         board2
         options1
         options2
         )
        (#+Explorer w:window-with-typeout-mixin #-Explorer tv:window-with-typeout-mixin
         #+Explorer w:list-mouse-buttons-mixin
         #+Explorer w:notification-mixin #-Explorer tv:notification-mixin
         #+Explorer w:window #-Explorer tv:window)
  :gettable-instance-variables
  :settable-instance-variables
  #+Explorer :inittable-instance-variables
  #-Explorer :initable-instance-variables
  (:default-init-plist
   :typeout-window #+Explorer '(w:typeout-window) #-Explorer '(tv:typeout-window)
   :label nil
   :blinker-p nil
   :save-bits t
   ))

(defmethodd (2tetris-window :initialize0) (o1 o2)
  (setq options1 o1 options2 o2)
  (send #+Explorer w:typeout-window #-Explorer tv:typeout-window :make-complete)
  (setq board1 (make-instance 'board)
        board2 (make-instance 'board))
  (send board1 :set-window self)
  (send board2 :set-window self)
  (send board1 :set-stats-window (send (send self :superior) :stats1-pane))
  (send board2 :set-stats-window (send (send self :superior) :stats2-pane))
  (send board1 :set-options options1)
  (send board2 :set-options options2)
  #-Explorer (setq *erase-aluf* (send self :erase-aluf))
  )

(defmethodd (2tetris-window :center-string0) (string y font)
  #-Explorer (declare (ignore font))
  #+Explorer 
  (send self :string-out-centered-explicit string
        (w:sheet-inside-left) y (w:sheet-inside-right) nil font)
  #-Explorer
  (send self :display-centered-string string (tv:sheet-inside-left) (tv:sheet-inside-right)
        y))

(defmethodd (2tetris-window :run0) ()
  (let ((*terminal-io* self)
        (*debug-io* (send self :typeout-window)))
    (error-restart ((error sys:abort) "Tetris top level.")
      (when (send (send self :typeout-window) :bottom-reached)
        (send (send self :typeout-window) :deactivate))
      (send self :select)
      (send (send (send self :superior) :stats1-pane) :erase-next-piece)
      (send (send (send self :superior) :stats2-pane) :erase-next-piece)
      (send self #+Explorer :clear-screen #-Explorer :clear-window)
      (send self :center-string "Double"
            (- (lsh #+Explorer w:height #-Explorer tv:height -1) 30) *43vxms*)
      (send self :center-string "Tetris"
            (+ (lsh #+Explorer w:height #-Explorer tv:height -1) 30) *43vxms*)
      (#+Explorer do-forever #-Explorer loop #-Explorer do
       (send self :center-string "Press RETURN to begin"
             (- #+Explorer w:height #-Explorer tv:height 30) *tr18*)
       (loop for char = (send self :any-tyi)
             until (and #+Explorer (atom char)
                        #-Explorer (characterp char)
                        #+Explorer (equal (int-char char) #\return)
                        #-Explorer (char= char #\return))
             do
         (when (and (consp char) (eq (car char) :variable-choice))
           (#+Explorer w:choose-variable-values-process-message
            #-Explorer tv:choose-variable-values-process-message
            (second char)
            char)))
       (send self :game)
       ))))

(defmethodd (2tetris-window :game0) ()
  (send self #+Explorer :clear-screen #-Explorer :clear-window)
  (cond ((and (eq (options-play-mode options1) :inactive)
              (eq (options-play-mode options2) :inactive))
         nil)
        ((eq (options-play-mode options2) :inactive)
         (send self :setup-board board1 options1)
         (send board2 :set-mode nil)
         (send self :play))
        ((eq (options-play-mode options1) :inactive)
         (send self :setup-board board2 options2)
         (send board1 :set-mode nil)
         (send self :play))
        (t
         (when (send self :setup-both-boards)
           (send self :play)))))

(defmethodd (2tetris-window :setup-board0) (board options)
  (send board :reset
        (lsh (- #+Explorer w:width #-Explorer tv:width
                (* *block-size* (options-board-width options))) -1)
        (lsh (- #+Explorer w:height #-Explorer tv:height
                (* *block-size* (options-board-height options))) -1)
        nil))

(defmethodd (2tetris-window :setup-both-boards0) ()
  (let* ((max-height (max (options-board-height options1)
                          (options-board-height options2)))
         (top (lsh (- #+Explorer w:height #-Explorer tv:height
                      (* *block-size* max-height)) -1))
         (left (floor (- #+Explorer w:width #-Explorer tv:width
                         (* *block-size* (+ (options-board-width options1)
                                            (options-board-width options2))))
                      3)))
    (if (or (minusp top) (minusp left))
        (progn
          (send self :center-string "Boards are too large!"
                (floor #+Explorer w:height #-Explorer tv:height 3) *tr18*)
          nil)
        (progn
          (send board1 :reset
                left
                (+ top (* *block-size* (- max-height (options-board-height options1))))
                board2)
          (send board2 :reset
                (+ left (* *block-size* (options-board-width options1)) left)
                (+ top (* *block-size* (- max-height (options-board-height options2))))
                board1)
          t))))
  
(defmethodd (2tetris-window :play0) ()
  (loop with go = t
        while go
        do
    (process-allow-schedule)
    (let ((char (when (and (or (send board2 :mode) (eq (send board1 :mode) :normal))
                           (or (send board1 :mode) (eq (send board2 :mode) :normal)))
                  (read-char-no-hang))))
      (setq go (and (or (not (send board1 :mode)) (send board1 :tick char))
                    (or (not (send board2 :mode)) (send board2 :tick char))))
      (when (equal char #\p) (send self :tyi))))
  (send (send (send self :superior) :stats1-pane) :erase-next-piece)
  (send (send (send self :superior) :stats2-pane) :erase-next-piece)
  (send self :center-string "Game Over" 10 *43vxms*))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

0(defflavor 2stats-window
0        ()
        (#+Explorer w:window #-Explorer tv:window)
  (:default-init-plist
   :blinker-p nil
   :save-bits t
   :label nil
   #+Explorer :font-map #+Explorer (list *tr18b* *tr18*)))

(defmethodd (2stats-window :initialize0) (number)
  #+Explorer 
  (send self :string-out-centered-explicit (format nil "~d" number)
        (w:sheet-inside-left) 10 (w:sheet-inside-right) nil *43vxms*)
  #-Explorer
  (send self :display-centered-string (format nil "~d" number) (tv:sheet-inside-left)
        (tv:sheet-inside-right) 10)
  (send self #+Explorer :set-current-font #-Explorer :set-default-character-style *tr18*)
  (send self :set-cursorpos 10 *score-row*)
  (format self "Score")
  (send self :set-cursorpos 10 *lines-row*)
  (format self "Lines")
  (send self :set-cursorpos 10 *unnice-lines-row*)
  (format self "% ~c" (if (= number 1) #\ #\))
  (send self :set-cursorpos 10 *level-row*)
  (format self "Level")
  (send self #+Explorer :set-current-font #-Explorer :set-default-character-style *tr18b*))

(defmethodd (2stats-window :update-score0) (score)
  (send self :set-cursorpos 70 *score-row*)
  (send self #+Explorer :clear-eol #-Explorer :clear-rest-of-line)
  (format self "~7d" score))

(defmethodd (2stats-window :update-lines0) (lines unnice-lines)
  (send self :set-cursorpos 70 *lines-row*)
  (send self #+Explorer :clear-eol #-Explorer :clear-rest-of-line)
  (format self "~7d" lines)
  (send self :set-cursorpos 70 *unnice-lines-row*)
  (send self #+Explorer :clear-eol #-Explorer :clear-rest-of-line)
  (format self "    ~3d" (round (* unnice-lines 100) (max lines 1)))
  )

(defmethodd (2stats-window :update-level0) (level)
  (send self :set-cursorpos 70 *level-row*)
  (send self #+Explorer :clear-eol #-Explorer :clear-rest-of-line)
  (format self "~7d" level))

(defmethodd (2stats-window :draw-next-piece0) (shape alu)
  (send shape :draw alu #+Explorer w:screen-array #-Explorer tv:screen-array))

(defmethodd (2stats-window :erase-next-piece0) ()
  #+Explorer
  (w:%draw-rectangle (* *block-size* 4) (* *block-size* 3)
                     *next-piece-x-offset*
                     *next-piece-y-offset*
                     w:erase w:screen-array)
  #-Explorer
  (sys:%draw-rectangle (* *block-size* 4) (* *block-size* 3)
                       *next-piece-x-offset* *next-piece-y-offset*
                       *erase-aluf* tv:screen-array))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

0(defun 2start-tetris0 (window)
  (send window :run))

(defflavor 2tscreen
0        (graphics-pane
         options1-pane
         options2-pane
         stats1-pane
         stats2-pane)
        (#+Explorer w:process-mixin #-Explorer tv:process-mixin
         #+Explorer w:select-mixin #-Explorer tv:select-mixin
         #+Explorer w:alias-for-inferiors-mixin
         #+Explorer w:inferiors-not-in-select-menu-mixin
         #+Explorer w:bordered-constraint-frame-with-shared-io-buffer
         #-Explorer tv:bordered-constraint-frame-with-shared-io-buffer)
  :gettable-instance-variables
  :settable-instance-variables
  (:default-init-plist
   :process '(start-tetris)
   :panes
   '((graphics tetris-window)
     (stats1 stats-window)
     (stats2 stats-window)
     (options1 options-window)
     (options2 options-window))
   :constraints
   '((main (dummy)
           ((dummy :horizontal (:even) (player1 graphics player2)
                   ((player1 :vertical (160) (stats1 options1)
                             ((stats1 0.45))
                             ((options1 :even))))
                   ((player2 :vertical (160) (stats2 options2)
                             ((stats2 0.45))
                             ((options2 :even))))
                   ((graphics :even))))))))

(defmethodd (2tscreen :after :init0) (ignore)
  (setq graphics-pane (send self :get-pane 'graphics)
        options1-pane (send self :get-pane 'options1)
        options2-pane (send self :get-pane 'options2)
        stats1-pane (send self :get-pane 'stats1)
        stats2-pane (send self :get-pane 'stats2)
        )
  (send self :set-configuration 'main)
  (send graphics-pane :select)
  (send graphics-pane #+Explorer :clear-screen #-Explorer :clear-window)
  (send options1-pane :initialize '(#\j #\l #\k #\space #\n #\i))
  (send options2-pane :initialize '(#\4 #\6 #\5 #\0 #\1 #\8))
  (send options1-pane :set-other-options (send options2-pane :options))
  (send options2-pane :set-other-options (send options1-pane :options))
  (send graphics-pane :initialize
        (send options1-pane :options) (send options2-pane :options))
  (send stats1-pane :initialize 1)
  (send stats2-pane :initialize 2))

(defmethodd (2tscreen :run0) ()
  (send graphics-pane :run))

(defmethodd (2tscreen :or :verify-new-edges0) (ignore ignore ignore ignore)
  nil)

(defflavor 2tetris-frame0 () (tscreen))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

0(defflavor 2auto-player
0        (real-blocks
         blocks
         tblocks
         block-rows
         block-columns
         line-status
         status-bits
         real-levels
         levels
         shape
         board
         width
         height
         shape-heights
         col
         rot
         good-col
         good-rot
         min-score
         mode
         moves
         num-moves
         delay
         delay-time)
        ()
  :gettable-instance-variables
  :settable-instance-variables
  #+Explorer :inittable-instance-variables
  #-Explorer :initable-instance-variables)

(defmethodd (2board :after :init0) (2&rest0 ignore)
  1;; this is done here, coz' now the compiler recognizes atuo-player as a flavor
0  (setq shape (make-instance 'shape :board self))
  (setq next-shape (make-instance 'shape :board self))
  (setq auto-player (make-instance 'auto-player :board self))
  (setq blocks (make-array (list 32 32)
                           #+Explorer :type #-Explorer :element-type
                           #+Explorer 'art-1b #-Explorer 'bit
                           :initial-element 0))
  (setq block-rows (make-array 32
                               #+Explorer :type #-Explorer :element-type
                               #+Explorer 'art-32b #-Explorer t
                               :displaced-to blocks))
  (setq line-status (make-array 32)))

(defmethodd (2auto-player :after :init0) (2&rest0 ignore)
  (setq real-blocks (make-array (list 32 32)
                                #+Explorer :type   #-Explorer :element-type
                                #+Explorer 'art-1b #-Explorer 'bit)
        blocks (make-array (list 32 32)
                           #+Explorer :type   #-Explorer :element-type
                           #+Explorer 'art-1b #-Explorer 'bit)
        tblocks (make-array (list 32 32)
                            #+Explorer :type   #-Explorer :element-type
                            #+Explorer 'art-1b #-Explorer 'bit))
  (setq block-rows (make-array 32
                               #+Explorer :type    #-Explorer :element-type
                               #+Explorer 'art-32b #-Explorer t
                               :displaced-to blocks))
  (setq block-columns (make-array 32
                                  #+Explorer :type    #-Explorer :element-type
                                  #+Explorer 'art-32b #-Explorer t
                                  :displaced-to tblocks))
  (setq real-levels (make-array 32
                                #+Explorer :type    #-Explorer :element-type
                                #+Explorer 'art-fix #-Explorer 'fixnum))
  (setq levels (make-array 32
                           #+Explorer :type    #-Explorer :element-type
                           #+Explorer 'art-fix #-Explorer 'fixnum))
  (setq line-status (make-array 32))
  (setq moves (make-array 50))
  (setq shape-heights (make-array 4)))


1;; here begins a hack for symbolix: we've no function (I think)
;; which allows to copy flavors => write it

0#-Explorer
(defmacro 2define-copier0 (inst-var whom)
  1;; (define-copier char new) => (when (variable-boundp char) (send new :set-char char))
0  `(when (variable-boundp ,inst-var)
     (send ,whom
           ,(intern (apply #'concatenate 'string (mapcar #'string `(set- ,inst-var))) :keyword)
                     ,inst-var)))

#-Explorer
(defmacro 2define-copier-for-list0 (for-whom 2&rest0 list)
  (declare (zwei:indentation 1 2))
  `(progn ,@(loop for x in list collect `(define-copier ,x ,for-whom))))

#-Explorer
(defmethod (2copy shape0) ()
  (let ((new-shape (make-instance 'shape)))
    (define-copier-for-list new-shape
       char type rotation coord-list x-pos y-pos
       x-offset y-offset array delay board board-width board-height
       flash flash-count flash-length draw?)
    new-shape))

1;; end of hack for copy

0(defmethodd (2auto-player :initialize0) ()
  (setq width (send board :board-width)
        height (send board :board-height))
  (setq shape (copy (send board :shape)))
  (send shape :set-draw? nil)
  (send shape :set-delay nil)
  (setq delay (options-delay (send board :options))))

(defmethodd (2auto-player :new-piece0) ()
  (bitblt #+Explorer w:normal #-Explorer TV:ALU-SETA
          32 height (send board :blocks) 0 0 real-blocks 0 0)
  #+Explorer (w:%draw-rectangle 32 32 0 0 w:erase tblocks)
  #-Explorer (sys:%draw-rectangle 32 32 0 0 *erase-aluf* tblocks)
  (dotimes (column width)
    (dotimes (row height)
      (setf (aref tblocks column (- height row 1))
            (aref real-blocks row column))))
  (array-initialize line-status nil)
  (setq status-bits 0)
  (send self :find-levels real-levels) 1;; need this and hole-penalties for levels to be right
0  (send self :hole-penalties real-levels)
  (send shape :set-type (send (send board :shape) :type))
  (send shape :set-board-width (send (send board :shape) :board-width))
  (send shape :set-board-height (send (send board :shape) :board-height))
  (setq min-score most-positive-fixnum
        good-rot 0
        good-col 0)
  (setq col 0
        rot 0)
  (setq mode :normal))

(defmethodd (2auto-player :tick0) ()
  (case mode
    (:normal
      (send self :analyze-position)
      (when (>= (incf rot) (nth (send shape :type) *shape-asymmetric-rotations*))
        (setq rot 0)
        (when (>= (incf col) width)
          (send self :move-shape)
          (setq mode :move)))
      t)
    (:move
      (when (>= (time-difference #+Explorer (time) #-Explorer (zl:time) delay-time) delay)
        (setq delay-time #+Explorer (time) #-Explorer (zl:time))
        (unless (send board :peek-char)
          (send (send board :window) :force-kbd-input (aref moves (decf num-moves)))
          (if (zerop num-moves)
              (setq mode :sleep))))
      nil)
    (:sleep nil)))

(defmethodd (2auto-player :analyze-position0) (2&aux0 (hole-count 0))
  (block analyze-position
    (send shape :set-x-pos col)
    (send shape :set-y-pos 3)
    (send shape :set-rotation rot)
    (send shape :init-coord-list)
    (send shape :set-delay nil)
    (when (send shape :check real-blocks)
      (bitblt #+Explorer w:normal #-Explorer TV:ALU-SETA 32 height real-blocks 0 0 blocks 0 0)
      (let ((min-height height)
            (shape-type (send shape :type)))
        (dotimes (i 4)
          (setf (aref shape-heights i)
                (let ((shape-bottom (aref *shape-bottoms* shape-type rot i)))
                  (when shape-bottom
                    (let ((value (- (aref real-levels (+ col i -1)) shape-bottom 1)))
                      (setq min-height (min min-height value))
                      value)))))
        (dotimes (i 4)
          (when (aref shape-heights i)
            (let ((holes (- (aref shape-heights i) min-height)))
              (incf hole-count holes))))
        (send shape :set-y-pos min-height))
      (send shape :add-to-blocks blocks)
      (let ((full-lines (send self :find-full-lines)))
        (when (and (zerop full-lines) (>= hole-count 2))
          (return-from analyze-position nil)))
      (send shape :add-to-tblocks tblocks)
      (let ((score (send self :analyze-blocks)))
        (send shape :remove-from-tblocks tblocks)
        (when (< score min-score)
          (setq min-score score
                good-rot rot
                good-col col))))))

(defmethodd (2auto-player :move-shape0) ()
  (let ((options (send board :options))
        (shape-x (send (send board :shape) :x-pos)))
    (setq num-moves 0)
    (send self :add-move (options-key-drop options))
    (if (< good-col shape-x)
1;        (dotimes (i (- shape-x good-col))
;          (send self :add-move (options-key-left options)))
0        (loop repeat (- shape-x good-col)
              do (send self :add-move (options-key-left options)))
1;        (dotimes (i (- good-col shape-x))
;          (send self :add-move (options-key-right options)))
0        (loop repeat (- good-col shape-x)
              do (send self :add-move (options-key-right options))))
1;    (dotimes (i good-rot)
;      (send self :add-move (options-key-rotate options)))
0    (loop repeat good-rot
          do (send self :add-move (options-key-rotate options)))
    (setq delay-time #+Explorer (time) #-Explorer (zl:time))))

(defmethodd (2auto-player :add-move0) (char)
  (setf (aref moves num-moves) char)
  (incf num-moves))
          
(defmethodd (2auto-player :analyze-blocks0) ()
  (let (hole-penalty cliff-penalty)
    (send self :find-levels levels)
    (setq hole-penalty (send self :hole-penalties levels))
    (setq cliff-penalty (send self :cliff-penalties))
    (+ hole-penalty
       cliff-penalty
       (* (send shape :y-pos) -4))))
  
(defmethodd (2auto-player :find-full-lines0) ()
  (let ((count 0)
        (full-value (1- (ash 1 width))))
    (setq status-bits 0)
    (dotimes (row height)
      (if (= (aref block-rows row) full-value)
          (progn
            (incf count)
            (incf status-bits (ash 1 (- height row 1)))
            (setf (aref line-status row) t))
          (setf (aref line-status row) nil)))
    count))

(defmethodd (2auto-player :find-levels0) (arg-levels)
 "1Find-levels only finds the number of \"on\" blocks after rows have been cleared."
0  (dotimes (column width)
    (let ((h (- height (integer-length (logxor (aref block-columns column) status-bits)))))
      (setf (aref arg-levels column) h))))

(defmethodd (2auto-player :hole-penalties0) (arg-levels)
  "1Hole-penalties actually increments each entry in levels for."
0  (let ((penalty 0))
    (dotimes (column width)
      (let* ((adjusted-column (logxor (aref block-columns column) status-bits))
             (h (integer-length adjusted-column))
             (hole-bits (logxor adjusted-column (1- (ash 1 h)))))
        (loop until (zerop hole-bits)
              do
          (let ((hole (integer-length hole-bits)))
            (if (aref line-status (- height hole))
                (incf (aref arg-levels column))
                (incf penalty (+ 40 (* 2 hole (min (- h hole) 3)))))
            (decf h)
            (setq hole-bits (- hole-bits (ash 1 (1- hole))))))))
    penalty))

(defsubst 2level-diff-penalty0 (l1 l2)
  (- (max 8 (lsh (abs (- l1 l2)) 3)) 5))

(defmethodd (2auto-player :cliff-penalties0) ()
1;  (format t "~%")
0  (let ((penalty 0)
        (pen2 0)
        (pen3 0))
    (loop with last-level = 0
          and next-level = (aref levels 1)
          and level 
          and flag = :down
          for column from 0 below width
          do
      (setq level (aref levels column))
      (when (> column 0)
        (cond ((> level last-level)
               (when (eq flag :up)
                 (incf penalty pen2)
                 (setq pen2 0)
                 (setq flag nil))
               (incf penalty (lsh (level-diff-penalty level last-level)
                                  (if (eq flag :down) -2 0))))
              ((< level last-level)
               (incf pen2 (level-diff-penalty level last-level))
               (setq flag :up))))
      (when (and (>= (- level last-level) 2)
                 (>= (- level next-level) 2))
        (let* ((diff-last (- level last-level))
               (diff-next (- level next-level))
               (diff-min (min diff-last diff-next)))
          (incf pen3 (* (+ (- (lsh diff-min 1) (if (= diff-min 2) 3 0))
                           (if (or (/= diff-last 2) (/= diff-next 2)) 2 1))
                        7))))
      (setq last-level level)
      (setq next-level (if (<= column (- width 3)) (aref levels (+ column 2)) 0)))
    (incf penalty (lsh pen2 -2))
    (+ pen3 penalty)))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

0(eval-when (load)
  (add-initialization "Tetris System Key"
                    '(#+Explorer1 0w:add-system-key
                      #+(and (not Explorer) Genera-7-2) tv:add-system-key
                      #+(and (not Explorer) (or Genera-8 Imach)) tv:add-select-key
                      #\space 'tetris::tetris-frame "Tetris" t)
                    '(:once))
  (compile-flavor-methods shape board tetris-window options-window stats-window
                          tscreen tetris-frame))



1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;Error: The object #<TETRIS-FRAME Tetris Frame 1 2501160 deexposed> received a :NOTIFICATION-CELL message, which went unclaimed.
;       The rest of the message was ().
;       The message is handled by the flavors SI:INTERACTIVE-STREAM,
;       ZWEI:UNIVERSE-DEFINITION-FRAME, ZWEI:ZMAIL-FILTER-FRAME, and ZWEI:ZMAIL-WINDOW.
;While in the function TV:DELIVER-NOTIFICATION  TV:NOTIFICATION-DELIVERY-TOP-LEVEL  SI:PROCESS-TOP-LEVEL
;
;TV:DELIVER-NOTIFICATION:
;   Arg 0 (TV:STREAM): #<TETRIS-FRAME Tetris Frame 1 2501160 deexposed>
;   Arg 1 (TV:NOTE): (2848324489 "Process Terminal 1 Typeout wants to type out" #<NVT-WINDOW Terminal 1 2500000 deexposed>)
;s-A, :    Supply a different message name
;s-B:           Supply replacement argument
;s-C, :    Restart process Notification Delivery
;