;;; -*- Mode: Lisp -*-

;;; rbtrees-package.lisp --
;;; Red/Black Trees in the CLR style. (Cormen,
;;; Leiserson and Rivest, "Introduction to Algorithms", ppgg.
;;; 262-300, MIT Press).
;;; Package definition file (in CLtL2 style).
;;;
;;; Author: Marco Antoniotti
;;; Address: Robotics Laboratory
;;;          Courant Institute of Mathematical Science
;;;          New York University
;;;          New York, NY, 10012
;;;
;;; Copyright (c) 1992. All rights reserved.
;;;
;;; Version: 0.9 beta

;;;============================================================================
;;; General License Agreement and Lack of Warranty
;;;
;;; See companion file 'rbtrees.lisp'


;;;============================================================================
;;; History:
;;; 12.26.1992: released.


(defpackage "RED-BLACK-TREES" (:use "COMMON-LISP" "CONDITIONS" "TREES")
  (:nicknames "RB-TREES" "RBT")
  (:export make-tree
	   tree-p
	   size
	   element-type
	   name
	   empty-p
	   search
	   insert
	   traverse
	   minimum
	   maximum
	   successor
	   predecessor
	   delete-by-key
	   select
	   element-rank

	   empty-error
	   duplicate-key

	   version
	   )
  (:shadow make-tree
	   tree-p
	   name
	   empty-p
;	   search
	   insert
	   delete-by-key
	   empty-error
	   
	   version
	   )
  (:shadowing-import-from "TREES" search)
  )

(in-package "RED-BLACK-TREES")


;;; end of file -- rbtrees-package.lisp --
