;;;; Patch-1.  Macros did not use gensym, so local variables were
;;;; conflicting with user variables (esp in circular-shift, crop,
;;;; paste).

(in-package 'obvius)

(defmacro unary-viewable-matrix-op (function mat res &rest args)
  (let ((result-mat (gensym)) (y (gensym)) (x (gensym)))
    `(with-result ((,result-mat ,res)
		   ,mat
		   ,function ,mat ,@args)
      (loop for ,y from 0 below (row-dim ,mat) do
	    (loop for ,x from 0 below (col-dim ,mat)
		  do
		  (funcall ,function (aref (data ,mat) ,y ,x) ,@args
			   :-> (aref (data ,result-mat) ,y ,x))))
      ,result-mat)))

;; like unary-viewable-matrix-op, but reverses order of viewable matrix and args
(defmacro unary-viewable-reverse-matrix-op (function mat res &rest args)
  (let ((result-mat (gensym)) (y (gensym)) (x (gensym)))
    `(with-result ((,result-mat ,res)
		   ,mat
		   ,function ,mat ,@args)
      (loop for ,y from 0 below (row-dim ,mat) do
	    (loop for ,x from 0 below (col-dim ,mat)
		  do
		  (funcall ,function ,@args (aref (data ,mat) ,y ,x)
			   :-> (aref (data ,result-mat) ,y ,x))))
      ,result-mat)))

(defmacro binary-viewable-matrix-op (function mat1 mat2 res &rest args)
  (let ((result-mat (gensym)) (y (gensym)) (x (gensym)))
    `(with-result ((,result-mat ,res)
		   ,mat1
		   ,function ,mat1 ,mat2 ,@args)
      (loop for ,y from 0 below (row-dim ,mat1) do
	    (loop for ,x from 0 below (col-dim ,mat1)
		do
		(funcall ,function (aref (data ,mat1) ,y ,x) (aref (data ,mat2) ,y ,x)
			 ,@args :-> (aref (data ,result-mat) ,y ,x))))
      ,result-mat)))

;;; Reload files that need to be recompiled:
(loop with this-file = (merge-pathnames "patch-1.lisp"
					(concatenate 'string *obvius-directory-path*
						     "patches/"))
      for basename in '("viewable-matrix")
      for source = (merge-pathnames (merge-pathnames basename *lisp-source-path*) ".lisp")
      for binary = (merge-pathnames ".sbin" (merge-pathnames basename *binary-path*))
      do
      ;; make sure to re-compile if binary is older than this patch file:
      (when (or (not (probe-file binary))
		(> (file-write-date this-file)
		   (file-write-date binary)))
	(with-compiler-optimizations *obvius-compiler-optimizations*
	  (compile-file source :output-file binary)))
      (load binary))


