/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot                                                  ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
****                                                                        ****
******      PLAN.C                                                        ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<stdio.h>
#include<math.h>
#include<malloc.h>
#include<sys/types.h>
#include<gl.h>
#include"windowlib.h"
#include"rob.h"

int plan_nx,plan_ny,plan_nz;	
float plan_sx,plan_sy,plan_sz;
float plan_ex,plan_ey,plan_ez;
float path_x[MAX_PATH],path_y[MAX_PATH],path_z[MAX_PATH];
int pathnum;
int plan_passes;

char *omap;
float *adist,*pdist;
long *dis;
int rsx,rsy,rsz,rex,rey,rez;
float arm_length,arm_x,arm_y,arm_z;	/* origin, length */

void fmin(vp,v)
float *vp,v;
{
	if((*vp)<v) return;
	(*vp)=v;
}

void fmax(vp,v)
float *vp,v;
{
    if((*vp)>v) return;
    (*vp)=v;
}

void plan_bounding_box()	/* sets start and end sizes */
{
	int i;
	BOX *bptr;
	JOINT *jptr;

	plan_sx=0.0;
	plan_ex=0.0;
	plan_sy=0.0;
	plan_ey=0.0;
	plan_sz=0.0;
	plan_ez=0.0;
	for(i=0;i<numboxes;i++) {
		bptr=box[i];
		fmin(&plan_sx,bptr->x-bptr->dx/2);
		fmin(&plan_sy,bptr->y-bptr->dy/2);
		fmin(&plan_sx,bptr->z-bptr->dz);
		fmax(&plan_ex,bptr->x+bptr->dx/2);
		fmax(&plan_ey,bptr->y+bptr->dy/2);
		fmax(&plan_ez,bptr->z);
	}
	if(pathnum==0) {	/* start from from_joint */
		jptr=from_joint[numjoints-1];
		fmin(&plan_sx,jptr->x);
		fmin(&plan_sy,jptr->y);
		fmin(&plan_sz,jptr->z);
		fmax(&plan_ex,jptr->x);
   	 	fmax(&plan_ey,jptr->y);
   	 	fmax(&plan_ez,jptr->z);
	} else {
		fmin(&plan_sx,path_x[pathnum-1]);
		fmin(&plan_sy,path_y[pathnum-1]);
		fmin(&plan_sz,path_z[pathnum-1]);
		fmax(&plan_ex,path_x[pathnum-1]);
        fmax(&plan_ey,path_y[pathnum-1]);
        fmax(&plan_ez,path_z[pathnum-1]);
	}
	jptr=to_joint[numjoints-1];
	fmin(&plan_sx,jptr->x);
    fmin(&plan_sy,jptr->y);
    fmin(&plan_sz,jptr->z);
    fmax(&plan_ex,jptr->x);
    fmax(&plan_ey,jptr->y);
    fmax(&plan_ez,jptr->z);
	plan_sx-=1.0;
	plan_sy-=1.0;	/* don't decrement ez */
	plan_ex+=1.0;
	plan_ey+=1.0;
	plan_ez+=1.0;
}

void plan_expand_regions()
{
	int n,i,j,k,ii,jj,kk;
	char *temp;

	temp=(char *)calloc(plan_nx*plan_ny*plan_nz,sizeof(char));
	for(n=0;n<plan_passes;n++) {
		for(i=0;i<plan_nx*plan_ny*plan_nz;i++) temp[i]=0;
		for(i=1;i<(plan_nx-1);i++) {
			for(j=1;j<(plan_ny-1);j++) {
				for(k=1;k<(plan_nz-1);k++) {
					if(omap[i+plan_nx*(j+plan_ny*k)]==1) {
						for(ii= -1;ii<=1;ii++) {
							for(jj= -1;jj<=1;jj++) {
								for(kk= -1;kk<=1;kk++) {
									temp[i+plan_nx*(j+plan_ny*k)]=1;
								}
							}
						}
					}
				}
			}
		}
		for(i=0;i<plan_nx*plan_ny*plan_nz;i++) {
			if(temp[i]==1) omap[i]=1;
		}
	}
	free(temp);
}

void plan_load_data()
{
	int n,i,j,k,sx,sy,sz,ex,ey,ez;
	BOX *bptr;

	for(i=0;i<plan_nx*plan_ny*plan_nz;i++) omap[i]=1;
	for(i=1;i<(plan_nx-1);i++) {
		for(j=1;j<(plan_ny-1);j++) {
			for(k=1;k<(plan_nz-1);k++) {
				omap[i+plan_nx*(j+plan_ny*k)]=0;
			}
		}	
	}
	for(n=0;n<numboxes;n++) {
		bptr=box[n];
		sx=(int)(((float)plan_nx)*
			((bptr->x-bptr->dx/2-plan_sx)/(plan_ex-plan_sx)));
		sy=(int)(((float)plan_ny)*
			((bptr->y-bptr->dy/2-plan_sy)/(plan_ey-plan_sy)));
		sz=(int)(((float)plan_nz)*
			((bptr->z-bptr->dz-plan_sz)/(plan_ez-plan_sz)));
		ex=(int)(((float)plan_nx)*
			((bptr->x+bptr->dx/2-plan_sx)/(plan_ex-plan_sx)));
		ey=(int)(((float)plan_ny)*
			((bptr->y+bptr->dy/2-plan_sy)/(plan_ey-plan_sy)));
		ez=(int)(((float)plan_nz)*
			((bptr->z-plan_sz)/(plan_ez-plan_sz)));
		if( (sx<0)||(ex>=plan_nx)||
			(sy<0)||(ey>=plan_ny)||
			(sz<0)||(ez>=plan_nz) ) {
			printf("Boxes outside range of planning box\n");
			exit(0);
		}
		for(i=sx;i<=ex;i++) {
			for(j=sy;j<=ey;j++) {
				for(k=sz;k<=ez;k++) {
					omap[i+plan_nx*(j+plan_ny*k)]=1;
				}
			}
		}
	}
}

void compute_path()
/* The path is never actually recorded, but if you follow back from the end  */
/* always moving to the smallest distance, you will get (one of) the path(s) */
/* We record the path directly into the path arrays							 */
{
	int x,y,z,ii,jj,kk,si,sj,sk;
	int done;
	float smallest;
	float *temp_x,*temp_y,*temp_z;
	int numtemp;

	temp_x=(float *)calloc(4*(plan_nx+plan_ny+plan_nz),sizeof(float));
	temp_y=(float *)calloc(4*(plan_nx+plan_ny+plan_nz),sizeof(float));
	temp_z=(float *)calloc(4*(plan_nx+plan_ny+plan_nz),sizeof(float));
	numtemp=0;

	x=rex;
	y=rey;
	z=rez;
	temp_x[numtemp]=plan_sx+(x*(plan_ex-plan_sx))/((float)plan_nx);
	temp_y[numtemp]=plan_sy+(y*(plan_ey-plan_sy))/((float)plan_ny);
	temp_z[numtemp]=plan_sz+(z*(plan_ez-plan_sz))/((float)plan_nz);
	numtemp++;
	while((x!=rsx)||(y!=rsy)||(z!=rsz)) {
		smallest=1000.0;
		for(ii= -1;ii<=1;ii++) {
			for(jj= -1;jj<=1;jj++) {
				for(kk= -1;kk<=1;kk++) {
					if(pdist[x+ii+plan_nx*(y+jj+plan_ny*(z+kk))]<smallest) {
						si=ii;		
						sj=jj;
						sk=kk;
						smallest=pdist[x+ii+plan_nx*(y+jj+plan_ny*(z+kk))];
					}
				}
			}
		}
		x+=si;
		y+=sj;
		z+=sk;
		temp_x[numtemp]=plan_sx+(x*(plan_ex-plan_sx))/((float)plan_nx);
	    temp_y[numtemp]=plan_sy+(y*(plan_ey-plan_sy))/((float)plan_ny);
		temp_z[numtemp]=plan_sz+(z*(plan_ez-plan_sz))/((float)plan_nz);
		numtemp++;
	}
	/* store backwards into path structure */
	for(y=0;y<numtemp;y++) {
		path_x[pathnum]=temp_x[numtemp-1-y];
		path_y[pathnum]=temp_y[numtemp-1-y];
		path_z[pathnum]=temp_z[numtemp-1-y];
		pathnum++;
	}
	free(temp_x);
	free(temp_y);
	free(temp_z);
}

void arm_dist_pp(i,j,k,done)
int i,j,k,*done;
{
    int x,y,z,ii,jj,kk,ndiff;
    float smallest,ddist;

    if(omap[i+plan_nx*(j+plan_ny*k)]==0) {
	    smallest=100000.0;
    	for(ii= -1;ii<=1;ii++) {
    		for(jj= -1;jj<=1;jj++) {
				for(kk= -1;kk<=1;kk++) {
	    			if((ii==0)&&(jj==0)&&(kk==0)) continue;
   	 				x=i+ii;
   	 				y=j+jj;
					z=k+kk;
   	 				ndiff=0;
    				if(ii!=0) ndiff++;
    				if(jj!=0) ndiff++;
					if(kk!=0) ndiff++;
    				if(ndiff==0) ddist=0.0;
    				if(ndiff==1) ddist=1.0;
    				if(ndiff==2) ddist=1.41;
					if(ndiff==3) ddist=1.73;
    				ddist+=adist[x+plan_nx*(y+plan_ny*z)];
    				if(ddist<smallest) {
    					smallest=ddist;
    				}
    			}
			}
    	}
    	if(adist[i+plan_nx*(j+plan_ny*k)]>smallest) {
    		adist[i+plan_nx*(j+plan_ny*k)]=smallest;
    		*done=0;
		}
    }
}

void arm_dist()
{
	int done,pass;
	int i,j,k;
	float smallest,ddist;

	done=0;
	pass=0;
	for(i=0;i<plan_nx*plan_ny*plan_nz;i++) adist[i]=100000.0;
	adist[1+plan_nx*(1+plan_ny)]=0.0; /* change later - robot not at origin */
	while(!done) {
		done=1;
		for(i=1;i<(plan_nx-1);i++) {
			for(j=1;j<(plan_ny-1);j++) {
				for(k=1;k<(plan_nz-1);k++) {
					arm_dist_pp(i,j,k,&done);
				}
			}
		}
        for(i=plan_nx-1;i>0;i--) {
            for(j=plan_ny-1;j>0;j--) {
				for(k=plan_nz-1;k>0;k--) {
					arm_dist_pp(i,j,k,&done);
				}
            }
        }
		printf("Pass: %d\n",pass);
		pass++;
	}
}

void path_dist_pp(i,j,k,done)
int i,j,k,*done;
{
    int x,y,z,ii,jj,kk,ndiff;
    float smallest,ddist;

    if((omap[i+plan_nx*(j+plan_ny*k)]==0)||
		(adist[i+plan_nx*(j+plan_ny*k)]>arm_length)) {
        smallest=100000.0;
        for(ii= -1;ii<=1;ii++) {
            for(jj= -1;jj<=1;jj++) {
				for(kk= -1;kk<=1;kk++) {
	                if((ii==0)&&(jj==0)&&(kk==0)) continue;
   	             	x=i+ii;
   	             	y=j+jj;
					z=k+kk;
					if(adist[x+plan_nx*(y+plan_ny*z)]>arm_length) continue;
                	ndiff=0;
                	if(ii!=0) ndiff++;
                	if(jj!=0) ndiff++;
					if(kk!=0) ndiff++;
                	if(ndiff==0) ddist=0.0;
                	if(ndiff==1) ddist=1.0;
                	if(ndiff==2) ddist=1.41;
					if(ndiff==3) ddist=1.73;
                	ddist+=pdist[x+plan_nx*(y+plan_ny*z)];
                	if(ddist<smallest) {
                    	smallest=ddist;
                	}
            	}
			}
        }
        if(pdist[i+plan_nx*(j+plan_ny*k)]>smallest) {
            pdist[i+plan_nx*(j+plan_ny*k)]=smallest;
            *done=0;
        }
    }
}

void path_dist()
{
    int done,pass;
    int i,j,k;
    float smallest,ddist;

    done=0;
    pass=0;
    for(i=0;i<plan_nx*plan_ny*plan_nz;i++) pdist[i]=100000.0;
    pdist[rsx+plan_nx*(rsy+plan_ny*rsz)]=0.0;
    while(!done) {
        done=1;
		for(i=1;i<(plan_nx-1);i++) {
            for(j=1;j<(plan_ny-1);j++) {
                for(k=1;k<(plan_nz-1);k++) {
                    path_dist_pp(i,j,k,&done);
                }
            }
        }
        for(i=plan_nx-1;i>0;i--) {
            for(j=plan_ny-1;j>0;j--) {
                for(k=plan_nz-1;k>0;k--) {
                    path_dist_pp(i,j,k,&done);
                }
            }
        }
        printf("Pass: %d\n",pass);
        pass++;
    }
}

void robot_plan()
{
	int i;
	JOINT *jptr;
	JOINT **tptr;

	/* have to make sure that the robots x,y,z coords */
	/* are properly being set in from_ and to_ */

	tptr=global_joint;
	global_joint=to_joint;
	joints_to_links();
    calculate_position();
	global_joint=from_joint;
	joints_to_links();
    calculate_position();
	global_joint=tptr;

	omap=(char *)calloc(plan_nx*plan_ny*plan_nz,sizeof(char));
	adist=(float *)calloc(plan_nx*plan_ny*plan_nz,sizeof(float));
	pdist=(float *)calloc(plan_nx*plan_ny*plan_nz,sizeof(float));

	plan_bounding_box();
	plan_load_data();
	plan_expand_regions();
    if(pathnum==0) {    /* start from from_joint */
        jptr=from_joint[numjoints-1];
		rsx=(int)(((float)plan_nx)*
            ((jptr->x-plan_sx)/(plan_ex-plan_sx)));
	    rsy=(int)(((float)plan_ny)*
            ((jptr->y-plan_sy)/(plan_ey-plan_sy)));
    	rsz=(int)(((float)plan_nz)*
            ((jptr->z-plan_sz)/(plan_ez-plan_sz)));
    } else {
		rsx=(int)(((float)plan_nx)*
            ((path_x[pathnum-1]-plan_sx)/(plan_ex-plan_sx)));
	    rsy=(int)(((float)plan_ny)*
            ((path_y[pathnum-1]-plan_sy)/(plan_ey-plan_sy)));
   	 	rsz=(int)(((float)plan_nz)*
            ((path_z[pathnum-1]-plan_sz)/(plan_ez-plan_sz)));
    }

	jptr=to_joint[numjoints-1];
	rex=(int)(((float)plan_nx)*
            ((jptr->x-plan_sx)/(plan_ex-plan_sx)));
    rey=(int)(((float)plan_ny)*
            ((jptr->y-plan_sy)/(plan_ey-plan_sy)));
    rez=(int)(((float)plan_nz)*
            ((jptr->z-plan_sz)/(plan_ez-plan_sz)));

	if( (rsx<0)||(rsx>=plan_nx)||
    	(rsy<0)||(rsy>=plan_ny)||
    	(rsz<0)||(rsz>=plan_nz) ) {
    	printf("Robot start outside range of planning box\n");
    	exit(0);
    }
	if( (rex<0)||(rex>=plan_nx)||
   		(rey<0)||(rey>=plan_ny)||
    	(rez<0)||(rez>=plan_nz) ) {
    	printf("Robot end outside range of planning box\n");
    	exit(0);
    }

	printf("Start: %d %d %d\n",rsx,rsy,rsz);
	printf("End:   %d %d %d\n",rex,rey,rez);

	if(omap[rsx+plan_nx*(rsy+plan_ny*rsz)]==1) {
		printf("Robot cannot be started from within an object\n");
		exit(0);
	}
	if(omap[rex+plan_nx*(rey+plan_ny*rez)]==1) {
		printf("Robot cannot end within an object\n");
		printf("rex,rey,rez: %d %d %d\n",rex,rey,rez);
		exit(0);
	}

	arm_dist();
	if(adist[rsx+plan_nx*(rsy+plan_ny*rsz)]>1000.0) {
		printf("Robot start position is blocked from robot origin\n");
		exit(0);
	}
	if(adist[rex+plan_nx*(rey+plan_ny*rez)]>1000.0) {
		printf("Robot end position is blocked from robot origin\n");
		exit(0);
	}
	if(adist[rsx+plan_nx*(rsy+plan_ny*rsz)]>arm_length) {
		printf("Robot start position is longer than arm length: %f\n",
			adist[rsx+plan_nx*(rsy+plan_ny*rsz)]);
		exit(0);
	}
	if(adist[rex+plan_nx*(rey+plan_ny*rez)]>arm_length) {
		printf("Robot end position is longer than arm length :%f\n",
			adist[rex+plan_nx*(rey+plan_ny*rez)]);
		exit(0);
	}
	printf("Calculated extension distances\n");
	path_dist();
	compute_path();
	printf("Results:\n");
	printf("Extension at start: %f\n",adist[rsx+plan_nx*(rsy+plan_ny*rsz)]);
	printf("Extension at end: %f\n",adist[rex+plan_nx*(rey+plan_ny*rez)]);
	printf("Path length: %f\n",pdist[rex+plan_nx*(rey+plan_ny*rez)]);
	printf("Pathnum: %d\n",pathnum);
	printf("Expand: %d\n",plan_passes);
	free(omap);
	free(adist);
	free(pdist);
	redraw_visual();
}

void reset_path()
{
	pathnum=0;
	redraw_visual();
}
