/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot simulator                                        ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
**          GRAPH.C                                                           **
****                                                                        ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<stdio.h>
#ifdef R_SGI
#include<gl/gl.h>
#include<gl/device.h>
#endif
#include<math.h>
#include<string.h>
#include<stdlib.h>
#include"schematic.h"
#include"windowlib.h"
#include"rob.h"

long graph_x,graph_y;
long graph_step;
#define GRAPH_STEP 32
#define FAST_REDRAW 0

void do_graph_menu(val)
long val;
{
    switch(val) {

		case GRAPH_SAVE:
			save_graph();
			break;

        case GRAPH_PRINT:
            print_graph();
            break;

        default:
            break;
    }
}

void make_graph_menu()
{
    char men_string[256];

    sprintf(men_string,"Save Graph|Print Graph");
#ifdef R_SGI
    graph_menu=defpup(men_string);
#endif
}

void record_graph()	/* call this at each itteration, copies stuff to graph */
{
	int i,j;
	GRAPH *gptr;
	GPARAMETER *ggptr;

	for(i=0;i<numgraphs;i++) {
		gptr=graph[i];
		for(j=0;j<gptr->num_parameters;j++) {
			ggptr=gptr->parameter[j];
			ggptr->graph[step_count]=(float)(*(ggptr->value));
		}
	}
}

void draw_graph(gptr)	/* does whole graph from scratch */
GRAPH *gptr;
{	
	int i,j,sx,ex;
	GPARAMETER *ggptr;
	float miny,maxy,extra;
	int vx,vy;
	long vert[2];
	float st,et,v;
	char s[40];

	if(step_count==0) return;
#ifdef R_SGI
	lrectwrite(-graph_x+gptr->x+55,-graph_y+gptr->y+25,-graph_x+gptr->x+gptr->width-1-5,-graph_y+gptr->y+gptr->height-1-25,gptr->win);
#endif
	if(gptr->horizontal_mode==GMODE_AUTO) {
		sx=0;
		ex=step_count;
		st=0.0;
		et=actual_time[step_count-1];
	} else {
		printf("Graph Mode Fixed not supported yet\n");
		exit(0);
	}
	miny=maxy=(gptr->parameter[0])->graph[sx];
	for(i=0;i<(gptr->num_parameters);i++) {
		ggptr=gptr->parameter[i];
		for(j=sx;j<ex;j++) {
			if((ggptr->graph[j])>maxy) maxy=ggptr->graph[j];
			if((ggptr->graph[j])<miny) miny=ggptr->graph[j];
		}
	}	
	extra=(maxy-miny)*0.1;
	maxy+=extra;
	miny-=extra;
#ifdef R_SGI
	cpack(0x00ffffff);
#endif
	for(i=0;i<gptr->vertical_labels;i++) {
		v=miny+(maxy-miny)*(float)i/(float)(gptr->vertical_labels-1);
		sprintf(s,"%2.2f",v);
		s[5]=0;
#ifdef R_SGI
		cmov2(gptr->x+7,gptr->y+28+(i*(gptr->height-66))/(gptr->vertical_labels-1));
		charstr(s);
#endif
	}
	for(i=0;i<gptr->horizontal_labels;i++) {
        v=st+(et-st)*(float)i/(float)(gptr->horizontal_labels-1);
        sprintf(s,"%2.2f",v);
        s[5]=0;
#ifdef R_SGI
        cmov2(gptr->x+57+(i*(gptr->width-110))/(gptr->horizontal_labels-1),gptr->y+9);
        charstr(s);
#endif
    }
	for(i=0;i<gptr->num_parameters;i++) {
        ggptr=gptr->parameter[i];
#ifdef R_SGI
		cpack(ggptr->rgb);
		bgnline();
		for(j=sx;j<ex;j++) {
			vx=gptr->x+59+(int)
				(((actual_time[j]-st)*(float)(gptr->width-67))/(et-st));
			vy=gptr->y+30+(int)
				(((float)(gptr->height-60)*(ggptr->graph[j]-miny))/(maxy-miny));
			vert[0]=vx;
			vert[1]=vy;
			v2i(vert);
		}
		endline();
#endif
	}
}

void redraw_graph()
{
    long ow,xs,ys;
    int i,j;
    GRAPH *gptr;
	GPARAMETER *ggptr;
	char *s,ss[256];
	int pos;

#ifdef R_SGI
	if(!graph_active) return;
    ow=winget();
    winset(wid_graph);

	if(!getbutton(LEFTMOUSE)) {
    	sprintf(ss,"Graph: (%ld,%ld) Jump:%ld",graph_x,graph_y,graph_step);
        wintitle(ss);
    }
	getsize(&xs,&ys);
    ortho2((float)graph_x-0.5,(float)(xs+graph_x)+0.5,(float)graph_y-0.5,(float)(ys+graph_y)+0.5);
    reshapeviewport();
    cpack(0x00804080);
    clear();
    for(i=0;i<numgraphs;i++) {
        gptr=graph[i];
        lrectwrite(-graph_x+gptr->x,-graph_y+gptr->y,-graph_x+gptr->x+gptr->width-1,-graph_y+gptr->y+gptr->height-1,gptr->wout);
        lrectwrite(-graph_x+gptr->x+55,-graph_y+gptr->y+25,-graph_x+gptr->x+gptr->width-1-5,-graph_y+gptr->y+gptr->height-1-25,gptr->win);
		pos=0;
		for(j=0;j<gptr->num_parameters;j++) {
			ggptr=gptr->parameter[j];
			cpack(ggptr->rgb);
			if(ggptr->source==GS_JOINT) {
				switch(ggptr->type) {
					case PAR_X: s="x"; break;
					case PAR_Y: s="y"; break;
					case PAR_Z: s="z"; break;
					case PAR_XD: s="xd"; break;
					case PAR_YD: s="yd"; break;
					case PAR_ZD: s="zd"; break;
					case PAR_DX: s="dx"; break;
					case PAR_DY: s="dy"; break;
					case PAR_DZ: s="dz"; break;
					case PAR_DXD: s="dxd"; break;
					case PAR_DYD: s="dyd"; break;
					case PAR_DZD: s="dzd"; break;
					case PAR_A: s="a"; break;
					case PAR_D: s="d"; break;
					case PAR_ALPHA: s="alpha"; break;
					case PAR_THETA: s="theta"; break;
					case PAR_AD: s="ad"; break;
					case PAR_DD: s="dd"; break;
					case PAR_ALPHAD: s="alphad"; break;
					case PAR_THETAD: s="thetad"; break;
					case PAR_ADD: s="add"; break;
					case PAR_DDD: s="ddd"; break;
					case PAR_ALPHADD: s="alphadd"; break;
					case PAR_THETADD: s="thetadd"; break;
					case PAR_FA: s="fa"; break;
					case PAR_FD: s="fd"; break;
					case PAR_FALPHA: s="falpha"; break;
					case PAR_FTHETA: s="ftheta"; break;
					default: printf("Unknown mode\n"); exit(0);
				}
				sprintf(ss,"%s:%s",joint[ggptr->num]->name,s);
			} else {
				sprintf(ss,"%s",entity[ggptr->num]->name);
			}
			cmov2(gptr->x+60+pos,gptr->y+gptr->height-20);
            charstr(ss);
            pos+=8+10*strlen(ss);
		}
    }
#if(FAST_REDRAW)
	if(!getbutton(LEFTMOUSE)) {
		for(i=0;i<numgraphs;i++) draw_graph(graph[i]);
	}
#else
	for(i=0;i<numgraphs;i++) draw_graph(graph[i]);
#endif
	swapbuffers();
    winset(ow);
#endif
}

void create_graph()
{
	graph_x=0;
	graph_y=0;
	graph_step=GRAPH_STEP;
	if(!graph_active) {
		wid_graph= -1;
		return;
	}
#ifdef R_SGI
	prefposition(20,20+graph_width-1,460-graph_height,459);
	wid_graph=winopen("graph");
    RGBmode();
    doublebuffer();
    concave(FALSE);
    gconfig();
    zbuffer(FALSE);
	winconstraints();
	make_graph_menu();
	redraw_graph();
#endif
}

void graph_up()
{
    graph_y+=graph_step;
    redraw_graph();
}

void graph_down()
{
    graph_y-=graph_step;
    redraw_graph();
}

void graph_right()
{
    graph_x+=graph_step;
    redraw_graph();
}

void graph_left()
{
    graph_x-=graph_step;
    redraw_graph();
}

void graph_home()
{
    graph_x=0;
    graph_y=0;
    redraw_graph();
}

void graph_jump()
{
    if(graph_step==GRAPH_STEP) {
        graph_step=8*GRAPH_STEP;
    } else {
        graph_step=GRAPH_STEP;
    }
    redraw_graph();
}

void process_graph(event,val)
int event;
short val;
{
	long x,y;
	long mx,my,sx,sy,dx,dy;
	int i,num;
	GRAPH *gptr;

#ifdef R_SGI
	switch(event) {
		case LEFTMOUSE:
			if(!getbutton(LEFTMOUSE)) break;
			getorigin(&x,&y);
			mx=getvaluator(MOUSEX);
			my=getvaluator(MOUSEY);
			sx=graph_x+mx-x;
			sy=graph_y+my-y;
			num= -1;
			for(i=0;i<numgraphs;i++) {
				gptr=graph[i];
				if( (gptr->x<sx)&&(sx<gptr->x+gptr->width)&&
					(gptr->y<sy)&&(sy<gptr->y+gptr->height) ) {
					num=i;
				}
			}
			if(num!= -1) {  /* an entity */
				gptr=graph[num];
				dx=sx-gptr->x;
				dy=sy-gptr->y;
				while(getbutton(LEFTMOUSE)) {
					mx=getvaluator(MOUSEX);
					my=getvaluator(MOUSEY);
					sx=graph_x+mx-x-dx;
					sy=graph_y+my-y-dy;         
					gptr->x=sx;
					gptr->y=sy;
					redraw_graph();
				}
			} else {        /* move screen around */
				while(getbutton(LEFTMOUSE)) {
					mx=getvaluator(MOUSEX);
					my=getvaluator(MOUSEY);
					graph_x=sx+x-mx;
					graph_y=sy+y-my;
					redraw_graph();
				}
				redraw_graph();
			}
			break;

		default:
			break;
		}
#endif
}
