function zoomclr(gf)
% ZOOMCLR Remove ZOOMTOOL axes.
%       ZOOMCLR(H) where H is the figure ZOOMTOOL is active in.
%
%       See also ZOOMCLR ZOOMDOWN ZOOMLEFT ZOOMMENU ZOOMMOVE
%           ZOOMPKLF ZOOMPKRT ZOOMRGHT ZOOMSET ZOOMTGGL ZOOMTOOL
%           ZOOMUP ZOOMXFUL ZOOMXIN ZOOMXOUT ZOOMYFUL ZOOMYIN
%           ZOOMYOUT

%       Dennis W. Brown 1-10-94
%       Copyright (c) 1994 by Dennis W. Brown
%       May be freely distributed.
%       Not for use in commercial products.

% current values
if nargin ~= 1,
    gf = gcf;
end;

% get handles stored in Axis 'UserData'
handles = get(finduitx(gf,'zoomtool'),'UserData');

% axes handle
ga = handles(40);

% Clean up objects with handles stored in 'Userdata' property
%   of the axis object
delete(handles(find(handles(1:27))));

% Clean up cursor controls (there are two of each)
for i = 1:2,
    delete(findpush(gf,'<'));
    delete(findpush(gf,'>'));
    delete(findpush(gf,'<<'));
    delete(findpush(gf,'>>'));
end;

% clean off readout labels
delete(finduitx(gf,'X - - -'));
delete(finduitx(gf,'Y - - -'));
delete(finduitx(gf,'Delta X'));
delete(finduitx(gf,'Delta Y'));
delete(finduitx(gf,'X -.-.'));
delete(finduitx(gf,'Y -.-.'));
delete(findfram(gf,'zoomframe'));

% Clean off the rest of the labels
delete(finduitx(gf,'Cursor 1 - -'));
delete(finduitx(gf,'Cursor 2 -.'));
delete(finduitx(gf,'X'));
delete(finduitx(gf,'Y'));
delete(finduitx(gf,'XY'));

% adjust size of axis back to original
b_hite = 0.04;
b_frame = .004;
old = get(ga,'Units');
set(ga,'Units','normal');
pos = get(ga,'Position');
pos(2) = pos(2) - 2*b_hite;
pos(3) = pos(3) + 0.065;
pos(4) = pos(4) + 3*b_hite;
set(ga,'Position',pos);
set(ga,'Units',old);

% clean off any menus that may have been add
if findmenu(gf,'Play'),
    delete(findmenu(gf,'Play'));
end;

% allow axes to be replaced with new plot command
set(gf,'NextPlot','replace');

% clear buttondown functions
h = get(gca,'Children');
for i = h,
	set(i,'ButtonDownFcn','');
end;

% delete zoomtool uitext marker
delete(finduitx(gf,'zoomtool'));

% delete zoomtool menus if present
delete(findmenu(gf,'Line'))
delete(findmenu(gf,'Play'))
delete(findmenu(gf,'Edit'))
