function [y,i] = findpeak(x)

% FINDPEAK(x) - Returns a vector containing the magnitude of the peaks in
%   vector x.  A peak is defined as a vector member that is either greater
%   or smaller than both of its immediate neighbors depending upon whether
%   it is a maximum or minimum.  Optional output argument i returns a vector
%   corresponding to the indices of the peaks return in y.  If the output
%   argument i is not requested, output argument y will be the same length
%   as x with non-peak members set to zero.  If output argument i is requested,
%   output argument y will contain only the peak values.  There is a one-to-
%   one correspondence between members of y and i.
%
% by Dennis W. Brown, 9/26/93
% Naval Postgraduate School, Monterey, CA
% Last modified: 9/26/93

% default output
y = []; i =  [];

% figure out if we have a vector
if min(size(x)) ~= 1,
	error('peaks: Input arg "x" must be a 1xN or Nx1 vector.');
end;

% number of samples
Ns = length(x);

% starting point, assumes we're going to be going up.
peak = abs(x(1));
up = 1;
down = 0;
way = up;

% loop through all the samples
for k=2:Ns

	if way == up                    % looking for a maximum
	    if abs(x(k)) > peak
		    x(k-1) = 0;             % zero the sample
	    	peak = abs(x(k));       % still going up
	    else
	        way = down;             % found a maximum, go down now
	        peak = abs(x(k));
	    end
	else                            % looking for a minimum
	    if abs(x(k)) < peak
	        x(k-1) = 0;             % zero the sample
	        peak = abs(x(k));       % still going down
	    else
	        way = up;               % found a minimum, go up now
	        peak = abs(x(k));
	    end
	end
end

if nargout == 2,                    % user wants peak with indices
    i = find(x);                    % get peaks
    y = x(i);                       % get indices
else,
    y = x;                          % non-peaks have been zeroed
end;
