#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <search.h>
#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include "proto.h"
#include "dict.h"

#ifndef DICT_PATH
#define DICT_PATH "/usr/local/lib/text710.dat"
#endif

int
dict_init(d, path)
dict_ptr d;
char *path;
{
 int code = 0;
 int fd;
 if (!path || !path[0])
  path = DICT_PATH;
 fd = open(path, O_RDONLY, 0444);
 if (fd >= 0)
  {
   struct stat st;
   if (!fstat(fd, &st))
    {
     d->size = st.st_size;
     d->base = (dictrec_ptr) mmap(0, d->size, PROT_READ, MAP_PRIVATE, fd, 0);
     if (d->base && d->base != (dictrec_ptr) - 1)
      {
       d->entries = d->size / sizeof(dictrec_t);
       code = 1;
      }
    }
   close(fd);
  }
 return code;
}

void
dict_term(d)
dict_ptr d;
{
 munmap((caddr_t) d->base, d->size);
}

static int spell_cmp PROTO((char *a, char *b));

static int
spell_cmp(a, b)
char *a;
char *b;
{
 return strncmp(a, b, 23);
}

dictrec_ptr
spell_find(d, s, n)
dict_ptr d;
char *s;
unsigned n;
{
 dictrec_t r;
 dictrec_ptr x;
 char *p = r.spell;
 memset(&r, ' ', sizeof(r));
 while (n-- > 0)
  *p++ = *s++;
 r.eoln = '\n';
 x = (dictrec_ptr) bsearch(&r, d->base, d->entries,
                           sizeof(dictrec_t), spell_cmp);
 if (!x && isupper(r.spell[0]))
  {
   for (p = r.spell; p < r.spell + sizeof(r.spell); p++)
    {
     if (isupper(*p))
      *p = tolower(*p);
    }
   x = (dictrec_ptr) bsearch(&r, d->base, d->entries,
                             sizeof(dictrec_t), spell_cmp);
  }
 if (x)
  {
   /* Find 1st matching entry */
   while (x > d->base && !spell_cmp(r.spell, x[-1].spell))
    x--;
  }
 return x;
}
