#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "proto.h"
#include "getargs.h"
#include "parwave.h"

/* default values for pars array from .doc file */
klatt_t def_pars =
{
#include "pars.def"
};

int
init_synth(argc, argv)
int argc;
char *argv[];
{
 double mSec_per_frame = 10;
 int impulse = 0;
 int casc    = 0;
 quiet_flag  = TRUE;
 glsource    = NATURAL;
 f0_flutter  = 0;

 argc = getargs(argc,argv,
                "q", NULL, &quiet_flag,
                "I", NULL, &impulse,
                "c", "%d", &casc,
                "F", "%d", &f0_flutter,
                "f", "%lg", &mSec_per_frame,
                "t", "%d",  &def_pars.TLTdb,
                NULL);

 if (casc > 0)
  {
   synthesis_model = CASCADE_PARALLEL;
   nfcascade = casc;
  }
 else
  synthesis_model = ALL_PARALLEL;

 if (impulse)
  glsource = IMPULSIVE;

 nspfr = (samp_rate * mSec_per_frame) / 1000;
#if defined(sun)
 /* turn off strict IEEE compliance in favour of speed */
 nonstandard_arithmetic();
#endif
 return argc;
}
