/*
 * $Id: windows.c,v 2.3 1993/06/09 20:58:40 johans Exp $
 *
 * windows.c
 *
 */

/* Standard C library include file directives */
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* Speech library include file directives */
#include <speech.h>

/* external variable declarations */
extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

static float *HammingCoeffs = NULL;
static int HammingNumber = 0;

static float *HanningCoeffs = NULL;
static int HanningNumber = 0;

/* local module header declarations */
static int ComputeHammingCoeffs( int num );
static int ComputeHanningCoeffs( int num );


/*
 * int HammingWindow(data, num)
 *
 */

int HammingWindow( float *data, int num )
{
	int i;


	if( num != HammingNumber ) {
		if( ComputeHammingCoeffs( num ) < 0 ) {
			return( -1 );
		}
	}

	for( i = 0; i < num; i++ ) {
		*(data+i) *= *(HammingCoeffs+i);
	}

	return( 1 );
}


int HanningWindow( float *data, int num )
{
	int i;

	if( num != HanningNumber ) {
		if( ComputeHanningCoeffs( num ) < 0 ) {
		  fprintf(stderr, "error in Compute Hanning\n");
			return( -1 );
		}
	}

	for( i = 0; i < num; i++ ) {
		*(data+i) *= *(HanningCoeffs+i);
	}

	return( 1 );
}


static int ComputeHammingCoeffs( int num )
{
	int i;
	float tmp;

	if( HammingCoeffs != NULL ) {
		free( HammingCoeffs );
	}


	HammingCoeffs = (float *)malloc( sizeof(float) * num );

	if( HammingCoeffs == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( -1 );
	}

	HammingNumber = num;

	tmp = 2.0 * M_PI / ( ((float)num) - 1.0 );

	for( i = 0; i < num; i++ ) {

		*(HammingCoeffs+i) = 0.54 - 0.46 * cos( tmp * ((float)i) );
	}

	return( 1 );

}


static int ComputeHanningCoeffs( int num )
{
	int i;
	float tmp;


	if( HanningCoeffs != NULL ) {
		free( HanningCoeffs );
	}

	HanningCoeffs = (float *)malloc( sizeof(float) * num );

	if( HanningCoeffs == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( -1 );
	}

	HanningNumber = num;

	tmp = 2.0 * M_PI / ( ((float)num) - 1.0 );

	for( i = 0; i < num; i++ ) {
		*(HanningCoeffs+i) = 0.50 - 0.50 * cos( tmp * ((float)i) );
	}

	return( 1 );
}
