/*
 *
 * $Id: wav.c,v 1.6 1993/06/09 20:58:40 johans Exp johans $
 *
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <fcntl.h>

#ifdef _AIX
#include <net/nh.h>
#endif _AIX
#include <sys/stat.h>

/* Speech Libray include file directives */
#include <speech.h>
#include <sphere.h>


/* external varaible declarations */
extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

/*
 * byte_swap(buf, len)
 *
 */

static byte_swap(char *buf, int len)
{
  register char *cp, *end, tmp;

  end = buf + len;
  for(cp = buf;cp < end;cp++)
    {
      tmp = *cp;
      *cp = *(cp+1);
      *++cp = tmp;
    }
}


/* 
 * read a sphere speech file; assume 16 bit samples;
 * allocate space for samples;
 * set the rate parameter;
 * return number of samples (-1 on error)
 *
 */

int WavRead(char *filename, short **samples_p, int *rate_p )
{
	int num_bytes, num_read;
	struct header_t *sph;
	char byte_format[64];
	int len, type, size; 
	int samples_read;
	char *errmsg;
	FILE *fp;

	if (strcmp(filename, "-") == 0) 
	  fp = stdin;
	else {
	  if( ( fp = fopen( filename, "r" ) ) == NULL ) {
	    if( errno < sys_nerr ) {
	      ErrorString = sys_errlist[errno];
	    } else {
	      ErrorString = "fopen failed";
	    }
	    return( -1 );
	  }
	}

	sph = sp_open_header( fp, 1, &errmsg );

	/* Sphere routines do not set ErrorString */
	if( sph == NULL ) {
		ErrorString = "sphere error";
		fclose(fp);
		return( -1 );
	}

	num_bytes = sizeof(int);

	if( sp_get_data( sph, "sample_rate", 
					(char *)rate_p, &num_bytes ) < 0 ) {
		ErrorString = "sphere error";
		fclose(fp);
		sp_close_header( sph );
		return( -1 );
	}

	num_bytes = sizeof(int);
 
	if( sp_get_data( sph, "sample_count", (char *)&len, &num_bytes ) < 0) {
		ErrorString = "sphere error";
		fclose(fp);
		sp_close_header( sph );
		return( -1 );
	}
    
	*samples_p = (short *) malloc( len * 2 );
	if( *samples_p == NULL ) {
	      if( errno < sys_nerr ) {
		ErrorString = sys_errlist[errno];
	      } else {
		ErrorString = "malloc failed";
	      }
	      sp_close_header( sph );
	      fclose(fp);
	      return( -1 );
	}

	num_bytes = 64;
	if( sp_get_data( sph, "sample_byte_format", 
					byte_format, &num_bytes ) < 0 ) {
		ErrorString = "sphere error";
		sp_close_header( sph );
		fclose(fp);
		return( -1 );
	}
	byte_format[num_bytes] = '\0';
	if(!strcmp(byte_format,"shortpack-v0"))
	  num_read = ReadShortpackedData(*samples_p,len,fp);
	else {
	  num_read = 0;
	  while (num_read<len) {
	    samples_read = fread((*samples_p) + num_read,2, len-num_read, fp);
	    num_read += samples_read;
	  }
	}

	if( num_read != len ) {
	  ErrorString = "read error";
	  sp_close_header( sph );
	  fclose(fp);
	  return( -1 );
	}
	
	if( ( ( LittleIndian() == 0 ) && 
	     ( strcmp( byte_format, "01" ) == 0 ) ) || 
	   
	   ( ( LittleIndian() != 0 ) && 
	    ( strcmp( byte_format, "10" ) == 0 ) ) ) {
	  
	  byte_swap( (char *)*samples_p, len * 2 );
	}

	fclose(fp);
	sp_close_header( sph );
	return( len );
}


int WavWrite(char *wavfile, short *samples, int len, int sample_rate, 
	     int compress_flag)
{
  short test_short = 1;
  char *host_byte_format;
  int fd;
  FILE *fp;
  struct header_t *sph;  
  int temp1, temp2;
  int samples_write, samples_need;
  mode_t oumask;
  
  if(htons(test_short) == test_short)
    {
      host_byte_format = "10";
    }
  else
    {
      host_byte_format = "01";
    }

  /* don't give read permission until after data is written */
  /* this is for auto_lyre, which will try to read it as soon */
  /* as the file is created */

  /* file stream */
  if (strcmp(wavfile, "-") == 0)
    fd = 2;
  else  
    fd = open( wavfile, O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE );
  
  if( fd < 0 ) {
    if( errno < sys_nerr ) {
      ErrorString = sys_errlist[errno];
    } else {
      ErrorString = "open failed";
    }
    return( -1 );
  }

  /* file handler */
  if (strcmp(wavfile, "-") == 0)
    fp = stdout;
  else
    if((fp = fdopen(fd,"w")) == NULL)
      {
	if( errno < sys_nerr ) {
	  ErrorString = sys_errlist[errno];
	} else {
	  ErrorString = "fdopen failed";
	}
	
	return -1;
      }
  
  sph = sp_create_header();

  /* create NIST header */
  if(compress_flag)
    {
      if(sp_add_field(sph, "sample_byte_format", T_STRING, "shortpack-v0") < 0)
	{
	  ErrorString = "sp_add_field error";
	  fclose(fp);
	  return -1;
	}
    }
  else
    {
      if(sp_add_field(sph,"sample_byte_format",T_STRING,host_byte_format) < 0)
	{
	  ErrorString = "sp_add_field error";
	  fclose(fp);
	  return -1;
	}
    }
  
  temp1 = 1;
  if(sp_add_field(sph, "channel_count", T_INTEGER, (char *) &temp1) < 0)
    {
      ErrorString = "sp_add_field error";
      fclose(fp);
      return -1;
    }
  if(sp_add_field(sph, "sample_count", T_INTEGER, (char *) &len) < 0)
    {
      ErrorString = "sp_add_field error";
      fclose(fp);
      return -1;
    }
  if(sp_add_field(sph, "sample_rate", T_INTEGER, (char *) &sample_rate) < 0)
    {
      ErrorString = "sp_add_field error";
      fclose(fp);
      return -1;
    }
  temp1 = 2;
  if(sp_add_field(sph, "sample_n_bytes", T_INTEGER, (char *) &temp1) < 0)
    {
      ErrorString = "sp_add_field error";
      fclose(fp);
      return -1;
    }
  temp1 = 16;
  if(sp_add_field(sph, "sample_sig_bits", T_INTEGER, (char *) &temp1) < 0)
    {
      ErrorString = "sp_add_field error";
      fclose(fp);
      return -1;
    }
  
  if(sp_write_header(fp,sph,&temp1,&temp2) < 0)
    {
      ErrorString = "sp_write_header failure";
      fclose(fp);
      return -1;
    }

  /* save data either compressed or normal */
  if(compress_flag)
    {
      if(WriteShortpackedData(samples,len,fp) < 0)
	{
	  fclose(fp);
	  return -1;
	}
    }
  else
    {
      samples_need = 0;
      
      while (samples_need<len) {
	samples_write = fwrite(samples+samples_need, sizeof(short), 
			       len-samples_need, fp);
	samples_need += samples_write;
      }

      if(samples_need != len)
	{
	  ErrorString =  "fwrite error";
	  fclose(fp);
	  return -1;
	}
    }
  fclose(fp);

  /* change file access rights */
  if (strcmp(wavfile, "-") != 0) {
    oumask = umask(022);
    umask(oumask);
    if( chmod( wavfile, 0666 & ~oumask ) == -1 ) {
      if( errno < sys_nerr ) {
	ErrorString = sys_errlist[errno];
      } else {
	ErrorString = "chmod failed";
      }
      return( -1 );
    }
  }
  
  return( 1 );
  
}
