/*
 * $Id: strarray.c,v 2.2 1993/05/07 18:12:22 johans Exp $
 *
 * strarray.c
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#ifdef ultrix
#include <math.h>
#else
extern int atoi();
extern double atof();
#endif

#include <speech.h>


/* external variable declaration */
extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

/* local module header declarations */


/*
 * StrArray2IntArray(char **sa, int len)
 *
 */

int *StrArray2IntArray( char **sa, int len )
{
	int *ia;
	int i;


	ia = (int *)malloc( sizeof(int) * len );

	if( ia == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( NULL );
	}

	for( i = 0; i < len; i++ ) {
		*(ia+i) = atoi( sa[i] );
	}

	return( ia );

}


float *StrArray2FloatArray( char **sa, int len )
{
	float *fa;
	int i;

	fa = (float *)malloc( sizeof(float) * len );

	if( fa == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( NULL );
	}

	for( i = 0; i < len; i++ ) {
		*(fa+i) = (float)atof( sa[i] );
	}

	return( fa );

}


char **IntArray2StrArray( int *ia, int len )
{
	char buf[256];
	int i, slen;
	char *tmp;
	char **sa;

	
	sa = (char **)malloc( sizeof(char *) * len );
	
	if( sa == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( NULL );
	}

	for( i = 0; i < len; i++ ) {

		sprintf( buf, "%d", ia[i] );

		tmp = (char *)malloc( strlen( buf ) + 1 );

		if( tmp == NULL ) {
			FreeStrArray( sa, i - 1 );
			if( errno < sys_nerr ) {
				ErrorString = sys_errlist[errno];
			} else {
				ErrorString = "malloc failed";
			}
			return( NULL );
		}

		strcpy( tmp, buf );
		*(sa+i) = tmp;
	}

	return( sa );
}


char **FloatArray2StrArray( float *fa, int len )
{
	char buf[256];
	int i, slen;
	char *tmp;
	char **sa;


	sa = (char **)malloc( sizeof(char *) * len );
	
	if( sa == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( NULL );
	}

	for( i = 0; i < len; i++ ) {

		sprintf( buf, "%f", fa[i] );

		tmp = (char *)malloc( strlen( buf ) + 1 );

		if( tmp == NULL ) {
			FreeStrArray( sa, i - 1 );
			if( errno < sys_nerr ) {
				ErrorString = sys_errlist[errno];
			} else {
				ErrorString = "malloc failed";
			}
			return( NULL );
		}

		strcpy( tmp, buf );
		*(sa+i) = tmp;
	}

	return( sa );

}


char **Str2StrArray( char *str )
{
	char **tmp;
	int len;

	len = strlen( str );

	tmp = (char **)malloc( sizeof(char *) );

	if( tmp == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( NULL );
	}

	*tmp = (char *)malloc( len + 1 );

	if( *tmp == NULL ) {
		free( tmp );
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( NULL );
	}

	strcpy( *tmp, str );

	return( tmp );
}


void FreeStrArray( char **sa, int len )
{
        int i;

        for( i = 0; i < len; i++ ) {
                free( *(sa+i) );
        }

        free( sa );
}






