/*
 * $Id: allocspace.c,v 2.3 1993/05/11 18:52:04 johans Exp $
 *
 * allocspace.c
 *
 *
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <speech.h>

/* external variable declarations */
extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

/* local module header declarations */

/*
 * Matrix allocation routines.  
 * To allocate a 10 by 10 matrix of floats use:
 *
 *	char **alloc2d();
 *	float **x;
 *
 *	x = (float **) alloc2d(10, 10, sizeof(float));
 *
 * To free this matrix use:
 *
 *	free2d(x);
 */

char **Alloc2d (int dim1, int dim2, int size)
{
	int		i;
	unsigned	nelem;
	char		*p, **pp;

	nelem = (unsigned) dim1*dim2;

	p = (char *)calloc(nelem, (unsigned) size);

	if( p == NULL ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "calloc failed";
		}
		return(NULL);
	}

	pp = (char **) calloc((unsigned) dim1, (unsigned) sizeof(char *));

	if (pp == NULL)
	{
		cfree(p);
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "calloc failed";
		}
		return( NULL );
	}

	for(i=0; i<dim1; i++)
		pp[i] = p + i*dim2*size;

	return(pp);
}


int Free2d( char **mat )
{
	if (mat != NULL && *mat != NULL)	cfree((char *) *mat);
	if (mat != NULL)			cfree((char *) mat);
	return(0);
}


char ***Alloc3d( int dim1, int dim2, int dim3, int size )
{
	int	i;
	char	**pp, ***ppp;

	pp = (char **) Alloc2d(dim1*dim2,dim3, size);

	if(pp == NULL) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "calloc failed";
		}
		return(NULL);
	}

	ppp = (char ***) calloc((unsigned) dim1, (unsigned) sizeof(char **));
	if(ppp == NULL)
	{
		Free2d(pp);
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "calloc failed";
		}
		return(NULL);
	}

	for(i=0; i< dim1; i++)
		ppp[i] = pp + i*dim2 ;
	return(ppp);
}


int Free3d (char ***mat)
{
	Free2d( *mat );
	if (mat != NULL)	cfree((char *) mat);
	return(0);
}


#ifdef notdef

/*
 *  Does anything use what is left???
 */

/*---Allocate 4 dimensional array--------*/
char ****Alloc4d (int dim1, int dim2, int dim3, int dim4, int size)
{
	int	i;
	char	*calloc(), ***ppp, ****pppp;

	ppp = (char ***) Alloc3d(dim1*dim2, dim3, dim4, size);
	if(ppp == NULL) return(NULL);
	pppp = (char ****) calloc(dim1, sizeof(char ****));
	if(pppp == NULL)
	{
		Free3d(ppp);
		return(NULL);
	}

	for(i=0; i< dim1; i++)
		pppp[i] = ppp + i*dim2 ;
	return(pppp);
}


Free4d (char ****mat)
{
	Free3d((char *) *mat);
	if (mat != NULL)	cfree((char *) mat);
	return(0);
}


/*--allocate lower triangule of square matrix------------*/
char **alloclt(int dim, int size)
{
	int	i;
	char	*calloc(), *p, **pp;
	unsigned nelem;

	nelem = (dim*(dim+1))/2 ;
	p = calloc(nelem, (unsigned) size);
	if (p == NULL) return(NULL);
	pp = (char **) calloc((unsigned) dim, (unsigned) sizeof(char *));
	if( pp == NULL)
	{
		cfree(p);
		return(NULL);
	}

	pp[0] = p;
	for(i=1; i<dim; i++)
		pp[i] = pp[i-1] + i*size;
	return(pp);
}


/*--allocate upper triangule of square matrix------------*/
char **allocut (int dim, int size)
{
	int	i;
	char	*calloc(), *p, **pp;
	unsigned nelem;

	nelem = (dim*(dim+1))/2 ;
	p = calloc(nelem, (unsigned) size);
	if (p == NULL)
		return(NULL);
	pp = (char **) calloc((unsigned) dim, (unsigned) sizeof(char *));
	if(pp == NULL)
	{
		cfree(p);
		return(NULL);
	}

	pp[0] = p;
	for(i=1; i<dim; i++)
		pp[i] = pp[i-1] + (dim -i )*size;
	return(pp);
}


/*---------------------------------------------------------------
 *  ALLOC2D2 :
 *	Allocates a vector of one dimensional arrays
 *	like a two dimensional array, however the sizes
 *	of each vector can be different.
 * 
 *	To free the space use :
 *
 *		free2d(x) ;
 *-------------------------------------------------------------*/

char	**alloc2d2 ( int numclass, int *nvals, int size )
{
    register    int		i ;
    int	sum = 0;
    unsigned	nelem = 0 ;
    char	*calloc () ;
    char	*p ;
    char	**pp ;

    for (i = 0; i < numclass; i++)
    {
	nelem += (unsigned) nvals[i];
    }

    p = calloc ( nelem, (unsigned) size ) ;

    if ( p == NULL )
    {   return ( NULL ) ;
    }

    pp = (char **) calloc((unsigned) numclass, (unsigned) sizeof(char *)) ;

    if ( pp == NULL )
    {   cfree ( p ) ;
	return ( NULL ) ;
    }

    for ( i = 0; i < numclass; i++ )
    {
	pp[i] = p + sum * size ;
	sum += nvals[i];
    }

    return ( pp ) ;

}


char ***alloc3d2 (int dim1, int dim2, int *nvals, int numnvals, int size)
{
    register    int		i, j, numarr2;

    register	int		sum = 0;
    unsigned	nelem = 0 ;
    char	*calloc () ;
    char	*p ;
    char	**pp ;
    char	***ppp;

    if(numnvals != dim2) 
    {
      printf("error on alloc3d2 dim2 %d != numnvals %d returning NULL!\n",dim2, numnvals);
      return(NULL);
    }

    for (i = 0; i < numnvals; i++)
    {
	nelem += (unsigned) nvals[i];
    }

    nelem = nelem * dim1;

    p = calloc ( nelem, (unsigned) size ) ;

    if ( p == NULL )
    {   return ( NULL ) ;
    }

    pp = (char **) calloc( dim1*dim2, sizeof(char *));
    if (pp == NULL)
    {
	cfree(p);
	return(NULL);
    }

    numarr2 = dim1 * dim2;
    sum = 0;
    for(i=0, j =0; i<numarr2; i++, j++)
    {
	if(j == numnvals) j = 0;
        pp[i] = p + (sum * size) ;
	sum += nvals[j];
    }

    ppp = (char ***) calloc(dim1, sizeof(char **));

/* now set the pointers */

    sum = 0;
    for ( i = 0; i < dim1; i++ )
    {
         ppp[i] = pp + (i * dim2) ;
    }
    return( ppp );
}


free3d2 (char ***mat)
{
	cfree( **mat );
	cfree( *mat );
	cfree( mat );
}


/* alloc3 array where second dimension is variable
	i.e. labinclass[class][numlabinclass][numchar] */
char ***alloc3d2ndvar (int dim1, int *nvals, int dim2, int size)
{
	register int    i, numarr2;

	register int    sum = 0;
	unsigned        nelem = 0;
	char           *calloc();
	char           *p;
	char          **pp;
	char         ***ppp;


	for (i = 0; i < dim1; i++) {
		nelem += (unsigned) nvals[i];
	}
	numarr2 = nelem;
	nelem = nelem * dim2;

	p = calloc(nelem, (unsigned) size);

	if (p == NULL) {
		return (NULL);
	}
	pp = (char **) calloc(numarr2, sizeof(char *));
	if (pp == NULL) {
		cfree(p);
		return (NULL);
	}
	sum = 0;
	for (i = 0; i < numarr2; i++) {
		pp[i] = p + (i * dim2 * size);
	}

	ppp = (char ***) calloc(dim1, sizeof(char **));

	/* now set the pointers */

	sum = 0;
	for (i = 0; i < dim1; i++) {
		ppp[i] = pp + sum;
		sum += nvals[i];
	}
	return (ppp);
}

#endif notdef





