/*
 * $Id: adc_old.c,v 1.1 1993/05/24 16:04:48 johans Exp $
 *
 *
 */
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <malloc.h>
#include <unistd.h>
#include <stdio.h>

#include <speech.h>
#include <ad.h>

#define SWAPW(x)	(((x)<<8) | (0xFF & ((x)>>8)))
#define SWAPL(x)	((((x)<<24)&0xFF000000) | (((x)<<8)&0x00FF0000) | \
			 (((x)>>8) & 0x0000FF00) | (((x)>>24)&0x000000FF))

extern char *sys_errlist[];
extern int sys_nerr;
extern int errno;

/* AdcRead 
 *
 * read an adc file
 *
 * parameters:
 *   file - file to read from
 *   samples - where the data will end up
 *   rate - set to the sample rate in HZ
 *
 * returns:
 *  the number of data pointes if read worked, otherwise
 *  -1 and ErrorString is set.
 *
 */
int AdcRead( file, samples, rate )
char *file;
short **samples;
int *rate;
{
	ad_head_t head;
	int do_byte_swap = 0;
	char fullname[1024];
	struct stat fstatb;
	int samples_read;
	off_t lseek();
	short *aptr;
	int fd;

	if( (fd = open( file, O_RDONLY ) ) < 0) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "open failed";
		}

		return( -1 );
	}


	/*
	 * read header 
	 */
	read(fd, &head, sizeof(ad_head_t) );

	/*
	 * Check the header size 
	 */
	if (head.ad_hdrsize == 0) {
		/*
		 * There is no header therefore this file 
		 * must have been written on a
		 * little indian machine (vax).
		 */
		head.little_indian = 1;
	} else {
		/*
		 * There is a header, check the version number. 
		 */
		if (head.ad_version == 0) {
			/*
			 * Version 0 files were only written on VAX's 
			 * and other little indian machines. Later 
			 * versions of the header have the
			 * little_indian field.
			 */
			head.little_indian = 1;
		}
	}

	/*    
	 * check head->little_indian and machine type and set do_byte_swap
	 * accordingly.
	 */
	if( ( head.little_indian && LittleIndian() ) ||
	    ( !head.little_indian && !LittleIndian() ) ) {

		do_byte_swap = 0;

	} else {
		do_byte_swap = 1;
	}

	if( do_byte_swap == 1 ) {
		/*
		 * Swap the header bytes
		 */
		head.ad_hdrsize = SWAPW(head.ad_hdrsize);
		head.ad_version = SWAPW(head.ad_version);
		head.ad_channels = SWAPW(head.ad_channels);
		head.ad_rate = SWAPW(head.ad_rate);
		head.ad_samples = SWAPL(head.ad_samples);
		head.little_indian = SWAPL(head.little_indian);
	}

	if( ( head.ad_hdrsize > 1024 ) || ( head.ad_hdrsize < 0 ) ) {
		close( fd );
		ErrorString = "bad adc file";
		return( -1 );
	}

	if (head.ad_hdrsize == 0) {
		head.ad_version = -1;
		head.ad_channels = 1;
		head.ad_rate = 250;
		head.ad_samples = 0;
	}

	/*
	 * Header or not skip to the begining of the data. 
	 */
	(void) lseek(fd, head.ad_hdrsize * 2, SEEK_SET );

	/*
	 * Compute the number samples in this file from 
	 * an fstat if the header is inadequit. 
	 */
	if (head.ad_samples == 0) {
		if( fstat( fd, &fstatb ) == -1 ) {
			close( fd );
			if( errno < sys_nerr ) {
				ErrorString = sys_errlist[errno];
			} else {
				ErrorString = "fstat failed";
			}
			return( -1 );
		}
		head.ad_samples = (fstatb.st_size / 2) - head.ad_hdrsize;
	}


	/*
	 * allocate space for adc samples
	 */
	aptr = (short *)malloc( head.ad_samples * 2 );

	if( aptr == NULL ){
		close( fd );
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "malloc failed";
		}
		return( -1 );
	}

	/*
	 * Read the data all in swell foop. 
	 */
	samples_read = read( fd, aptr, head.ad_samples * 2 );
	samples_read /= 2;

	if( samples_read != head.ad_samples ) {

		close(fd);
		free( aptr );

		if( samples_read == -1 ) {
			if( errno < sys_nerr ) {
				ErrorString = sys_errlist[errno];
			} else {
				ErrorString = "read failed";
			}
			return( -1 );
		} else {
			ErrorString = "premature EOF";
			return( -1 );
		}
	}


	close( fd );
	*samples = aptr;
	*rate = (QUS_PER_MS * 1000)/ head.ad_rate;
/*	*rate = SAMPS_PER_MS( head.ad_rate ) * 1000; */

	if( do_byte_swap == 1 ) {
		swab( aptr, aptr, head.ad_samples * 2 );
	}

	return( samples_read );

}

/*
 * AdcWrite()
 *
 * Write an adc file.  It does not give the file write permission
 * until all the data has been written.  This was initially done in
 * order to interface with auto_lyre, which tries to read a file as
 * soon as it exists.  By withholding read permission, auto_lyre must
 * wait until the file is complete.
 */
int AdcWrite( filename, samples, len, rate )
char *filename;
short *samples;
int len;
int rate;
{
	ad_head_t ah;
	int fd;
	mode_t oumask;
	
	fd = open( filename, O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE );

	if( fd < 0 ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "open failed";
		}
		return( -1 );
	}

	ah.ad_hdrsize = sizeof(ad_head_t) >> 1;
	ah.ad_version = CURRENT_AD_VERSION;
	ah.little_indian = LittleIndian();
	ah.ad_samples = len;
	ah.ad_rate = 4000000 / rate;
	ah.ad_channels =  1;


	if( write(fd, &ah, sizeof(ad_head_t) ) == -1 ||
	    write(fd, samples, ah.ad_samples * 2) == -1) {

		close( fd );
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "write failed";
		}
		return( -1 );
	}

	close( fd );

	oumask = umask(022);
	umask(oumask);
	if( chmod( filename, 0666 & ~ oumask) == -1 ) {
		if( errno < sys_nerr ) {
			ErrorString = sys_errlist[errno];
		} else {
			ErrorString = "chmod failed";
		}
		return( -1 );
	}

	return( 1 );

}
