/*
 * $Id: adc2ascii.c,v 1.2 1993/06/10 17:21:53 johans Exp $
 *
 */

/* Standard C libary include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Speech libary include file directives */
#include <speech.h>


/* global variable declarations */
char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */
int  start=0;                            /* starting location            */
int  stop=0;                             /* end point in display         */
int  infoflag=0;                         /* print information as well    */

FILE *outfile;


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | speech2ascii [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-b beginning sample point [0]\n");
  fprintf(stderr, "-e ending sample point [size]\n");
  fprintf(stderr, "-i add infomatiom about header\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:b:e:ih")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;

            case 'b':/* output file */
                start = atoi(optarg);
                break;

            case 'e':/* analysis window in msecs */
                stop = atoi(optarg);
                break;

            case 'i':/* infomation request */
                infoflag = 1;
                break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main (int argc, char *argv[])
{
  short *adcbuffer = NULL;               /* speech waveform buffer      */
  int   rate;                            /* Sampling rate in Hz         */
  int   numsamps;                        /* number of samples in buffer */ 
  int   end;
  int   i;

  get_comline(argc, argv);

  if( (numsamps = AdcRead(InFileName, &adcbuffer, &rate )) < 0 ) {   
    fprintf( stderr, "speech2ascii: %s: %s\n", InFileName, ErrorString );
    exit( 1 );
  }

  end = (stop == 0) ? numsamps : stop ;

  if (infoflag) {
    fprintf ( stdout, "NUMBER OF ADC POINTS: %d\n", numsamps);
    fprintf ( stdout, "Start: %d   Stop: %d\n", start, end ) ;
    fprintf ( stdout, "Sampling Rate: %d\n\n", rate);
  }

  if (strcmp(OutFileName, "-") == 0) {  /*  print to stdout  */
    outfile = stdout;
  } else {
    if (!(outfile = fopen(OutFileName, "w"))) {
      printf("Error opening output file: %s\n", OutFileName);
      exit(1);
    }
  }
    
  for ( i = start; i < end ; i++ ) {   
    fprintf ( outfile, " %6d%s", adcbuffer[i],
	     ((i % 10 == 9)||(i==end-1)) ? "\n" : "" ) ;
    
    if ( i % 100 == 99 ) {   
      fprintf ( outfile, "\nBegin %d\n", i+1 ) ;
    }
  }
  
  fclose(outfile);
  exit( 0 );
}

