#include <stdio.h>

struct TcpSoundStruct{
  FILE *readfp;
  FILE *writefp;
  char *filename;
  int fd;
};

typedef struct TcpSoundStruct *SoundFile;

extern SoundFileOpenSoundConnection();
extern voidCloseSoundConnection();

/****************************************************************************/
/*  TcpPlay Net Commands                                                    */
/****************************************************************************/

/* The net commands for TcpPlay begin with the bytes from a TcpPlayCmd      */
/* structure.  The 'idString' identifies the version of TcpPlay             */
/* protocol the sender is using and acts as assurance that the sender       */
/* and receiver are synchronized.  The 'cmd' is currently one of the        */
/* three constants defined below.  'dataLength' gives the number of         */
/* additional bytes in the command.                                         */


/* Structure for a TcpPlay net command */

typedef struct TcpPlayCmd {
    char    idString[8];        /* Expects "TcpPlay"                */
    short   cmd;                /* The command number               */
    long    dataLength;         /* The number of bytes to follow    */
  } TcpPlayCmd;


#define     TcpPlayString           "TcpPlay"

#define     NullCmd                 0   /* May have data            */
#define     QueryCmd                1   /* No data                  */
#define     StatusCmd               2   /* Has data                 */
#define     SoundDataCmd            3   /* Has data                 */


/* NullCmd                                                                  */
/*                                                                          */
/* May have data.  The command and data are read in and ignored.  This      */
/* command may be used for net performance measures.                        */


/* QueryCmd                                                                 */
/*                                                                          */
/* QueryCmd has no data.  The dataLength field should be zero.              */
/* The receiver of a QueryCmd should issue a StatusCmd to the sender.       */



/* StatusCmd                                                                */
/*                                                                          */
/* A StatusCmd has data.  The additional bytes in the command give          */
/* information about the capabilities of the TcpPlay server.                */


/* Parameters of the 'StatusCmd'    */

typedef struct StatusInfo
{
    short   version;        /* version of TcpPlay protocol          */
    short   channels;       /* Number of channels                   */
    short   hardwareType;   /* The type of sound hardware available */
    short   sampleSize;     /* maximum bits per sample              */
  } StatusInfo;

#define     TcpPlayProtocolVersion  1

/* Hardware Types */

#define     TcpPlayMacintosh        1
#define     TcpPlayCathedral        2
#define     TcpPlaySpecInnovations  3



/* SoundDataCmd                                                             */
/*                                                                          */
/* The SoundDataCmd signals that sound data will be sent next on the        */
/* connection.  The command supplies three parameters: sampleRate,          */
/* length, and sampleSize.  The 'length' is the number of bytes that        */
/* will be sent following this command.  The 'sampleRate' gives the         */
/* sample rate to be used by the Sound Manager.  The sampleSize is the      */
/* number of bytes per sample.                                              */


/* Parameters of the 'SoundDataCmd' */

typedef struct SoundDataArgs {
    long    sampleRate;         /* Fixed for use by the Sound Mgr   */
    long    length;             /* Length in ?bytes? of data stream */
    short   sampleSize;         /* Size of samples in bits          */
    short   channels;           /* Number of sample streams         */
  } SoundDataArgs;

#define   SoundDataArgsLength 8 /*  Size of data structure on wire */
