#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#ifdef __STDC__
#include <stdlib.h>
#endif  /* __STDC__ */
#include <math.h>
#include "play.h"


#define HOSTVARIABLENAME "SOUNDHOST"
#define DEFAULTHOST "kip-4"
#define PLAYPORT 800

/* 
 *The following code was taken from
 *BSD Sockets: A quick and dirty primer
 *By Jim Frost
 *madd@bu-it.bu.edu
 */

/* code to establish a socket; originally from bzs@bu-cs.bu.edu
 */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif  /* MAXHOSTNAMELEN */

int establish(portnum)
u_short portnum;
{
  char   myname[MAXHOSTNAMELEN+1];
  int    s;
  struct sockaddr_in sa;
  struct hostent *hp;

  memset(&sa,0,sizeof(struct sockaddr_in));/* clear our address */
  gethostname(myname,MAXHOSTNAMELEN);/* who are we? */
  hp= gethostbyname(myname);/* get our address info */
  if (hp == NULL)/* we don't exist !? */
    return(-1);
  sa.sin_family = hp->h_addrtype;/*this is our host address*/
  sa.sin_port =  htons(portnum);/*this is our port number */
  if ((s = socket(AF_INET,SOCK_STREAM,0)) < 0) /* create socket */
    return(-1);
  if (bind(s,(struct sockaddr *)&sa,sizeof sa) < 0)
    return(-1);/* bind address to socket */
  if ( listen(s,5) < 0)
    return(-1);
  return(s);
}

int get_connection(s)
     int s;                       /* socket created with establish() */
{
  struct sockaddr_in isa;    /* address of socket */
  int i;                     /* size of address */

  i = sizeof(isa);                   /* find socket's address */
  getsockname(s,&isa,&i);            /* for accept() */

  if ((i = accept(s,(struct sockaddr *)&isa,&i)) < 0)   /*accept connection if there is one*/
    return(-1);
  return(i);
}

int call_socket(hostname, portnum)
char *hostname;
{
  struct sockaddr_in sa;
  struct hostent     *hp;
  int sock;
  extern int errno;
  u_long address;


  address = inet_addr(hostname);
  memset(&sa,0,sizeof(sa));
  if (address == ~0L) {
    if ((hp= gethostbyname(hostname)) == NULL) { 
      /* do we know the host's */
      errno= ECONNREFUSED;    /* address? */
      return(-1);             /* no */
    }

    /* set address */
    memcpy((char *)&sa.sin_addr, hp->h_addr,hp->h_length); 
    sa.sin_family = hp->h_addrtype;
  } else {
    /* ARRRGGGGHHH!  This is
        * necessary because on the
	 * Cray we need the address
	  * in the first four bytes of
	   * the long.
	    */
#ifdef CRAY
    address <<= 32;
#endif  /* CRAY */
    memcpy((char *)&sa.sin_addr,&address, sizeof(address));
    sa.sin_family = AF_INET;
  }
  sa.sin_port = htons((u_short)portnum);

  if ((sock = socket(sa.sin_family,SOCK_STREAM,0)) < 0)/* get socket */
    return(-2);
  if (connect(sock,&sa,sizeof sa) < 0)    /* connect */
    return(-3);
  return(sock);
}

int read_data(s,buf,n)
int  s;                /* connected socket */
char *buf;             /* pointer to the buffer */
int  n;                /* number of characters (bytes) we want */
{
  int bcount,          /* counts bytes read */
  br;              /* bytes read this pass */

  bcount= 0;
  br= 0;
  while (bcount < n) {             /* loop until full buffer */
    if ((br= read(s,buf,n-bcount)) > 0) {
      bcount += br;           /* increment byte counter */
      buf += br;              /* move buffer ptr for next */
    }
    if (br < 0)                    /* signal an error to caller */
      return(-1);
  }
  return(bcount);
}

SoundFile OpenSoundConnection(progname, hostname, Synchronous)
     char *progname;
     char *hostname;
     int Synchronous;
{
  int fd;
  FILE *socketfp, *readfp;
  SoundFile sf;
  char *getenv();

  if (!hostname){
    hostname = getenv(HOSTVARIABLENAME);
    if (!hostname)
      hostname = DEFAULTHOST;
  }

  if (hostname == 0 || hostname[0] == 0){
    fprintf(stderr,"%s: No hostname specified.\n",progname);
    exit(1);
  }
  
  fd = call_socket(hostname,PLAYPORT);

  if (fd < 0){
    fprintf(stderr,
	    "%s: Couldn't open a socket to TcpPlay on host %s.\n",
	    progname, hostname);
    perror("socket");
    exit(1);
  }

  if (Synchronous){
    struct linger on;

    on.l_onoff = 1;
    on.l_linger = 240;/* 4 minutes */

    setsockopt(fd,SOL_SOCKET,SO_LINGER,&on,sizeof(on));
  }

  socketfp = fdopen(fd,"w");
  if (!socketfp){
    fprintf(stderr,"%s: write fdopen failed.\n");
    exit(1);
  }

  readfp = fdopen(fd,"r");
  if (!readfp){
    fprintf(stderr,"%s: read fdopen failed.\n");
    exit(1);
  }

  sf = (SoundFile) malloc(sizeof *sf);
  sf->readfp = readfp;
  sf->writefp = socketfp;
  sf->fd = fd;

  return sf;
}

void CloseSoundConnection(sf)
     SoundFile sf;
{
  fclose(sf->readfp);
  fclose(sf->writefp);
  close(sf->fd);
}

SendSoundChunk(bdata, Length, SamplingRate, sf, progname)
     char *bdata;
     int Length;
     float SamplingRate;
     SoundFile sf;
     char *progname;
{
  int i;

  SendCommand(sf, SoundDataCmd, SoundDataArgsLength+Length);
  Write16BitsHighLow(sf->writefp, (int)floor(SamplingRate));
  Write16BitsHighLow(sf->writefp, 
		     (int)floor((SamplingRate-floor(SamplingRate))*65536));
  Write16BitsHighLow(sf->writefp, 2);/* Bytes per sample */
  Write16BitsHighLow(sf->writefp, 1);/* Channels */
  i = fflush(sf->writefp);

  if (i < 0){
    fprintf(stderr,"%s: Header fflush failed.\n",progname);
    exit(1);
  }

#define MTU (1460)
  Length *= sizeof(*bdata);
  while (Length > 0){
    int Count;
    Count = Length>MTU? MTU: Length;
    i = write(sf->fd, bdata, Count);
    if (i != Count){
      fprintf(stderr,"%s: Data write failed with %d.\n",
	      progname,i);
      if (i < 0){
	perror("write");
      }
      exit(1);
    }
    bdata += Count;
    Length -= Count;
  }
}

SendCommand(sf, cmd, length)
     int cmd, length;
     SoundFile sf;
{
  fwrite(TcpPlayString, 1, 8, sf->writefp);
  Write16BitsHighLow(sf->writefp, cmd);
  Write32BitsHighLow(sf->writefp, length);
  fflush(sf->writefp);
}

MakeQuery(sf, ans)
     SoundFile sf;
     StatusInfo *ans;
{
  char Buffer[BUFSIZ];
  int Length;

  SendCommand(sf, QueryCmd, 0);

  while (!feof(sf->readfp)){
    int i;
    i = getc(sf->readfp);
    printf("Got %d (or %c).\n", i, i);
  }

  fread(Buffer, 8, 1, sf->readfp);
  if (strncmp(Buffer, TcpPlayString, 8) != 0){
    printf("MakeQuery: Query packet received with bad preamble.\n");
    exit(1);
  }
  if (Read16BitsHighLow(sf->readfp) != StatusCmd){
    printf(
	       "%s:  Query packet received with wrong command.\n");
    exit(1);
  }

  Length = Read32BitsHighLow(sf->readfp);

  ans->version = Read16BitsHighLow(sf->readfp); Length -= 2;
  ans->channels = Read16BitsHighLow(sf->readfp); Length -= 2;
  ans->hardwareType = Read16BitsHighLow(sf->readfp); Length -= 2;
  ans->sampleSize = Read16BitsHighLow(sf->readfp); Length -= 2;

  while (Length > 0){
    getc(sf->readfp);
    Length--;
  }
}

short MaxMag(data, length)
     short *data;
     int length;
{
  int i;
  short max = *data, f;

#include "ivdep.h"
  for (i=0;i<length;i++){
    f = abs(data[i]);
    if (f > max)
      max = f;
  }

  return max;
}

/*
 *RunRealTime - This code puts the program into a real time mode 
 *under the Unicos 6.0 operating system.  This helps make things run
 *faster and makes sure there are no hickups.
 */

#ifdef CRAY

#define CPUFILE "/dev/cpu/any"

#include <errno.h>
#include <sys/cpu.h>
#include <sys/category.h>

RunRealTime(){
  int i, fd;
  struct cpudev cpu;

  fd = open(CPUFILE,0);

  if (fd < 0) {
    fprintf(stderr, "Couldn't open %s for reading.\n", CPUFILE);
    return(0);
  }

  cpu.cat = C_PROC;
  cpu.id = 0;
  cpu.word = 0;

  i = ioctl(fd, CP_SETRT,(char *) &cpu);
  if (i < 0){
    fprintf(stderr, "CP_SETRT ioctl failed.\n");
    perror("ear: RunRealTime:");
  }
}

#else /*!CRAY*/
RunRealTime(){}
#endif/*Cray */

#ifdef MAIN

#include <ctype.h>
#include <math.h>

short *data;
unsigned char *bdata;

syntax(progname){
  fprintf(stderr,"syntax: %s [-host name] file\n",progname);
  fprintf(stderr,
	  " The default host is given by the %s enviroment variable.\n",
	  HOSTVARIABLENAME);
  exit(1);
}

extern int MaxSamples;
int SkipSamples = 0;

main(argc, argv)
     int argc;
     char *argv[];
{
  int i, Synchronous = 0, Query = 0;
  short *p;
  float max;
  unsigned char *bp;
  float SamplingRate, CommandSampleRate = 0;
  int Length;

  char *filename = 0, *hostname = 0, *getenv();
  SoundFile sf = 0;

  if (argc < 2){
    syntax(argv[0]);
  }
  for (i=1;i<argc-1;i++){
    if (argv[i][0] == '-'){
      if (strncmp(argv[i],"-host",5) == 0){
	hostname = argv[++i];
      } else if (strncmp(argv[i],"-rate",5) == 0){
	CommandSampleRate = atof(argv[++i]);
      } else if (strncmp(argv[i],"-sync",5) == 0){
	Synchronous = 1;;
      } else if (strncmp(argv[i],"-query",6) == 0){
	Query = 1;
      } else if (strncmp(argv[i],"-r",2) == 0 ||
		    strncmp(argv[i],"-p",2) == 0) {
	char *p = argv[i] + 2;
	SkipSamples = atoi(p);
	while (isdigit(*p))
	  p++;
	if ((*p == ':' || *p == '-') && isdigit(*++p))
	  MaxSamples = atoi(p);
	else if (*p == '+' && isdigit(*++p))
	  MaxSamples = SkipSamples + atoi(p);
	printf("Playing from %d to %d.\n", 
	       SkipSamples, MaxSamples);
      } else {
	fprintf(stderr,"Unknown option %s.\n",argv[i]);
	syntax(argv[0]);
      }
    }
  }

  filename = argv[i];
  if (filename == 0 || filename[0] == 0){
    fprintf(stderr,"%s: No filename specified.\n",argv[0]);
    syntax(argv[0]);
    exit(1);
  }

  if (Query){
    StatusInfo ans;

    sf = OpenSoundConnection(argv[0], hostname, Synchronous);

    MakeQuery(sf, &ans);
    printf("Status of TcpPlay on %s.\n", hostname);
    printf("\tTcpPlay Protocol Version %d.\n", ans.version);
    printf("\tNumber of output channels: %d.\n", ans.channels);
    printf("\tHardware Type: ");
    switch(ans.hardwareType){
    case TcpPlayMacintosh:
      printf("Macintosh\n");
      break;
    case TcpPlayCathedral:
      printf("Cathedral\n");
      break;
    case TcpPlaySpecInnovations:
      printf("Spectral Innovations\n");
      break;
    default:
      printf("Unknown type (%d).\n", 
	     ans.hardwareType);
    }
    printf("\tMaximum sample size: %d bits\n", ans.sampleSize);
  }

  fprintf(stderr,"Reading file\n");
  Length = SpeechRead(filename, &data, &SamplingRate);
  if (Length < 0){
    fprintf(stderr, "%s: Couldn't read the input file %s.\n", 
	    argv[0], filename);
    exit(1);
  }
  fprintf(stderr,"Done reading. (%d samples)\n",Length);

  data += SkipSamples;
  Length -= SkipSamples;

  if (CommandSampleRate > 0)
    SamplingRate =  CommandSampleRate;

  max = MaxMag(data,Length);
  max = 32760/max;
  bdata = (unsigned char *)data;

  {
    int i;
      for (p = data, bp = (unsigned char *)data;
	          p < data+Length;
	          p++, bp += 2)
	{
	        i = (*p * max);
		      *bp = (i&0xff00)>>8;
		      *(bp+1) = i&0xff;
	      }
  }

  if (!sf)
    sf = OpenSoundConnection(argv[0], hostname, Synchronous);

  printf("Playing sound with a sample rate of %g.\n", SamplingRate);

  SendSoundChunk(bdata, 2*Length, SamplingRate, sf, argv[0]);

  CloseSoundConnection(sf);
}


#endif MAIN
