/*
 * $Id: ow2nw.c,v 1.1 92/05/14 10:30:16 pochmara Exp $
 *
 */
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <speech.h>


main( int argc, char *argv[] )
{
	NeuralNet nn;
	int nlayers;
	int nconn;
	FILE *fp;
	float *w;
	int iter;
	int *sz;
	int i;


	if( argc != 3 ) {
		fprintf( stderr, "usage: ow2nw old_weight new_weight\n" );
		exit( 1 );
	}


	if( ( fp = fopen( argv[1], "r" ) ) == NULL ) {
		fprintf( stderr, "ow2nw: %s: ", argv[1] );
		perror( "" );
		fprintf( stderr, "\n" );
		exit( 1 );
	}

	fread( &iter, sizeof(int), 1, fp );
	fread( &nlayers, sizeof(int), 1, fp );

	sz = (int *)malloc( sizeof(int) * nlayers );

	if( sz == NULL ) {
		fprintf(stderr, "ow2nw: malloc failed\n" );
		exit( 1 );
	}

	fread( sz, sizeof(int), nlayers, fp );

	nconn = 0;
	for( i = 0; i < nlayers - 1; i++ ) {
		nconn += sz[i] * sz[i+1];
	}

	w = (float *)malloc( sizeof(float) * nconn );

	if( w == NULL ) {
		fprintf( stderr, "ow2nw: malloc fialed\n" );
		exit( 1 );
	}

	fread( w, sizeof(float), nconn, fp );

	fclose( fp );

	if( ( fp = fopen( argv[2], "w" ) ) == NULL ) {
		fprintf( stderr, "ow2nw: %s: ", argv[2] );
		perror( "" );
		fprintf( stderr, "\n" );
		exit( 1 );
	}

	nn.nn_iter = iter;
	nn.nn_nlayers = nlayers;
	nn.nn_sz = sz;
	nn.nn_w = w;

	if( NNWrite( fp, &nn ) < 0 ) {
		fprintf( stderr, "ow2nw: %s: %s\n", argv[2], ErrorString );
		exit( 1 );
	}

	fclose( fp );

	exit( 0 );
}
