/*
 * $Id: noptread.c,v 1.8 92/05/08 14:00:11 pochmara Exp $
 * 
 *
 * noptread
 *
 * noptread [-o output] weightfile
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <speech.h>
#include "opt.h"


FILE *inp, *outp;


static void eerror( char *where )
{
	perror( where );
	exit( 1 );
}

main( int argc, char *argv[] )
{
	NeuralNet nn;
	extern char *optarg;
	extern int optind;
	int il, i, i1, i2;
	char *output_file = NULL;
	char *weight_file;
	int c;


	while( (c = getopt( argc, argv, "o:" ) ) != EOF ) {
		switch( c ) {
                	case 'o':
		     		output_file = optarg;
                     		break;
                	case '?':
				noptread_print_usage();
				exit( 1 );
		}
	}

	if( ( argc - optind ) != 1 ) {
		noptread_print_usage();
		exit( 1 );
	}

	weight_file = argv[optind];

   	if( (inp = fopen(weight_file, "r")) == NULL ) {
		eerror( "Error reading input weight file" );
	}

	if( output_file == NULL ) {

		outp = stdout;

	} else {
		if( (outp = fopen(output_file, "w")) == NULL ) {
			eerror( "Error opening output results file" );
		}
	}

	if( NNRead( inp, &nn ) < 0 ) {
	  fprintf( stderr, "noptread: %s: %s\n", weight_file, ErrorString );
	  exit( 1 );
	}

  	fprintf( outp, "\nLayers: %d\n\n", nn.nn_nlayers );

  	for( il = 0; il < nn.nn_nlayers; il++ ) {
    		fprintf( outp, "layer %d has %d neurons\n", il + 1, 
								nn.nn_sz[il] );
  	}

  	fprintf( outp, "\n" );

  	fprintf( outp, "Weights:\n" );

  	for( il = 0; il < nn.nn_nlayers - 1; il++ ) {
    		fprintf( outp, "\n*** layer %d to layer %d ***\n", 
							il + 1, il + 2 );

    		for( i1 = 0; i1 < nn.nn_sz[il + 1]; i1++ ) {
      			fprintf( outp, "to neuron %d:\n", i1 + 1 );

      			for( i = 0; i < nn.nn_sz[il]; i++ ) {

				fprintf( outp, " %f", *(nn.nn_w + 
							nn.nn_layeridx[il] + 
						( nn.nn_sz[il] * i1 )+ i ) );
			}

      			fprintf( outp, "\n" );
    		}
  	}

	fclose( inp );

	if( output_file != NULL ) {
		fclose( outp );
	}

}
