/*
 * $Id: cgrd.c,v 1.20 1993/05/11 22:05:38 fanty Exp $
 *
 *  cgrd.c
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>
#include <ctype.h>
#include "nopt.h"

/*
 * From opt.c
 */
extern int DumpTime;



#define ST_CRIT 0.2	/* satisfactory decrease in gradient to stop line
			   search */

#define ITMAX  5	/* maximal # of iterations during 1 line search */

/*
 * Current interation count of current run of
 * CGrd().
 */
static int CurrentIteration = 0;

/*
 * Over all interation count of CGrd().
 */
static int OverAllIteration = 0;

/*
 * cgrd( )
 *
 * Subroutine to optimize the external function errfc. Uses
 * conjugate-gradient algorithm with restarts - see Powell 1977
 *
 * return value is optimal value found x: starts as pointer to initial guess
 * for position of optimum returned as pointer to optimal position found
 * nconn: dimensionality of *x nit: maximal number of iterations to try
 * optimization process tol: stopping criterion - if (gradient-squared)
 * becomes less than tol, iterations terminate
 *
 */
float CGrd(float **x, int nconn,int nit,float tol)
{
	float *pv1, *pv2, *pv3, *pv4, rtemp, rtemp2;

	static float fopt, gr0, gropt, df, alplim, alpha;
	static float dalpha, alphamin, *xc, *gc, fc, grc;
	static float fch, gr2s, temp, grs, *gopt, beta, gcg0;
	static float gamma, gamma_in, f0, gsq, gopt_sq;
	static float *g0, *s, *srst, *grst, *xopt;
	static int again, flag, one_up, iit, restart, ls_iit;

	/* 
	 * position and gradient of current point 
	 */

	xc = (float *) malloc( nconn * sizeof(float) );

	if( xc == NULL ) {
		perror( "xc malloc error" );
		exit( 1 );
	}

	gc = (float *) malloc( nconn * sizeof(float) );

	if( gc == NULL ) {
		perror( "gc malloc error" );
		exit( 1 );
	}

	/* 
	 * gradient at beginning of line search 
	 */

	g0 = (float *) malloc( nconn * sizeof(float) );

	if( g0 == NULL ) {
		perror( "g0 malloc error" );
		exit( 1 );
	}

	/* 
	 * gradient at minimum located so far 
	 */

	gopt = (float *) malloc( nconn * sizeof(float) );

	if( gopt == NULL ) {
		perror( "gopt malloc error" );
		exit( 1 );
	}

	/* 
	 * search direction for line search  
	 */

	s = (float *) malloc (nconn * sizeof (float));

	if( s == NULL ) {
		perror( "s malloc error" );
		exit( 1 );
	}

	/* 
	 * search direction, gradient for first iteration after restart 
	 */

	srst = (float *) malloc( nconn * sizeof(float) );
	
	if( srst == NULL ) {
		perror( "srst malloc error" );
		exit( 1 );
	}

	grst = (float *) malloc( nconn * sizeof(float) );

	if( grst == NULL ) {
		perror( "grst malloc error" );
		exit( 1 );
	}

	xopt = *x;
	fopt = errfc( xopt, gopt, nconn );
	CurrentIteration = 1;

	/* 
	 * df is estimate of function reduction 
	 * obtainable during line search 
	 */

	df = fopt;

	/* 
	 * restart = 2 => line search in direction of steepest descent
	 * restart = 1 => line search with Powell-restart 
	 */
	restart = 2;
	one_up = flag = 0;
	gcg0 = gopt_sq = 0.000;

	do
	{

		/* 
		 * flag = 1 => no decrease in function value during
		 * previous line search;
		 * flag = 2 => line search did not decrease gradient
		 * OK; must restart 
		 */

		if( flag & 1 ) {
			if( one_up ) {
				printf( "no decrease direction found\n" );
				break;
			} else {
				one_up = 1;
			}
		} else {
			one_up = 0;
		}

		if( flag & 2 ) {
			restart = 2;
		} else if( fabs( (double)gcg0 ) > 0.2 * gopt_sq ) {
			restart = 1;
		}

		if( restart == 0 ) {
			pv1 = gc;
			pv2 = grst;
			pv3 = pv1 + nconn;
			pv4 = srst;
			rtemp = rtemp2 = 0.000;

			for( ; pv1 < pv3; ) {
				rtemp += (*pv1) * (*pv2++);
				rtemp2 += (*pv1++) * (*pv4++);
			}

			gamma = rtemp / gamma_in;

			if( fabs( beta * gropt - gamma * rtemp2 ) > 
							0.2 * gopt_sq ) {
				restart = 1;

			} else {
				pv1 = s;
				pv2 = srst;
				pv3 = pv1 + nconn;
				pv4 = gc;
				for( ; pv1 < pv3; pv1++ ) {
					(*pv1) = beta * (*pv1) + gamma *
							(*pv2++) - (*pv4++);
				}
			}
		}

		if( restart == 2 ) {
			pv1 = s;
			pv2 = gopt;
			pv3 = pv1 + nconn;

			for( ; pv1 < pv3; ) {
				(*pv1++) = -(*pv2++);
			}

			restart = 1;

		} else if( restart == 1 ) {

			gamma_in = gropt - gr0;
			pv1 = s;
			pv2 = srst;
			pv3 = pv1 + nconn;
			pv4 = gc;
			rtemp = beta;

			for( ; pv1 < pv3; pv1++ ) {
				(*pv2++) = (*pv1);
				(*pv1) = rtemp * (*pv1) - (*pv4++);
			}

			pv1 = grst;
			pv2 = g0;
			pv3 = pv1 + nconn;
			pv4 = gc;

			for( ; pv1 < pv3; ) {
				(*pv1++) = (*pv4++) - (*pv2++);
			}

			restart = 0;

		}

		/* 
		 * Begin line search 
		 */

		flag = 0;

		/* 
		 * ls_iit = number of iterations during current line search 
		 */

		ls_iit = 0;
		pv1 = gopt;
		pv3 = pv1 + nconn;
		pv2 = g0;
		pv4 = s;
		rtemp = 0.0000;

		for( ; pv1 < pv3; ) {
			rtemp += (*pv1) * (*pv4++);
			(*pv2++) = (*pv1++);
		}

		gr0 = gropt = rtemp;

		if( CurrentIteration == 1 ) {
			alphamin = fabs( df / rtemp );
		}

		if( gr0 > 0 ) {
			flag = 1;
			restart = 2;
			continue;
		}

		f0 = fopt;
		alplim = -1;
		again = -1;
		dalpha = (alphamin < (rtemp = fabs( df / gropt )) ) 
							? alphamin : rtemp;

		alphamin = 0;

		do 
		{
			do
			{
				if( ls_iit ) {

					if( fch != 0 ) {
						gr2s += (temp + temp) / dalpha;
					} 

					if( alplim < -0.5 ) {
						dalpha = 9.00 * alphamin;
					} else {
						dalpha = 0.5 * 
							( alplim - alphamin );
					}

					grs = gropt + dalpha * gr2s;

					if( gropt * grs < 0 ) {
						dalpha *= gropt / (gropt - grs);
					}
				}

				/* 
				 * alpha = length of step along line;
				 * dalpha = change in alpha
				 * alphamin = position of min along line 
				 */

				alpha = alphamin + dalpha;
				pv1 = xc;
				pv2 = xopt;
				pv3 = s;
				pv4 = pv1 + nconn;
				rtemp = dalpha;

				for( ; pv1 < pv4; ) {
					(*pv1++) = (*pv2++) + rtemp * (*pv3++);
				}

				fc = errfc( xc, gc, nconn );

				ls_iit++;
				pv1 = gc;
				pv2 = s;
				pv3 = pv1 + nconn;
				rtemp2 = rtemp = 0.0000;

				for( ; pv1 < pv3; ) {
					rtemp2 += (*pv1) * (*pv1);
					rtemp += (*pv1++) * (*pv2++);
				}

				grc = rtemp;
				gsq = rtemp2;
				fch = fc - fopt;
				gr2s = (grc - gropt) / dalpha;
				temp = (fch + fch) / dalpha - grc - gropt;

				if( (fc < fopt) || 
				  ( (fc == fopt) && (grc / gropt > -1) ) ) {
					gopt_sq = gsq;
					fopt = fc;
					pv1 = xopt;
					xopt = xc;
					xc = pv1;
					pv1 = gopt;
					gopt = gc;
					gc = pv1;

					if( grc * gropt <= 0 ) {
						 alplim = alphamin;
					}

					alphamin = alpha;
					gropt = grc;
					dalpha = -dalpha;

					if( gsq < tol ) {
						*x = xopt;
						return fopt;
					}

					if( fabs( gropt / gr0 ) < ST_CRIT ) {
						break;
					}

				} else {
					alplim = alpha;
				}

				if( ls_iit > ITMAX ) {
					break;
				}


			} while (1);

			fc = fopt;

			pv1 = xc;
			pv2 = xopt;
			pv3 = pv1 + nconn;

			for( ; pv1 < pv3; ) {
				(*pv1++) = (*pv2++);
			}

			pv1 = gc;
			pv2 = g0;
			pv3 = pv1 + nconn;
			pv4 = gopt;
			rtemp = 0.000;

			for( ; pv1 < pv3; ) {
				(*pv1) = (*pv4++);
				rtemp += (*pv1++) * (*pv2++);
			}

			gcg0 = rtemp;
                        if( fabs(gropt - gr0) > tol ) {
				beta = (gopt_sq - gcg0) / (gropt - gr0);

				if( fabs(beta * gropt) < 0.2 * gopt_sq ) {
					break;
				}
                        }

			again++;
			if( again > 0 ) {
				flag += 2;
			}

		} while( flag < 1 );

		if( f0 <= fopt ) {
			flag += 1;
		}

		df = gr0 * alphamin;

		CurrentIteration++;
		OverAllIteration++;

		/*
		 * time to dump?
		 */
		if( ( OverAllIteration % DumpTime ) == 0 ) {
			*x = xopt;
			DumpWeights( OverAllIteration );
		}

	} while( OverAllIteration < nit );

	*x = xopt;

	return( fopt );

}

int GetCGrdIteration()
{
	return( OverAllIteration );
}

void SetCGrdIteration(int iter)
{
	OverAllIteration = iter;
}
