/*
 *
 * $Id: mu2wav.c,v 2.2 1993/06/10 17:16:04 johans Exp $
 *
 */

/* Standard C libary include file directives */
#include <sys/types.h>
#include <sys/stat.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/* Speech library include file directives */
#include <speech.h>

/* extern module header declarations */
int ulaw2linear(unsigned char ulawbyte);

#define TRUE		(1)
#define FALSE		(0)

/* global variable declarations */
char file[200]="-";                       /* Input file name / stdin      */
char outfile[200]="-";                    /* Output file name / stdout    */
int  samples_per_sec=8000;               /* Sample rate                  */


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | mu2wav [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-r sampling rate [8000Hz]\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:r:h")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(file, optarg);
                break;

            case 'o':  /* output file */
		strcpy(outfile, optarg);
		break;

            case 'r': /* adjust gain of speech signal */
		samples_per_sec = atoi(optarg);
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main(int argc, char *argv[] )
{
  struct stat st_info;               /* Status info of mulaw file  */
  unsigned char ulaw;                /* Mulaw file byte            */
  short *wav;                        /* Buffer to hold linear data */
  FILE *mup;                         /* Filehandle for mulaw file  */
  int i;

  get_comline(argc, argv);

  if (strcmp(file, "-") == 0)
    mup = stdin;
  else {
    if( ( mup = fopen( file, "r" ) ) == NULL ) {       /* Open file */
      fprintf( stderr, "mu2wav: %s: ", file );
      perror( NULL );
      exit( 1 );
    }

    if( stat( file, &st_info ) < 0 ) {          /* Get stats (size) */
      fprintf( stderr, "mu2wav: %s: ", file );
      perror( NULL );
      exit( 1 );
    }
  }

  wav = (short *)malloc( 600000 * 2 ); 
	                                               /* Allocate 2x space */
  if( wav == NULL ) {
    fprintf( stderr, "mu2wav: " );
    perror( NULL );
    exit( 1 );
  }

  /* byte at a time, read and convert. */
  i = 0;
  while( fread( &ulaw, sizeof( ulaw ), 1, mup ) == 1 ) {
    
    *(wav+i) = (short) ulaw2linear( ulaw );
    i++;
  }

  fclose( mup );

  /* Write the buffer, wav, as a wavfile */
  if( WavWrite( outfile, wav, i, samples_per_sec, 0) < 0) {
    fprintf( stderr, "mu2wav: %s: %s\n", outfile, ErrorString );
    exit( 1 );
  }
  
  exit( 0 );
}





