/*
 *
 * $Id: m.c,v 1.1 1993/05/13 20:24:38 johans Exp $
 *
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <malloc.h>
#include <stdio.h>
#include </projects/cslu/speech/work/src/include/speech.h>

extern int ulaw2linear();

#define TRUE		(1)
#define FALSE		(0)

static void usage();

main( argc, argv )
int argc;
char *argv[];
{
	struct stat st_info;               /* Status info of mulaw file */
	unsigned char ulaw;                /* Mulaw file byte */
	int samples_per_sec;               /* Sample rate */
	short *wav;                        /* Buffer to hold linear data */
	FILE *mup;                         /* Filehandle for mulaw file */
	int i;


	if( argc != 4 ) {
		usage();
		exit( 1 );
	}

	samples_per_sec = atoi( argv[1] );                    /* Get sample rate */

	if( ( mup = fopen( argv[2], "r" ) ) == NULL ) {       /* Open file */
		fprintf( stderr, "mu2wav: %s: ", argv[2] );
		perror( NULL );
		exit( 1 );
	}

	if( stat( argv[2], &st_info ) < 0 ) {                 /* Get stats (esp size) */
		fprintf( stderr, "mu2wav: %s: ", argv[2] );
		perror( NULL );
		exit( 1 );
	}

	wav = (short *)malloc( st_info.st_size * 2 );         /* Allocate 2x space */
	if( wav == NULL ) {
		fprintf( stderr, "mu2wav: " );
		perror( NULL );
		exit( 1 );
	}

        /* byte at a time, read and convert. */
	i = 0;
	while( fread( &ulaw, sizeof( ulaw ), 1, mup ) == 1 ) {

		*(wav+i) = (short) ulaw2linear( ulaw );
		i++;
	}

	fclose( mup );

        /* Write the buffer, wav, as a wavfile */
	if( WavWrite( argv[3], wav, st_info.st_size, samples_per_sec, 1 ) < 0) {
		fprintf( stderr, "mu2wav: %s: %s\n", argv[3], ErrorString );
		exit( 1 );
	}

	exit( 0 );
}

static void usage()
{
	fprintf( stderr, "usage: mu2wav <sample_rate> <mu_law_file> <wav_file>\n" );
}



