/* Standard C library include file directives */
#include <c.h>
#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>          /* for XtNminHeight */
#include <X11/Xatom.h>
#include <X11/Xmu/StdCmap.h>
#include <X11/Core.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xutil.h>

/* lyre includwe file directives */
#include <lyre.bm>
#include <lyre_mask.bm>
#include <LyreStringDefs.h>
#include <Yoke.h>
#include <color.h>
#include <main.h>

/* External variable declarations */
extern char *lyre_version;

/* external procedure header declarations */
static void CvtStringToFloat (XrmValue *args, Cardinal *nargs, XrmValue *from, 
			      XrmValue *to);

#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}

static XrmOptionDescRec opTable[] = {
	{"-config",	"*config", XrmoptionSepArg, (caddr_t)NULL},
};


void Quit (Widget w, XtPointer client_data, XtPointer call_data)
{
    exit(0);
}


void SyntaxErr (char *prog)
{
    fprintf( stderr, "Usage: %s\n", prog );
    exit( 1 );
}

static Widget TopLevel;


main (int argc, char **argv)
{
    Widget    TopBox;
    Widget    Bw, Yoke, VersionW;
    Arg       args[20];
    int       arg_cnt;
    String    config_str;
    XWMHints  xwmHints;
    AppData   app_data;
    Status    status;
    Window    happy_compiler;

    static XtCallbackRec callbacks[] = {
					{Quit, NULL},
					{NULL, NULL},};


    TopLevel = XtInitialize ("main", "lyre", opTable,
			     (Cardinal) XtNumber(opTable),
			     &argc, argv);

    XtGetApplicationResources(TopLevel,&app_data,color_lyre_resources,
			      XtNumber(color_lyre_resources),NULL,0);
    LYREaux_value = app_data.aux_value;
    if (LYREaux_value & LyreSynchronize)
      XSynchronize(XtDisplay(TopLevel),1);
    /*  LYREdump_resource_values(&app_data);*/
    
    
    LYREinstall_colormap(TopLevel,&app_data);
    if (LYREpseudo_color_flag)
      status = SetDisplayColors(TopLevel,&app_data);


    XtAddConverter (XtRString, XtRFloat, CvtStringToFloat, NULL, 0);

    if (argc != 1)
	SyntaxErr (argv[0]);

    arg_cnt = 0;
    TopBox = XtCreateManagedWidget ("topbox", formWidgetClass, TopLevel,
				    NULL, arg_cnt);
    happy_compiler = XtWindow(TopBox);
    status = XSetWMColormapWindows(XtDisplay(TopBox),
				   RootWindowOfScreen(XtScreen(TopBox)),
				   &happy_compiler,1);

    XtAlertInit (TopBox);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNlabel, lyre_version);
    VersionW = XtCreateManagedWidget ("Version", labelWidgetClass, TopBox,
				args, arg_cnt);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNcallback, callbacks);
    MyXtSetArg (args, arg_cnt, XtNfromHoriz, VersionW);
    MyXtSetArg (args, arg_cnt, XtNlabel, "QUIT");
    Bw = XtCreateManagedWidget ("button", commandWidgetClass, TopBox,
				args, arg_cnt);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, VersionW);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
    MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
    Yoke = XtCreateManagedWidget ("yoke", yokeWidgetClass, TopBox,
				  args, arg_cnt);

    XtRealizeWidget (TopLevel);

    xwmHints.flags = IconPixmapHint | IconMaskHint;
    xwmHints.icon_pixmap = XCreatePixmapFromBitmapData
	(XtDisplay(TopLevel), XtWindow(TopLevel), (char *) lyre_bits,
	lyre_width, lyre_height, (unsigned int) XBlackPixel, 
	 (unsigned int) XWhitePixel, 1);
    xwmHints.icon_mask = XCreatePixmapFromBitmapData
	(XtDisplay(TopLevel), XtWindow(TopLevel), (char *) lyre_mask_bits,
	lyre_mask_width, lyre_mask_height, (unsigned int) XBlackPixel, 
	 (unsigned int) XWhitePixel, 1);
    XSetWMHints (XtDisplay(TopLevel), XtWindow(TopLevel), &xwmHints);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNconfig, &config_str);
    XtGetValues (Yoke, args, arg_cnt);

    if (config_str) {
 	int i;

	for (i = 0; i < (int) strlen(config_str); i++) {
	    switch (config_str[i]) {
	    case 'w':
	    case 'W':
		AddWaveform(0, (caddr_t)Yoke,(caddr_t)atoi(&config_str[i+1]));
		break;
	    case 's':
	    case 'S':
		AddSpectrogram(0,(caddr_t)Yoke,(caddr_t)atoi(&config_str[i+1]));
		break;
	    case 'l':
	    case 'L':
		AddLola(0,(caddr_t)Yoke,(caddr_t)atoi(&config_str[i+1]));
		break;
	    default:
		break;
	    }
	}
    }

    XtMainLoop ();
}


DispatchPendingEvents ()
{
  XEvent event;

  while (XCheckMaskEvent (XtDisplay(TopLevel), -1, &event))
    XtDispatchEvent(&event);
}


static void CvtStringToFloat (XrmValue *args, Cardinal *nargs, XrmValue *from,
			      XrmValue *to)
{
    static float val;

    val = (float) atof(from->addr);

    to->size = sizeof(float);
    to->addr = (caddr_t) &val;
}

