/* Yoke.c - Yoke widget
 *------------------------------------------------------------*
 * HISTORY
 * Mar 8, 1989 Fil Alleva
 *    Added AddCochleagram()
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <ctype.h>
#include <math.h>

/* X Library include file directives */
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/CommandP.h>
#include <X11/Xaw/DialogP.h>

/* Lyre Include file directives */
#include <Adctool.h>
#include <Gspectool.h>
#include <Lgraph.h>
#include <Lspectool.h>
#include <Lolatool.h>
#include <Tsdtool.h>
#include <LScroll.h>
#include <LyreDisp.h>
#include <LyreDispP.h>
#include <YokeP.h>
#include <ToolUtil.h>

#include <c.h>
#include <ad.h>


/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

static void Initialize (Widget request_in, Widget new_in, ArgList arglist,
			Cardinal *num_args);
static void YokeAddWidget (YokeWidget yoke, Widget child);
static void YokeDeleteWidget  (Widget w, YokeWidget yw);
static void ToggleTracking (Widget cw, AdctoolWidget target_widget, 
			    caddr_t call_data);
static void SetGlobalResolution (Widget w, WidgetList client_data);

void AddWaveform (Widget w, caddr_t client_data, caddr_t call_data);
void AddSpectrogram (Widget w, caddr_t client_data, caddr_t call_data);
void AddLineogram (Widget w, caddr_t client_data, caddr_t call_data);
void AddLola (Widget w, caddr_t client_data, caddr_t call_data);


Boolean	defFALSE = FALSE;

static float floatZero = 0.0;

#define offset(field) XtOffset(YokeWidget, field)
static XtResource resources[] = { 
   {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t), 
      offset(yoke.callbacks), XtRCallback, (caddr_t)NULL},
   {XtNtrackingOn, XtCParameter, XtRBoolean, sizeof(Boolean), 
      offset(yoke.trackingOn), XtRBoolean, (caddr_t)&defFALSE},
   {XtNconfig, XtCParameter, XtRString, sizeof(XtRString),
      offset(yoke.config), XtRString, (caddr_t)NULL},
   {XtNtimeDuration, XtCParameter, XtRFloat, sizeof(float),
      offset(yoke.timeDuration), XtRString, (caddr_t) "0.0"},
};
#undef offset

YokeClassRec yokeClassRec = {
  {
    (WidgetClass) &formClassRec,	/* superclass		  */	
    "Yoke",				/* class_name		  */
    sizeof(YokeRec),			/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,				        /* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,		        	/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL,				/* extension		  */
  },  /* CoreClass fields initialization */
  { /* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
  },
  { /* constraint_class fields */
    /* subresourses       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(YokeConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL
  },
  {
    0,
  }, /* FormClass fields */
  {
    0,                                     /* field not used    */
  },  /* YokeClass fields initialization */
};

  /* for public consumption */
WidgetClass yokeWidgetClass = (WidgetClass) &yokeClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}

/*
 * Initialize(request, new)
 *
 */

static void Initialize (Widget request_in, Widget new_in, 
			ArgList arglist, Cardinal *num_args)
{
  YokeWidget request = (YokeWidget) request_in;
  YokeWidget new     = (YokeWidget) new_in;
  Widget  w, control, pane, bw, scroll, tmpw;
  Arg     args[20];
  int     arg_cnt;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
    MyXtSetArg (args, arg_cnt, XtNheight, 200);
    MyXtSetArg (args, arg_cnt, XtNwidth, 500);
    pane = XtCreateManagedWidget ("pane", panedWidgetClass, (Widget) new,
		args, arg_cnt);
    new->yoke.pane = (PanedWidget) pane;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromHoriz, pane);
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    control = XtCreateManagedWidget ("controls", formWidgetClass,
					   (Widget) new, args, arg_cnt);
    new->yoke.control = (FormWidget) control;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    MyXtSetArg (args, arg_cnt, XtNskipAdjust, TRUE);
    MyXtSetArg (args, arg_cnt, XtNmin, 14);
    MyXtSetArg (args, arg_cnt, XtNmax, 14);
    tmpw = XtCreateManagedWidget ("scrollform", formWidgetClass,
					   pane, args, arg_cnt);
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
    scroll = XtCreateManagedWidget ("scroll", lscrollWidgetClass, tmpw,
			        args, arg_cnt);
    new->yoke.scroll = (LScrollWidget) scroll;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Yoke");
    bw = XtCreateManagedWidget ("title", labelWidgetClass, 
				(Widget) control, args,arg_cnt);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Waveform");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				(Widget) control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, (XtCallbackProc) AddWaveform, new);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Tdat");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				(Widget) control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, (XtCallbackProc) AddSpectrogram, new);

#if 0
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Lineogram");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, (XtCallbackProc) AddLineogram, new);
#endif

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Lola");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				(Widget) control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, (XtCallbackProc) AddLola, new);

#if 0
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Toggle Tracking");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, (XtCallbackProc) ToggleTracking, new);
#endif

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel, "Global\nResolution");
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    MakePopup ((Widget)new, bw, NULL,
	       "Seconds per pixel:", "0.001" , "Set", "Abort",
	       (caddr_t)SetGlobalResolution);

    new->yoke.widgets = NULL;
    new->yoke.widget_count = 0;
}


void AddWaveform (Widget w, caddr_t client_data, caddr_t call_data)
{
    YokeWidget yoke = (YokeWidget) client_data;
    Widget Waveform;
    Arg    args[10];
    int arg_cnt;
    int	min_height = 128;

    if ((int) call_data != 0)
	min_height = (int) call_data;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, min_height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNallowResize, TRUE);
    Waveform = XtCreateManagedWidget ("waveform", adctoolWidgetClass,
				      (Widget) yoke->yoke.pane, args, arg_cnt);
    {
	Widget              child, mark = 0, scale;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	MyXtSetArg (args, arg_cnt, XtNmark, &mark);
	XtGetValues (Waveform, args, arg_cnt);

	XtAddCallback (child, XtNwidthProc, 
		       (XtCallbackProc) LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	XtAddCallback (mark, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);
	LScrollAddWidget ((Widget) mark, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);
	if(scale) {
	  XtAddCallback (scale, XtNdestroyCallback, 
			 (XtCallbackProc) LScrollDeleteWidget,
			 yoke->yoke.scroll);
	  LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);
	}

	YokeAddWidget (yoke, child);
    }
}


void AddSpectrogram (Widget w, caddr_t client_data, caddr_t call_data)
{
    YokeWidget yoke = (YokeWidget) client_data;
    Widget SpecW;
    Arg    args[10];
    int arg_cnt;
    int	min_height = 128;

    if ((int) call_data != 0)
	min_height = (int) call_data;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, min_height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNallowResize, TRUE);
    SpecW = XtCreateManagedWidget ("tdat", gspectoolWidgetClass,
				  (Widget) yoke->yoke.pane, args, arg_cnt);
    {
	Widget              child, scale;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	XtGetValues (SpecW, args, arg_cnt);
	XtAddCallback (child, XtNwidthProc, 
		       (XtCallbackProc) LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);

	if (scale) {
	  XtAddCallback (scale, XtNdestroyCallback, 
			 (XtCallbackProc) LScrollDeleteWidget,
			 yoke->yoke.scroll);
	  LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);
	}
	YokeAddWidget (yoke, child);
    }
}


#if 0
void AddLineogram (Widget w, caddr_t client_data, caddr_t call_data)
{
    YokeWidget yoke = (YokeWidget) client_data;
    Widget LspecW;
    Arg    args[10];
    int arg_cnt;
    int	min_height = 128;

    if ((int) call_data != 0)
	min_height = (int) call_data;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, min_height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    LspecW = XtCreateManagedWidget ("lineogram", lspectoolWidgetClass,
				  yoke->yoke.pane, args, arg_cnt);
    {
	Widget              scale, child;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	XtGetValues (LspecW, args, arg_cnt);
	XtAddCallback (child, XtNwidthProc, LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);
	XtAddCallback (scale, XtNdestroyCallback, LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);

	YokeAddWidget (yoke, child);
    }
}
#endif


void AddLola (Widget w, caddr_t client_data, caddr_t call_data)
{
    YokeWidget yoke = (YokeWidget) client_data;
    Widget LolaW;
    Arg    args[10];
    int arg_cnt;
    int	min_height = 64;

    if ((int) call_data != 0)
	min_height = (int) call_data;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, min_height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    LolaW = XtCreateManagedWidget ("lola", lolatoolWidgetClass,
				  (Widget) yoke->yoke.pane, args, arg_cnt);
    {
	Widget              scale, child;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	XtGetValues (LolaW, args, arg_cnt);
	XtAddCallback (child, XtNwidthProc, 
		       (XtCallbackProc) LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);
	if(scale)
	  {
	    XtAddCallback (scale, XtNdestroyCallback, 
			   (XtCallbackProc) LScrollDeleteWidget,
			   yoke->yoke.scroll);
	    LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);
	  }
	YokeAddWidget (yoke, child);
    }
}


static void YokeAddWidget (YokeWidget yoke, Widget child)
{
    int                 arg_cnt;
    Arg                 args[10];

    yoke->yoke.widget_count++;
    yoke->yoke.widgets = (WidgetList) 
      XtRealloc ((char *) yoke->yoke.widgets, 
		 (Cardinal) sizeof (Widget) * yoke->yoke.widget_count);
    yoke->yoke.widgets[yoke->yoke.widget_count - 1] = child;
    XtAddCallback (child, XtNdestroyCallback, 
		   (XtCallbackProc) YokeDeleteWidget, yoke);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNscrollWidget, yoke->yoke.scroll);
    MyXtSetArg (args, arg_cnt, XtNyokeWidget, yoke);
    XtSetValues (child, args, arg_cnt);
}


static void YokeDeleteWidget  (Widget w, YokeWidget yw)
{
    WidgetList wltmp = (WidgetList) XtMalloc (sizeof(Widget)
					      * yw->yoke.widget_count);
    register int i, j;

    for (j = 0, i = 0; i < yw->yoke.widget_count; i++) {
	if (yw->yoke.widgets[i] != w)
	    wltmp[j++] = yw->yoke.widgets[i];
    }
    if (j == i)
	fprintf (stderr, "YokeDeleteWidget: Warning widget not found\n");
    XtFree ((char *) yw->yoke.widgets);
    yw->yoke.widgets = wltmp;
    yw->yoke.widget_count--;
}


static void ToggleTracking (Widget cw, AdctoolWidget target_widget, 
			    caddr_t call_data)
{
    YokeWidget w = (YokeWidget) target_widget;
    w->yoke.trackingOn = !w->yoke.trackingOn;
}


static void SetGlobalResolution (Widget w, WidgetList client_data)
{
    DialogWidget dw = (DialogWidget) client_data[1];
    YokeWidget yw = (YokeWidget) client_data[2];
    Arg    args[10];
    int arg_cnt = 0;
    int	i;
    char *in = XawDialogGetValueString((Widget) dw);
    union {
      float f;
      int  l;
    } value;

    value.f = atof(in);

    for (i = 0; i < yw->yoke.widget_count; i++) {
	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNsecsPpix, value.l);
	XtSetValues (yw->yoke.widgets[i], args, arg_cnt);
    }
}
