/* VDATA.H - vector data object
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 *    Jun 14, 1989 Fil Alleva at OGC
 *        Added secs_per_datum field.
 */

#ifndef _VDATA_H_
#define _VDATA_H_

#include <sys/types.h>

typedef struct _vdata {
    u_int		bsize;		/* Size of a datum in bytes*/
    u_int		count;		/* Number of datums */
    u_int		ns_per_datum;	/* Nano-seconds per datum */
    float               secs_per_datum; /* Seconds per datum */
    caddr_t		ptr;		/* Pointer to the data */
} vdata_t;

#endif _VDATA_H_
