static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/syncasync.c,v 4.1 1993/05/07 18:17:20 johans Exp $";

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/*
 * syncasync(sync, sync_cnt, delta, async, async_cnt)
 *
 * sync     (out): Output Sync Map
 * sync_cnt (out): Count
 * async     (in): Async values
 * async_cnt (in): Count
 * delta    (out): Delta for the sync array
 */

syncasync (int **sync, int *sync_cnt, int *delta, int *async, int async_cnt)
{
    register int i, idx;
    int *ip0;
    register int *fp0, *fp1;
    register int diff, min_diff;
    register int atime;

    free (*sync);

    /*
     * Compute minimum difference
     */
    fp0 = async;
    fp1 = async + 1;
    min_diff = *fp1++ - *fp0++;
    for (i = 2; i < async_cnt; i++) {
	diff = *fp1++ - *fp0++;
	if ((diff > 0) && (diff < min_diff))
	    min_diff = diff;
    }

    /*
     * min_diff must be greater than 0
     */
    if (min_diff <= 0) {
	printf ("syncasync: min_diff is %d\n", min_diff);
	min_diff = async[async_cnt-1] - 0;
	if (min_diff <= 0.0) {
	    printf ("syncasync: min_diff is still %d\n", min_diff);
	    return (-1);
	}
    }

    *sync_cnt = 1 + (async[async_cnt-1] - 0) / min_diff;

    *sync = (int *) malloc (sizeof(int) * *sync_cnt);

    /*
     * Compute the synchronous mapping to the asynchronous data
     * N.B. since min_diff represents the minimum resolution of
     *      of the async data we're guaranteed a one to many mapping
     */

    atime = 0;
    fp0 = async;
    ip0 = *sync;    
    for (idx = i = 0; i < *sync_cnt; i++, atime += min_diff) {
	*ip0++ = idx;
	if (atime >= *fp0) {
	    fp0++;
	    idx++;
	}
    }

    *delta = min_diff;

    return (0);
}
