static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/main.c,v 4.4 1993/05/28 21:27:40 johans Exp $";

/* Standard C library include file directives */
#include <c.h>
#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>		/* for XtNminHeight */
#include <X11/Xatom.h>
/* #include <X11/Xatomtype.h> */
#include <X11/Xmu/StdCmap.h>
#include <X11/Core.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xutil.h>

/* Lyre include file directives */
#include <lyre.bm>
#include <lyre_mask.bm>
#include <LyreStringDefs.h>
#include <Yoke.h>
#include <color.h>
#include <main.h>

/* external variable declarations */
extern char *lyre_version;
void PollDataFiles (caddr_t client_data);
static void CvtStringToFloat (char **args, int nargs, 
			      XrmValue *from, XrmValue *to);

#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}


/* for parsing config strings */
#define ALPHA 0
#define NUM 1
#define SUFF 2
#define SEP 3
#define UNKNOWN 4

static XrmOptionDescRec opTable[] = {
	{"-config",	"*config", XrmoptionSepArg, (caddr_t)NULL},
	{"-basename",	"*basename", XrmoptionSepArg, (caddr_t) "test"},
};


void Quit (Widget w)
{
    exit(0);
}


usage ()
{
  fprintf(stderr,"usage:  auto_lyre [resource options]\n\n");
  fprintf(stderr,"auto_lyre reads and displays files specified by a config string.\n");
  fprintf(stderr,"If the files do not exist, it waits for them to appear.\n");
  fprintf(stderr,"After reading all the files, it waits for the modification time\n");
  fprintf(stderr,"of the first file to change, then it re-reads them all.\n");
  fprintf(stderr,"Files being written while auto_lyre is running should not have\n");
  fprintf(stderr,"read permission until they are complete.  The files are read in\n");
  fprintf(stderr,"the order specified by the config string.  All reads block until\n");
  fprintf(stderr,"the file appears.\n");
  fprintf(stderr,"\nThe options particular to the lyre application are\n");
  fprintf(stderr,"\t-basename <name>   The basename of all files read. Default: test\n");
  fprintf(stderr,"\t-config <string>   <string> has comma-separated window specifiers:\n");
  fprintf(stderr,"\n\te.g. -config \"Wp200.adc,W100.sd,S200.dft,L100.seg\" \n\n");
  fprintf(stderr,"\t(1) Waveform window with pitch marks (from test.pitch --\n");
  fprintf(stderr,"\t    pitch suffix fixed), min height 200, file test.adc\n");
  fprintf(stderr,"\t(2) Waveform window, min height 100, file test.sd\n");
  fprintf(stderr,"\t(3) Tdat (Spectogram) window, min height 200, file test.dft\n");
  fprintf(stderr,"\t(4) Lola window, min height 100, file test.seg\n");
  fprintf(stderr,"\t    The file test.ans should contain a single letter.\n");
}

static    Widget              TopLevel;


#define superclass (WidgetClass)(3&widgetClassRec)

main (u_int argc, char **argv)
{
  Widget   TopBox, WF;
  Widget   Bw, Yoke, VersionW;
  Arg      args[20];
  int      arg_cnt;
  char	   *config_str = 0;
  XWMHints xwmHints;
  AppData  app_data;	
  Status   status;
  Window   happy_compiler;

  static XtCallbackRec callbacks[] = {
    {(XtCallbackProc) Quit, NULL},
    {NULL, NULL},};
  
  TopLevel = XtInitialize ("main", "auto_lyre", opTable,
			   XtNumber(opTable), &argc, argv);

  XtGetApplicationResources(TopLevel,&app_data,color_lyre_resources,
			    XtNumber(color_lyre_resources),NULL,0);

  LYREaux_value = app_data.aux_value;
  if (LYREaux_value & LyreSynchronize)
      XSynchronize(XtDisplay(TopLevel),1);
/*  LYREdump_resource_values(&app_data);*/


  LYREinstall_colormap(TopLevel,&app_data);
  if (LYREpseudo_color_flag)
     status = SetDisplayColors(TopLevel,&app_data);

  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNmappedWhenManaged, False);
  XtSetValues(TopLevel,args,arg_cnt);
  
  XtAddConverter (XtRString, XtRFloat, 
		  (XtConverter) CvtStringToFloat, NULL, 0);

  /* check for help request */
  if (argc != 1) {
      usage();
      exit(1);
    }
  
  arg_cnt = 0;
  TopBox = XtCreateManagedWidget ("topbox", formWidgetClass, TopLevel,
				  NULL, arg_cnt);

  happy_compiler = XtWindow(TopBox);
  status = XSetWMColormapWindows(XtDisplay(TopBox),RootWindowOfScreen(XtScreen(TopBox)),
				 &happy_compiler,1);
  
  XtAlertInit (TopBox);
  
  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
  MyXtSetArg (args, arg_cnt, XtNright, XtChainLeft);
  MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
  MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
  MyXtSetArg (args, arg_cnt, XtNlabel, lyre_version);
  VersionW = XtCreateManagedWidget ("Version", labelWidgetClass, TopBox,
				    args, arg_cnt);
  
  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
  MyXtSetArg (args, arg_cnt, XtNright, XtChainLeft);
  MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
  MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
  MyXtSetArg (args, arg_cnt, XtNcallback, callbacks);
  MyXtSetArg (args, arg_cnt, XtNfromHoriz, VersionW);
  MyXtSetArg (args, arg_cnt, XtNlabel, "QUIT");
  Bw = XtCreateManagedWidget ("button", commandWidgetClass, TopBox,
			      args, arg_cnt);
  
  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNfromVert, VersionW);
  MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
  MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
  MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
  MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
  MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
  MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
  Yoke = XtCreateManagedWidget ("yoke", yokeWidgetClass, TopBox,
				args, arg_cnt);

  XtRealizeWidget (TopLevel);
  
  xwmHints.flags = IconPixmapHint | IconMaskHint;
  xwmHints.icon_pixmap = XCreatePixmapFromBitmapData
    (XtDisplay(TopLevel), XtWindow(TopLevel), (char *) lyre_bits,
     lyre_width, lyre_height, (u_long) XBlackPixel, (u_long) XWhitePixel, 1);
  xwmHints.icon_mask = XCreatePixmapFromBitmapData
    (XtDisplay(TopLevel), XtWindow(TopLevel), (char *) lyre_mask_bits,
     lyre_mask_width, lyre_mask_height, (u_long) XBlackPixel, 
     (u_long) XWhitePixel, 1);
  XSetWMHints (XtDisplay(TopLevel), XtWindow(TopLevel), &xwmHints);

  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNconfig, &config_str);
  XtGetValues (Yoke, args, arg_cnt);


  /*
   * Parse the config string.  Window specifiers are separated by commas.
   * Each window specifier has the form:
   * <Window Type Letter>[<option letters>][<min height>][<suffix>]
   *
   * So "Wp200.adc,S300.dft" specifies a waveform window with pitch marks,
   * a min height of 200 pixels and a ".adc" suffix on its files.  Below
   * that there is a spectogram window with min height of 300 pixels and
   * a ".dft" suffix on its files.
   *
   * The repeated code could be avoided ...
   */

  if (config_str) {
    int i,len;
    
    for (i = 0; i < (int) strlen(config_str); ) {
      while(i < (int) strlen(config_str) &&
	    (isspace(config_str[i]) || config_str[i] == ','))
	i++;
      if (i >= (int) strlen(config_str)) break;
      switch (config_str[i]) {
      case 'w':       /* waveform (adc) window */
      case 'W':
	{
	  char suf[30];
	  int height = 0;
	  int pitch = FALSE;
	  int tok = UNKNOWN;
	  
	  suf[0] = '\0';
	  /* parse up to separator */
	  i += 1;
	  while(i < (int) strlen(config_str) && tok != SEP)
	    {
	      switch(tok = gettok(&(config_str[i]),&len))
		{
		case ALPHA:
		  if(config_str[i] == 'p')
		    pitch = TRUE;
		  else
		    fprintf(stderr,"config string confused: %s\n",&(config_str[i]));
		  break;
		case NUM:
		  height = atoi(&(config_str[i]));
		  break;
		case SUFF:
		  strncpy(suf,&(config_str[i+1]),len-1);
		  suf[len-1] = '\0';
		  break;
		case SEP:
		  break;
		case UNKNOWN:
		  fprintf(stderr,"config string confused: %s\n",
			  &(config_str[i]));
		}
	      i += len;
	    }
	  
	  AddPollWaveform(Yoke,height,suf,pitch);
	}
	break;
      case 's':
      case 'S':
	{
	  char suf[30];
	  int height = 0;
	  int tok = UNKNOWN;
	  
	  suf[0] = '\0';
	  /* parse up to separator */
	  i += 1;
	  while(i < (int) strlen(config_str) && tok != SEP)
	    {
	      switch(tok = gettok(&(config_str[i]),&len))
		{
		case ALPHA:
		  fprintf(stderr,"config string confused: %s\n",
			  &(config_str[i]));
		  break;
		case NUM:
		  height = atoi(&(config_str[i]));
		  break;
		case SUFF:
		  strncpy(suf,&(config_str[i+1]),len-1);
		  suf[len-1] = '\0';
		  break;
		case SEP:
		  break;
		case UNKNOWN:
		  fprintf(stderr,"config string confused: %s\n",
			  &(config_str[i]));
		}
	      i += len;
	    }
	  AddPollSpectrogram(Yoke,height,suf);
	}
	break;
      case 'l':
      case 'L':
	{
	  char suf[30];
	  int height = 0;
	  int tok = UNKNOWN;
	  
	  suf[0] = '\0';
	  /* parse up to separator */
	  i += 1;
	  while(i < (int) strlen(config_str) && tok != SEP)
	    {
	      switch(tok = gettok(&(config_str[i]),&len))
		{
		case ALPHA:
		  fprintf(stderr,"config string confused: %s\n",
			  &(config_str[i]));
		  break;
		case NUM:
		  height = atoi(&(config_str[i]));
		  break;
		case SUFF:
		  strncpy(suf,&(config_str[i+1]),len-1);
		  suf[len-1] = '\0';
		  break;
		case SEP:
		  break;
		case UNKNOWN:
		  fprintf(stderr,"config string confused: %s\n",
			  &(config_str[i]));
		}
	      i += len;
	    }
	  AddPollLola(Yoke,height,suf);
	}
	break;
#if 0
      case 'f':
      case 'F':
	{
	  char suf[30];
	  int height = 0;
	  int tok = UNKNOWN;
	  
	  suf[0] = '\0';
	  /* parse up to separator */
	  i += 1;
	  while(i < strlen(config_str) && tok != SEP)
	    {
	      switch(tok = gettok(&(config_str[i]),&len))
		{
		case ALPHA:
		  fprintf(stderr,"config string confused: %s\n",
			  &(config_str[i]));
		  break;
		case NUM:
		  height = atoi(&(config_str[i]));
		  break;
		case SUFF:
		  strncpy(suf,&(config_str[i+1]),len-1);
		  suf[len-1] = '\0';
		  break;
		case SEP:
		  break;
		case UNKNOWN:
		  fprintf(stderr,"config string confused: %s\n",
			  &(config_str[i]));
		}
	      i += len;
	    }
	  AddPollLineogram(Yoke,height,suf);
	}
	break;
#endif
      default:
	break;
      }
    }
  }
  
  /* normally a callback; only 2nd arg used; others fillers */
  /* we don't need XtMainLoop, as Polling dispatches events */

  XtMapWidget(TopLevel);
  XtAddTimeOut((int)500, (XtTimerCallbackProc) PollDataFiles,(caddr_t) Yoke);
  XtMainLoop();
}


/* 
 * gettok (str, len_p)
 *
 * Get tokens from input string
 *
 */

int  gettok(char *str, int *len_p)
{
  int i;
  
  /* single letter */
  if(isalpha(str[0]))
    {
      *len_p = 1;
      return ALPHA;
    }

  /* string of digits */
  for(i = 0;isdigit(str[i]);i++);
  if(i > 0)
    {
      *len_p = i;
      return NUM;
    }
  
  /* '.' followed by string of letters or digits */

  if(str[0] == '.')
    {
      for(i = 1;isalnum(str[i]) || str[i] == '_';i++);
      *len_p = i;
      return SUFF;
    }

  /* ',' */

  if(isspace(str[0]) || str[0] == ',')
    {
      *len_p = 1;
      return SEP;
    }

  *len_p = 1;
  return UNKNOWN;
}


/*
 * DispatchPendingEvents()
 *
 * Dispatches, executes event currently in the event cue.
 *
 */

DispatchPendingEvents ()
{
  XEvent event;

  while (XCheckMaskEvent (XtDisplay(TopLevel), -1, &event))
    XtDispatchEvent(&event);
}



/*
 * CvtStringToFloat (args, nargs, from, to)
 *
 */

static void CvtStringToFloat (char **args, int nargs, 
			      XrmValue *from, XrmValue *to)
{
    static float val;

    val = (float) atof(from->addr);

    to->size = sizeof(float);
    to->addr = (caddr_t) &val;
}
