/*$header$*/
/* GS.H - gray scale structure
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 */

#ifndef _GS_H_
#define _GS_H_

#include <sys/types.h>

typedef struct _gs {
    Pixel	*pcolors;	/* positive colors */
    Pixel	*ncolors;	/* negative colors */
    Pixel	low_color; 	   /*  base colors for mappings*/
    Pixel	zero_color;
    Pixel	high_color;	
    float	posmin;		/* Positive min range value */
    float	posmax;		/* Positive max range value */
    int		poscolors;	/* Positive number of colors */
    float	negmin;		/* Negative min range value */
    float	negmax;		/* Negative max range value */
    int		negcolors;	/* Negative number of colors */
    float	exp;		/* Exponent */
    int		input_poscolors;	/* New Positive number of colors */
    int		input_negcolors;	/* New Negative number of colors */
    u_int       width;          /* width of gs bitmap */
    u_int       height;         /* height of gs bitmap */
    Pixel	**gmap;		/* Bitmaps for grey scale */
} gs_t;

typedef struct _height {
    int		**data;		/* Pointer to individual gs bitmap vecs */
    u_int	cnt;		/* Number height vectors */
} height_t;

#endif  _GS_H_

