/*$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/color_lyre.h,v 4.1 1993/05/07 18:22:06 johans Exp $*/

/* these constants are/were used in the debugging phase,
   setting the resource variable auto_lyre.aux_value to any
   combination of these will generate copious amounts of info.
   Some of this verbage may be suppressed by turning debugging off.
   Some not.  doc'd for historical reason.  some of these no
   longer do anything.
*/

#define	LyreCopyPlaneAnyway 	(1L << 0)
#define LyreShowDithering	(1L << 1)
#define	LyreSynchronize		(1L << 2)
#define LyrePaintSolidLines	(1l << 3)
#define LyreMakeColorBars   	(1l << 4)
#define LyrePrintDvals   	(1l << 5)
#define LyrePrintShades   	(1l << 6)
#define LyreDumpColorVectors   	(1l << 7)


typedef struct {	
    char	*fg_text;
    Pixel	fg;
    char	*bg_text;
    Pixel	bg;
    Boolean	debug_flag;
    Boolean	trace_flag;
    int		aux_value;
    char	*color_names[3];
    Pixel	low_color;
    Pixel	zero_color;
    Pixel	high_color;
    int		prange;
    int		nrange;
    } AppData, *AppDataPtr;


/* oh, the globals.  well, i'm embarassed.  for debugging, however,
   they are essential.  See the note in Color.doc
*/

extern	Boolean		LYREpseudo_color_flag;
extern	Boolean		LYREbest_colormap_installed;
extern	Colormap 	LYRElocal_colormap;
extern	int		LYREcolormap_size;
extern	int		LYREaux_value;


/* the externs */

extern void 	PRTindent();
extern void 	PRTenter();
extern void 	PRTexit();
extern	Pixel	*LYREpcolors;
extern	Pixel	*LYREncolors;
extern	RGB	*LYRErgbs;

Status GetRGBColorsByName(Widget w, char *base_names[] ,RGB *rgbs, int num);
Status FillNewColormap(GspecWidget  w, Colormap cmap, RGB *rgbs );
Status LYREinstall_colormap(Widget w, AppData *appdata);
Status SetDisplayColors(Widget w, AppData *target);

void GetClosestPixel(GspecWidget w, Pixel pixel, XColor *xcolor);
void DumpColorVectors(GspecWidget w);
void ColorComputeImageX (GspecWidget w, double PixPerDatum);
void ComputeColMin (GspecWidget w);
void LYREdump_resource_values(AppData *target);
void SumHeightVectors(GspecWidget w);

int GlobalMin (GspecWidget w);
int LocalMin (GspecWidget w, register int col);

/* Not Needed Stuff */
/*
extern	void	LYRENEWsetup_colorstuff();
extern	void 	ComputeColMin ();
extern	void 	ComputeColMin1 ();
extern	void 	ComputeColMin2 ();
extern	void 	ComputeColMin4 ();
*/


#define	XtNfg		"foreground"
#define	XtCfg		"foreground"
#define	XtNbg		"background"
#define	XtCbg		"background"
#define	XtNLYREdebug	"debug"
#define	XtCLYREdebug	"Debug"
#define XtNLYREtrace	"trace"
#define XtCLYREtrace	"Trace"
#define XtNLYREaux	"aux"
#define	XtCLYREaux	"Aux"
#define XtNLYRElow_color	"low_color"
#define XtCLYRElow_color	"Low_color"
#define XtNLYREzero_color	"zero_color"
#define XtCLYREzero_color	"Zero_color"
#define XtNLYREhigh_color	"high_color"
#define XtCLYREhigh_color	"High_color"
#define XtNprange	"pos_range"		/* (int) range of values */
#define XtNnrange	"neg_range"		/* (int) range of values */
#define XtCprange	"Pos_range"		/* (int) range of values */
#define XtCnrange	"Neg_range"		/* (int) range of values */

static XtResource color_lyre_resources[] = {
    {
    XtNfg,
    XtCfg,
    XtRString,
    sizeof(char*),
    XtOffset(AppDataPtr, fg_text),
    XtRString,
    "black"	},

    {	
    XtNfg,
    XtCfg,
    XtRPixel,
    sizeof(Pixel),
    XtOffset(AppDataPtr, fg),
    XtRString,
    "black"	},

    {
    XtNbg,
    XtCbg,
    XtRString,
    sizeof(char*),
    XtOffset(AppDataPtr, bg_text),
    XtRString,
    "white"	},

    {	
    XtNbg,
    XtCbg,
    XtRPixel,
    sizeof(Pixel),
    XtOffset(AppDataPtr, bg),
    XtRString,
    "white"	},
    
    {
    XtNLYREdebug,
    XtCLYREdebug,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr, debug_flag),
    XtRImmediate,
    (caddr_t) FALSE},

    {
    XtNLYREtrace,
    XtCLYREtrace,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr, trace_flag),
    XtRImmediate,
    (caddr_t) FALSE},

    {
    XtNLYREaux,
    XtCLYREaux,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr, aux_value),
    XtRImmediate,
    (caddr_t) NULL},

    {
    XtNLYRElow_color,
    XtCLYRElow_color,
    XtRString,
    sizeof(char*),
    XtOffset(AppDataPtr, color_names[0]),
    XtRString,
    "blue"},

    {
    XtNLYRElow_color,
    XtCLYRElow_color,
    XtRPixel,
    sizeof(Pixel),
    XtOffset(AppDataPtr, low_color),
    XtRString,
    "blue"},

    {
    XtNLYREzero_color,
    XtCLYREzero_color,
    XtRString,
    sizeof(char*),
    XtOffset(AppDataPtr, color_names[1]),
    XtRString,
    "white"},

    {
    XtNLYREzero_color,
    XtCLYREzero_color,
    XtRPixel,
    sizeof(Pixel),
    XtOffset(AppDataPtr, zero_color),
    XtRString,
    "white"},


    {
    XtNLYREhigh_color,
    XtCLYREhigh_color,
    XtRString,
    sizeof(char*),
    XtOffset(AppDataPtr,color_names[2]),
    XtRString,
    "red"},

    {
    XtNLYREhigh_color,
    XtCLYREhigh_color,
    XtRPixel,
    sizeof(Pixel),
    XtOffset(AppDataPtr,high_color),
    XtRString,
    "red"},

    {XtNprange, XtCprange, XtRInt, sizeof (int),
    	XtOffset(AppDataPtr,prange), XtRString, "24"},
    {XtNnrange, XtCnrange, XtRInt, sizeof (int),
    	XtOffset(AppDataPtr,nrange), XtRString, "24"}
};				/*resources*/


    
