/*$header$*/
/*******************************************************
color_lyre.c 		Dave Lion (dave@isdl.ee.washington.edu)

This file is a collection of standalone routines used in the
conversion of auto_lyre from b+w/dithered to pseudocolor format.
Many changes were made to routines in the file Gspec.c, which should
also be looked at; routines which started out there remained there.
Further (or if you idolize the pranksters, furthur) documentation is
in the file ColorLyre.doc.

The RGB handling routines are actually in the file color.c, most
were written by Christopher Kent of DEC.  Unfortunatly, he used
ints for his rgb values, so F_RGB's were added.  Hmm, what else.

The interpolation between colors is in RGB space.  If you really
want HSV (and yes, i have a degree in studio art and
have taken color theory), then substitute the HSV interpolation 
routine in color.c.  Why is it RGB?  I can't remember, but it 
looks fine.  

********************************************************/

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Xatom.h>
/* #include <X11/Xatomtype.h> */

/* Lyre include file directives */
#include <LyreDisp.h>
#include <ScaleP.h>
#include <GspecP.h>
#include <Scale.h>
#include <ToolUtil.h>
#include <color.h>
#include <c.h>
#include <LyreStringDefs.h>
#include <color_lyre.h>


/*
 * Status GetRGBColorsByName(w,base_names,rgbs,num)
 *
 *
 * this routine parses the names in "base_names", into X color
 * format, then gets the closest RGB values of those X colors 
 * from the default colormap, which is a reasonable way to go.
 * In theory, XParseColor deals with Hex representation, but i
 * can't seem to get that to work.
 *
 * the rgb values of these color names are packed into rgbs for
 * use by something else.  something with big pointy teeth.
 *
 * Parameters:	widget, array of names, return array, how many
 * Requires:	names be in default colormap (rgb.txt), rgb allocated
 * Modifies:	packs rgb with values
 * Effects:	xlates text to rgb triples
 * Returns:	success/failure (TRUE/FALSE)
 *
 */

Status GetRGBColorsByName(Widget w, char *base_names[] ,RGB *rgbs, int num)
{
  Colormap dmap = DefaultColormap(XtDisplay(w),DefaultScreen(XtDisplay(w)));
  Display  *dpy = XtDisplay(w);
  int	   counter;
  Status   status;
  XColor   xcolor;

    for (counter =0; counter < num; counter++){
	status = XParseColor(dpy,dmap,base_names[counter],&xcolor);
	if (!status){
	    return(FALSE);
	    }/*endif error*/
		
	rgbs[counter].r = xcolor.red;
	rgbs[counter].g = xcolor.green;
	rgbs[counter].b = xcolor.blue;
	/*if we found it, put it into rgb form*/
	}			

    return (TRUE);
    }/*GetBaseColors*/


/*
 * void GetClosestPixel(w,pixel,xcolor)
 *
 */

void GetClosestPixel(GspecWidget w, Pixel pixel, XColor *xcolor)
{

  XQueryColor(XtDisplay(w),LYRElocal_colormap,xcolor); /* convert to xcolor */

}/*GetClosestPixel*/


/*
 * void DumpColorVectors(w)
 *
 * this routine dumps the pixel and rgb values or the
 * pcolors and ncolors lists of a GspecWidget.
 *
 * Parameters:	widget
 * Requires:	pcolors and ncolors be valid or NULL
 * Modifies:	none
 * Effects:	dumps data to sdout
 * Returns:	none
 *
 */

void DumpColorVectors(GspecWidget w)
{
    
}/*DumpColorVectors*/


/*
 * Status FillNewColormap( w, cmap, rgbs )
 *
 * this routine attempts to allocate colors from a given colormap (the
 * one for the widget) based on the high, zero, and low colors, and
 * positive and negative ranges.
 *
 * it attempts to allocate pos_range evenly spaced shades 
 * (interpolated in RGBspace) between high and zero, and
 * neg_range shades between zero and low range.
 *
 * it puts these shades into vectors pointed to by phandle and
 * nhandle.
 *
 * the reason everything is passed as a parm and not just extracted
 * from the widget was because during program design, it was useful
 * to have a general purpose thingamabobbie like this.
 *
 * Note that if the range of a given display changes, and this routine
 * is called, cells will not be allocated twice for the same values,
 * as the original Pixel value for that rgb triple will be returned.
 *
 * Parameters:	widget (used for colormap), ranges, handles, peak values
 * Requires:	colormap have cells left
 * Modifies:	creates pixel lists and packs them into *handle
 * Effects:	makes color shading lists
 * Returns:	success or failure
 *
 */

Status FillNewColormap(GspecWidget  w, Colormap cmap, RGB *rgbs )
{				
    int		counter;
    XColor	xcolor;
    gs_t *gs = &w->gspec.gs;
    Pixel	*nptr;
    Pixel	*pptr;
    Display	*dpy = XtDisplay(w);
    RGB		rgb;
    Status	status;
	float scale;
	int i;


	/*
	 * Free old colors
	 */

	if( gs->pcolors ) {
		XFreeColors( dpy, cmap, gs->pcolors, gs->poscolors, 0 );
                XtFree((char *) gs->pcolors );
	}

	if( gs->ncolors ) {
		XFreeColors( dpy, cmap, gs->ncolors, gs->negcolors, 0 );
                XtFree((char *) gs->ncolors );
	}

	gs->poscolors = gs->input_poscolors;
	gs->negcolors = gs->input_negcolors;

    /* 
     * allocate space for new 
     */
    pptr = gs->pcolors = (Pixel *)XtCalloc( gs->poscolors, sizeof(Pixel) ); 
    nptr = gs->ncolors = (Pixel *)XtCalloc( gs->negcolors, sizeof(Pixel) );
    
    for (counter = 0; counter < gs->poscolors; counter++) {
	scale = ((float)counter)/ ((float)gs->poscolors);
	scale = (float) pow( (double)scale, (double)(w->gspec.gs.exp) );

	if( scale > 1.0 ) {
	  scale = 1.0;
	}

	MixRGB(&(rgbs[2]), scale ,&(rgbs[1]), 1.0 - scale, &rgb);

	RGBToXColor(&rgb,&xcolor);
	status = XAllocColor(dpy,cmap,&xcolor);

	if( !status ) {
		gs->poscolors = counter;
		gs->input_poscolors = counter;
	    return(FALSE);
        }

	pptr[counter] = xcolor.pixel;

    }

    for(counter = 0; counter < gs->negcolors; counter++){

	scale = ((float)counter)/ ((float)gs->negcolors);
	scale = (float) pow( (double)scale, (double)(w->gspec.gs.exp) );

	if( scale > 1.0 ) {
	  scale = 1.0;
	}

	MixRGB(&(rgbs[0]), scale ,&(rgbs[1]), 1.0 - scale, &rgb);

	RGBToXColor(&rgb,&xcolor);
	status = XAllocColor(dpy,cmap,&xcolor);

	if( !status ) {
		gs->negcolors = counter;
		gs->input_negcolors = counter;
	    return(FALSE);
        }

	nptr[counter] = xcolor.pixel;

    }

    return(TRUE);

}/*FillNewColormap*/


/*
 * void ColorComputeImageX (w, PixPerDatum)
 *
 * Parameters:	widget, how many pixels for each data point
 * Requires:	image space be allocated (w->gspec.image)
 * Modifies:	sets pixels in image space
 * Effects:	creates image based on twiddle factors and shade vectors
 * Returns:	none
 *
 */

void ColorComputeImageX (GspecWidget w, double PixPerDatum)
{
	gs_t *gs = &w->gspec.gs;
	adata_t *adata = w->gspec.data;
	float *data_ptr = adata->ptr;
	XImage *image = w->gspec.image;
	float *rptr;
	float dval;
	Pixel cur;
	int col, row;
	int x, y;
	int rh;
	int *heightvec;
	int cw;
	float pscale;
	float nscale;
	int width;
	int i;

	heightvec = w->gspec.height.data[0];
	x = 0;
	
	pscale = fabs( (gs->posmax - gs->posmin) );
	if (pscale != 0.0)
	  pscale = ( 1.0 / pscale ) * ((float)gs->poscolors);
	else
	  pscale = 0.0;
	
	nscale = fabs( (gs->negmax - gs->negmin) );
	if (nscale!=0.0)
	  nscale = ( 1.0 / nscale ) * ((float)gs->negcolors);
	else
	  nscale = 0.0;

	for( col = 0; col < adata->cols; col++ ) {
		rptr = data_ptr + ( col * adata->rows );
		y = 0;

		if ((col + 1) < adata->cols) {
			if (adata->col_time) {
				width = (adata->col_time[col + 1] * 
							PixPerDatum) - x;
			} else {
				width = ((col + 1) * PixPerDatum) - x;
			}
		}


	      
		for( row = adata->rows - 1; row >= 0; row-- ) {

			dval = *(rptr+row);

			if( dval >= 0 ) {

				if( dval <= gs->posmin ) {
					cur = gs->pcolors[0];
				} else if( dval >= gs->posmax ) {
					cur = gs->pcolors[gs->poscolors - 1];
				} else {

					i = (int)((dval - ((float)gs->posmin))
						* pscale );
					i = abs(i);
					if( i >= gs->poscolors ) {
						i = gs->poscolors - 1;
					}

					cur = gs->pcolors[i];
				}

			} else {

				if( dval <= gs->negmin ) {
					cur = gs->ncolors[gs->negcolors - 1];
				} else if( dval >= gs->negmax ) {
					cur = gs->ncolors[0];
				} else {

					i = (int)((dval - ((float)gs->negmin))
						 * nscale );

					i = abs(i);
					if( i >= gs->negcolors ) {
						i = gs->negcolors - 1;
					}
/*
					i = (gs->negcolors - 1) - i;
*/
					cur = gs->ncolors[i];

				}


			}
		      
			if( heightvec[row] ) {

				for( rh = 0; rh < heightvec[row]; rh++ ) {
					for( cw = 0; cw < width; cw++ ) {
						XPutPixel(image,x+cw,y, cur );
					
					}
					y++;
				}
			}
		}
		x += width;
	}
}


/* 
 * void ComputeColMin (w)
 *
 * compute column min
 *
 */

void ComputeColMin (GspecWidget w)
{
    register c, r;
    register adata_t *adata = w->gspec.data;
    register float *ptr = adata->ptr;
    register float *tptr;
    register int min;
    register int *min_col_data;

    if (adata == 0)
	return;

    if ((adata->ptr == 0) || (adata->count == 0))
	return;

    XtFree ((char *) w->gspec.min_col_data);
    w->gspec.min_col_data =
	(int *) XtCalloc (w->gspec.data->cols, sizeof (int));

    min_col_data = w->gspec.min_col_data;

    for (c = 0; c < adata->cols; c++) {
	tptr = ptr + (c * adata->rows);
  	min = (int) *tptr;
	for (r = 0; r < adata->rows; r++, tptr++) {
	    if ( ((int) *tptr) < min)
		min = (int) *tptr;
	}
	*min_col_data++ = min;
    }
}


/*
 * int GlobalMin (w)
 *
 */

int GlobalMin (GspecWidget w)
{
    register int start_col;
    register int end_col;
    register int *ptr;
    register int min;
    register int col;


    start_col = 0;
    end_col = w->gspec.data->cols;

    ptr = w->gspec.min_col_data + start_col;

    min = *ptr;
    for (col = start_col; col < end_col; col++, ptr++) {
	if (min > *ptr)
	    min = *ptr;
    }

    return (min);
}


/*
 * int LocalMin (w, col)
 *
 */

int LocalMin (GspecWidget w, register int col)
{
    register int start_col;
    register int end_col;
    register int *ptr;
    register int min;

    start_col = 0;
    end_col = w->gspec.data->cols;

    ptr = w->gspec.min_col_data + start_col;
    min = *ptr++;

    for (col = start_col + 1; col < end_col; col++, ptr++) {
	if (min > *ptr)
	    min = *ptr;
    }

    return (min);
}


/*
 * Status LYREinstall_colormap(w,appdata)
 *
 * see if we're on a color screen.  see if it's read/write colormapable.
 * if it is, shout hooray, get a colormap, and make it the colormap of
 * the passed widget (which is prob the parent so everyone else inherits
 * it).  Set some UGLY global variables.  Yes, i feel guilty for this.
 *
 * Parameters:	widget, application data (holds the colors + ranges)
 * Requires:	none (will handle disappointment)
 * Modifies:	allocates a colormap
 * Effects:	tries to get a private colormap
 * Returns:	success/failure
 *
 */

Status LYREinstall_colormap(Widget w, AppData *appdata)
{
/**/Visual		*this_visual;
    Status	status;
    XVisualInfo	*tmp_visinfo;
    int		num_items;
    Display	*this_display;
    Screen	*this_screen;
    XVisualInfo	vinfo_template;
    int		screen_number;
    int		i;
    Arg		args[10];



    this_display = XtDisplay(w);
    this_screen = XtScreen(w);
    screen_number = DefaultScreen(this_display);
    this_visual = DefaultVisual(this_display,screen_number);
    vinfo_template.visualid = this_visual->visualid;
    this_visual = DefaultVisual(this_display,screen_number);

    tmp_visinfo = XGetVisualInfo(this_display,VisualIDMask,
				 &vinfo_template,&num_items);
    if (num_items != 1){
	}/*enidif # != 1*/
    switch (tmp_visinfo[0].class){
    case	PseudoColor:
	LYREpseudo_color_flag = TRUE;
	LYREcolormap_size = tmp_visinfo[0].colormap_size;
	break;
    case	StaticColor:
	break;
    case	DirectColor:
	break;
    case TrueColor:
	break;
    case GrayScale:
	break;
    case StaticGray:
	break;
    default:
	break;
	}/*switch*/

    
    if (appdata->prange + appdata->nrange > LYREcolormap_size){
	return(FALSE);
	}/*endif*/
	    
    if (LYREpseudo_color_flag){
#if 0
      LYRElocal_colormap = XCreateColormap(this_display,
					   RootWindowOfScreen(this_screen),
					   this_visual,AllocNone);
#endif
	LYRElocal_colormap = DefaultColormap(this_display,screen_number);
	i=0;
	XtSetArg(args[i],XtNcolormap,LYRElocal_colormap);i++;
	XtSetValues(w,args,i);	/* do colormap first */


	LYRErgbs = (RGB*)XtCalloc(3, sizeof(RGB)); /* clear it out to start */
	status = GetRGBColorsByName(w,appdata->color_names,LYRErgbs,3);
	if (!status){
	    return(FALSE);
	    }/*endif*/
	
	
	LYREbest_colormap_installed = TRUE;
	}/*endif it's a pseudocolor*/

    if (!LYREbest_colormap_installed)
	LYRElocal_colormap = DefaultColormap(this_display,screen_number);

	return( TRUE );

}


/*
 * Status SetDisplayColors(w,target)
 *
 * this routine sets the foreground and background pixels grabbed
 * from the resource manager into the local colormap.
 *
 * Parameters:	widget (hopefully toplevel so all will inherit), 
 *		pointer to resource data
 * Requires:	resource data be set, local colormap be set, spaces be left in it
 * Modifies:	sets two values in LYRElocal_colormap
 * Effects:	sets up the foreground and background pixels of the widget
 * Returns:	success/failure 
 *
 */

Status SetDisplayColors(Widget w, AppData *target)
{
    XColor	xcolor;
    RGB		rgb;
    Arg		args[2];
    int		i= 0;
    Status	status;

    GetRGBColorsByName(w,&(target->fg_text),&rgb,1);
    RGBToXColor(&rgb,&xcolor);
    status = XAllocColor(XtDisplay(w),LYRElocal_colormap,&xcolor);
    if (!status){
	return(FALSE);
	}/*endif*/
    XtSetArg (args[i], XtNforeground, xcolor.pixel);i++;

    GetRGBColorsByName(w,&(target->bg_text),&rgb,1);
    RGBToXColor(&rgb,&xcolor);
    status = XAllocColor(XtDisplay(w),LYRElocal_colormap,&xcolor);
    if (!status){
	return(FALSE);
	}/*endif*/
    XtSetArg (args[i], XtNbackground, xcolor.pixel);i++;
    XtSetValues(w,args,i);

    return (TRUE);
    }/*SetDisplayColors*/
    

/*
 * void LYREdump_resource_values(target)
 *
 */

void LYREdump_resource_values(AppData *target)
{
    
    printf("fg color is %s\n",target->fg_text);
    printf("bg color is %s\n",target->bg_text);
    printf("low color is %s\n",target->color_names[0]);
    printf("zero color is %s\n",target->color_names[1]);
    printf("high color is %s\n",target->color_names[2]);
    printf("aux_value is %d\n",LYREaux_value);
    }/*LYREdump_resource_values*/


/*
 * void SumHeightVectors(w)
 *
 */

void SumHeightVectors(GspecWidget w)
{
    height_t           *height = &w->gspec.height;
    register int       *data;
    register int        i, c;
    int                *datap;
    int                 rows = w->gspec.data->rows;
    int                 pix_height = w->core.height;
    register float      base_coeff_pix_height = (float) pix_height / rows;
    int	sum;

	
	/*
	 * Check for a row count first 
	 */
	
	for (i = 0; i < height->cnt; i++) {
	    data = height->data[i] = datap + (rows * i);
	    sum = 0;
	    for (c = 0; c < rows; c++, data++) 
		sum += *data;
	    printf("height vec #%d, sum = %d\n",i,sum);
	    }/*for i*/
  }/*SumHeightVectors*/
