/* $Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/color.h,v 4.1 1993/05/07 18:22:06 johans Exp $ */

/* 
 * color.h - color definitions
 * 
 * Author:	Christopher A. Kent
 * 		Western Research Laboratory
 * 		Digital Equipment Corporation
 * Date:	Sun Dec 13 1987
 * Copyright (c) 1987 Christopher A. Kent
 */

/*
 * $Log: color.h,v $
 * Revision 4.1  1993/05/07  18:22:06  johans
 * Updated to ANSI C format
 *
 * Revision 4.1  1993/05/07  18:22:06  johans
 * Updated to ANSI C format
 *
 * Revision 4.0  1992/05/22  09:15:08  pochmara
 * Version Stamp
 *
 * Revision 3.0  92/02/18  15:39:06  pochmara
 * start of new version for work on lyre
 * 
 * Revision 1.3  92/02/18  15:29:58  pochmara
 * last version of auto_lyre/lyre to use SYNC struct
 * 
 * Revision 1.2  91/01/12  17:51:44  fanty
 * new declarations
 * 
 * Revision 1.1  91/01/11  17:36:41  fanty
 * Initial revision
 * 
 * Revision 1.1  90/06/16  16:01:49  fanty
 * Initial revision
 * 
 * Revision 1.1  90/06/05  14:37:17  dave
 * Initial revision
 * 
 * Revision 1.2  88/06/30  09:58:56  mikey
 * Handles CMY also.
 * 
 * Revision 1.1  88/06/30  09:10:53  mikey
 * Initial revision
 * 
 */

typedef	struct _RGB {
	unsigned short r, g, b;
} RGB;

typedef	struct _f_RGB {
	double r, g, b;
} F_RGB;

typedef	struct _HSV {
	float	h, s, v;	/* [0, 1] */
} HSV;

typedef struct _CMY {
	unsigned short c, m, y;
} CMY;

extern RGB	RGBWhite, RGBBlack;

void MixRGB(RGB *r, float alpha, RGB*s, float beta, RGB *t);
void RGBToXColor (RGB *r, XColor *x);
void XColorToRGB (XColor *x, RGB *r);

