/* ADATA.H - array data object
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * DESCRIPTION
 *	Data is arranged in column major order.
 *------------------------------------------------------------*
 * HISTORY
 *  4-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added col_time field.
 *
 */

#ifndef _ADATA_H_
#define _ADATA_H_

#include <sys/types.h>

typedef struct _adata {
    u_int		bsize;		/* Size of a datum in bytes*/
    u_int		count;		/* Number of datums == row * col */
    u_int		cols;		/* Number of columns */
    u_int		rows;		/* Number of rows */
    u_int		ns_per_col;	/* Nano-seconds per col */
    int			*col_time;	/* When the columns are asynchronos
					 * (ie. not uniformly spaced in time)
					 * then col_time  contains the
					 * the cooresponding time for each
					 * column and ns_per_col is the
					 * units for these times. Otherwise
					 * col_time is NULL.
					 */
    float		pos_min_val; 	/* minimum data value */
    float		pos_max_val; 	/* minimum data value */
    float		neg_min_val; 	/* minimum data value */
    float		neg_max_val; 	/* minimum data value */
    float *ptr;				/* Pointer to the data */
} adata_t;

#endif _ADATA_H_
