static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/XtAlert.c,v 4.1 1993/05/07 18:17:20 johans Exp $";

/* Standard C library include file directives */
#include <c.h>
#include <stdio.h>

/* X toolkit standard library include file directives */
#include <X11/Xlib.h>
#include <X11/Xmu/Misc.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Shell.h>

#include <varargs.h>

static    Widget  PopupShell = 0;
static    Widget  Form       = 0;
static    Widget  MessageW   = 0;
static    Widget  OkW        = 0;

#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}


/*
 * XtAlertInit (w)
 *
 */

XtAlertInit (Widget w)
{
    Arg             args[10];
    int             arg_cnt;
    XtPopdownIDRec  *pdid = (XtPopdownIDRec *)
      XtMalloc (sizeof (XtPopdownIDRec));

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNallowShellResize, TRUE);
    MyXtSetArg (args, arg_cnt, XtNgeometry, "400x100+200+150");  /* ???? */
    PopupShell = XtCreatePopupShell ("Alert", transientShellWidgetClass,
				     w, args, arg_cnt);

    arg_cnt = 0;
    Form = XtCreateManagedWidget ("form", formWidgetClass, PopupShell,
				   args, arg_cnt);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
    MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNlabel, "No Message");

    MyXtSetArg (args, arg_cnt, XtNfont,
	 XLoadQueryFont(XtDisplay(w),
	"-adobe-times-medium-r-normal--2*"));
#if 0
    MyXtSetArg (args, arg_cnt, XtNfont,
	 XLoadQueryFont(XtDisplay(w),
	"9x15"));
#endif
    MessageW = XtCreateManagedWidget ("ErrorMessage", labelWidgetClass, Form,
				args, arg_cnt);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNfromVert, MessageW);

    MyXtSetArg (args, arg_cnt, XtNfont,
	XLoadQueryFont(XtDisplay(w), 
	"-adobe-times-bold-r-normal--1*"));
#if 0
    MyXtSetArg (args, arg_cnt, XtNfont,
	XLoadQueryFont(XtDisplay(w), 
	"9x15"));
#endif
    MyXtSetArg (args, arg_cnt, XtNlabel, "OK");
    OkW = XtCreateManagedWidget ("button", commandWidgetClass, Form,
				args, arg_cnt);

    pdid->shell_widget = PopupShell;
    pdid->enable_widget = NULL;
    XtAddCallback (OkW, XtNcallback, XtCallbackPopdown, pdid);
}


/*
 * XtAlert (va_alist)
 * 
 * Alert error message popup window
 *
 */

XtAlert( va_alist )
va_dcl
{
  va_list ap;
  char    *fmt;
  Arg     args[10];
  int     arg_cnt;
  char    str[1024];

  va_start(ap);
  
  fmt = va_arg(ap, char *);

  vsprintf( str, fmt, ap );

  va_end(ap);
  
  if (PopupShell == 0) {
    printf ("XtAlert: %s\n", str);
  }

  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNlabel, str);
  XtSetValues (MessageW, args, arg_cnt);
  
  XtPopup (PopupShell, XtGrabExclusive);
}

