static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Tsd.c,v 4.3 1993/05/27 22:48:30 johans Exp $";

/*
 * Tsd.c - Line Graph Widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 * 21-Jun-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added play_data().
 *
 * 19-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added code to initialize tsd.segments and tsd.nsegments
 *	fields.
 *
 *  3-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	- Added code to handle fewer than one sample per pixel.
 *	- Modified COMPUTESEGMENTS to less floating pt. arithmetic
 * 
 *  16-Apr-93 Johan Schalkwyk at Oregon Graduate Institute
 *      changed to ANSI type headers
 *
 */

/* Standard C library include file directives */
#include <fcntl.h>
#include <stdio.h>

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>

/* Lyre include file directives */
#include <TsdP.h>
#include <Scale.h>
#include <ToolUtil.h>
#include <c.h>
#include <ad.h>


/* Private Definitions */


#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}

/* Initialization of defaults */

#define OFFSET(field) XtOffset(TsdWidget,tsd.field)
#define GOFFSET(field) XtOffset(Widget,core.field)

static int Zero = 0;

static XtResource resources[] = {
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
        OFFSET(foreground_pixel), XtRString, "Black"},
    {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
	GOFFSET(width), XtRString, "10"},
    {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
	GOFFSET(height), XtRString, "0"},
    {XtNreverseVideo, XtCReverseVideo, XtRBoolean, sizeof (Boolean),
	OFFSET (reverse_video), XtRString, "FALSE"},
    {XtNdata, XtNdata, XtRPointer, sizeof(caddr_t),
	OFFSET (input_data), XtRPointer, NULL},
    {XtNhscaleWidget, XtCParameter, XtRPointer, sizeof(caddr_t),
	OFFSET (hscale_widget), XtRPointer, NULL},
    {XtNvscaleWidget, XtCParameter, XtRPointer, sizeof(caddr_t),
	OFFSET (vscale_widget), XtRPointer, NULL},
    {XtNthreshold, XtCParameter, XtRInt, sizeof(caddr_t),
	OFFSET (threshold), XtRString, 0},
};

#undef OFFSET
#undef GOFFSET

/* private procedure declarations */
static void Initialize (Widget request, Widget new);
static void Realize (TsdWidget w, XtValueMask *valueMask, 
		     XSetWindowAttributes *attrs);
static void Destroy (TsdWidget w);
static void Resize (Widget gw);
static void Redisplay (TsdWidget w, XExposeEvent *event, Region region);
static void ComputeSegments (register TsdWidget w);
static void ComputeSegments1 (vdata_t *vdata, register XSegment *segments,  
			      u_int nsegments, register int offset, 
			      register int width, register int threshold, 
			      double DatumPerPix);
static void ComputeSegments2 (vdata_t *vdata, register XSegment *segments,  
			      u_int nsegments, register int offset, 
			      register int width, register int threshold, 
			      double DatumPerPix);
static void ComputeSegments4 (vdata_t *vdata, register XSegment *segments,  
			      u_int nsegments, register int offset, 
			      register int width, register int threshold, 
			      double DatumPerPix);

static void data_amp (u_int cnt, caddr_t ptr, u_int size, 
		      int *max_amp, int *min_amp);
static void data_amp1 (register u_int cnt, register char *ptr, 
		       register u_int size, int *max_amp, int *min_amp);
static void data_amp2 (register u_int cnt, register short *ptr, 
		       register u_int size, int *max_amp, int *min_amp);
static void data_amp4 (register u_int cnt, register int *ptr, 
		       register u_int size, int *max_amp, int *min_amp);

static Boolean SetValues (Widget gcurrent, Widget grequest, Widget gnew);


static char defaultTranslations[] = "\
<Enter>:       TrackMouse(e) \n\
<Leave>:       TrackMouse(l) \n\
<Motion>:      TrackMouse(m) \n\
";

static XtActionsRec actions[] = {
	{"TrackMouse",		LyreDispTrackMouse},
};


TsdClassRec tsdClassRec = {
    { /* core fields */
    /* superclass		*/	(WidgetClass) &lyreDispClassRec,
    /* class_name		*/	"Tsd",
    /* widget_size		*/	sizeof(TsdRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* resource_count		*/	XtNumber(resources),
    /* xrm_class		*/	NULL,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	(TRUE | XtExposeGraphicsExpose),
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry           */	NULL,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,	
    /* extension		*/	NULL,
    }
};

WidgetClass tsdWidgetClass = (WidgetClass) &tsdClassRec;


/*
 * static void Initialize (request, new)
 *
 */

static void Initialize (Widget request, Widget new)
{
    TsdWidget w = (TsdWidget) new;
    XtGCMask valuemask;
    XGCValues myXGCV;

    if (w->tsd.reverse_video) {
	Pixel fg = w->tsd.foreground_pixel;
	Pixel bg = w->core.background_pixel;

	if (w->core.border_pixel == fg)
	    w->core.border_pixel = bg;
	w->tsd.foreground_pixel = bg;
	w->core.background_pixel = fg;
    }

    valuemask = GCForeground | GCBackground | GCLineWidth |
		GCGraphicsExposures;
    myXGCV.foreground = w->tsd.foreground_pixel;
    myXGCV.background = w->core.background_pixel;
    myXGCV.line_width = 0;
    myXGCV.graphics_exposures = TRUE;	/* default */
    w->tsd.myGC = XtGetGC ((Widget) w, valuemask, &myXGCV);

    w->tsd.data = w->tsd.input_data;
    w->tsd.width = 10;
    w->tsd.input_data = 0;
    w->tsd.nsegments = 0;
    w->tsd.segments = NULL;
    SetScale ((LyreDispWidget)w->tsd.hscale_widget, w->lyreDisp.secs_ppix);
}


/*
 * static void Realize (w, valueMask, attrs)
 *
 */

static void Realize (TsdWidget w, XtValueMask *valueMask, 
		     XSetWindowAttributes *attrs)
{
    XtCreateWindow (w, InputOutput, (Visual *) CopyFromParent,
		    *valueMask, attrs);
    Resize (w);
}


/*
 *  static void Destroy (w)
 *
 */

static void Destroy (TsdWidget w)
{
  XtDestroyGC (w->tsd.myGC);
  XtFree (w->tsd.segments);
}


/* 
 * static void Resize (gw)
 *
 */

static void Resize (Widget gw)
{
    TsdWidget w = (TsdWidget) gw;

    /*
     * don't do this computation if window hasn't been realized yet.
     */
    if (XtIsRealized (w)) {
	ComputeSegments (w);
    }
}


/*
 * static void Redisplay (w, event, region)
 *
 */

static void Redisplay (TsdWidget w, XExposeEvent *event, Region region)
{
    register XSegment  *xseg;
    register int        wx;
    register int        EndX;
    register int        StartX;
    register int        Width;
    register int        seg_index;
    register XSegment  *seg;

    if (w->tsd.nsegments && w->tsd.segments) {
	/*
	 * Draw the waveform 
	 */
	StartX = event->x;
	Width = event->width;
	seg_index = StartX + w->lyreDisp.virtual_x;

	if (seg_index < 0) {
	    Width -= (-seg_index);
	    StartX += (-seg_index);
	    seg_index = 0;
	}
	if ((seg_index + Width) > w->tsd.nsegments)
	    Width = w->tsd.nsegments - seg_index;
	if ((seg_index > w->tsd.nsegments) || (Width <= 0))
	    return;

	seg = xseg = &w->tsd.segments[seg_index];
	EndX = Width + StartX;
	for (wx = StartX; wx < EndX; wx++, xseg++) {
	    xseg->x1 = xseg->x2 = wx;
	}

	XDrawSegments (XtDisplay (w), XtWindow (w), w->tsd.myGC,
		       seg, Width);
    }
}


/*
 * static Boolean SetValues (gcurrent, grequest, gnew)
 *
 */

static Boolean SetValues (Widget gcurrent, Widget grequest, Widget gnew)
{
    TsdWidget        current = (TsdWidget) gcurrent;
    TsdWidget        new = (TsdWidget) gnew;
    TsdWidget        req = (TsdWidget) grequest;
    Boolean             redisplay = FALSE;
    Boolean             recompute = FALSE;
    XtGCMask            valuemask;
    XGCValues           myXGCV;

    if ((new->tsd.foreground_pixel != current->tsd.foreground_pixel)
	|| (new->core.background_pixel != current->core.background_pixel)) {
	valuemask = GCForeground | GCBackground | GCFont | GCLineWidth;
	myXGCV.foreground = new->tsd.foreground_pixel;
	myXGCV.background = new->core.background_pixel;
	myXGCV.line_width = 0;
	XtDestroyGC (current->tsd.myGC);
	new->tsd.myGC = XtGetGC (gcurrent, valuemask, &myXGCV);
	redisplay = TRUE;
    }

    if (new->core.background_pixel != current->core.background_pixel) {
	valuemask = GCForeground | GCLineWidth;
	myXGCV.foreground = new->core.background_pixel;
	myXGCV.line_width = 0;
	redisplay = TRUE;
    }

    if (new->tsd.input_data) {
	new->tsd.data = new->tsd.input_data;
	new->tsd.input_data = 0;
	recompute = TRUE;
    }

    if (new->lyreDisp.secs_ppix != current->lyreDisp.secs_ppix) {
      SetScale ((LyreDispWidget)new->tsd.hscale_widget, 
		new->lyreDisp.secs_ppix);
      recompute = TRUE;
    }

    recompute |= (new->tsd.threshold != current->tsd.threshold);

    if (recompute) {
	ComputeSegments (new);
	new->lyreDisp.virtual_width = new->tsd.nsegments;
	redisplay = TRUE;
    }

    if (current->lyreDisp.virtual_width != new->lyreDisp.virtual_width)
	XtCallCallbacks (new, XtNwidthProc, new->lyreDisp.virtual_width);

    return (redisplay);
}


/*
 * static void ComputeSegments (w)
 *
 */

static void ComputeSegments (register TsdWidget w)
{
    double      DatumPerPix;
    register vdata_t   *vdata = w->tsd.data;
    int                 max, min;
    register float      scale;
    register int        offset;

    if (vdata == 0)
	return;

    XtFree (w->tsd.segments);
    w->tsd.segments = 0;
    w->tsd.nsegments = 0;

    DatumPerPix = 1000000000.0 * w->lyreDisp.secs_ppix / vdata->ns_per_datum;

    if ((vdata->ptr == 0) || (vdata->count == 0))
	return;

    {
	int                 range;
	Arg                 args[20];
	int                 arg_cnt;

	data_amp (vdata->count, vdata->ptr, vdata->bsize, &max, &min);
	range = max - min;
	if (range == 0)
	    range = 1;
	if (w->tsd.vscale_widget) {
	    union {
		float f;
		unsigned int i;
	    }                   unit_per_pix;

	    unit_per_pix.f = (float) range / w->core.height;

	    arg_cnt = 0;
	    MyXtSetArg (args, arg_cnt, XtNunitPerPix, unit_per_pix.i);
	    MyXtSetArg (args, arg_cnt, XtNzeroPixOffset,
			(int) (max / unit_per_pix.f));
	    printf("XtNzeroPixOffset 2: %d\n", (int) (max / unit_per_pix.f));
	    XtSetValues (w->tsd.vscale_widget, args, arg_cnt);
	}
	scale = (float) (w->core.height - w->lyreDisp.top_padding -
			 w->lyreDisp.bottom_padding) / range;
    }

    offset = (max * scale) + w->lyreDisp.top_padding;

    w->tsd.nsegments = (vdata->count / DatumPerPix) - 1;
    w->tsd.segments = (XSegment *) XtMalloc (w->tsd.nsegments *
						sizeof (XSegment));

    switch (vdata->bsize) {
    case 1:
	ComputeSegments1 (vdata, w->tsd.segments, w->tsd.nsegments,
			  w->core.height - w->lyreDisp.bottom_padding,
			  w->core.height -  (w->lyreDisp.top_padding + 
					     w->lyreDisp.bottom_padding),
			  w->tsd.threshold, DatumPerPix);
	break;
    case 2:
	ComputeSegments2 (vdata, w->tsd.segments, w->tsd.nsegments,
			  w->core.height - w->lyreDisp.bottom_padding,
			  w->core.height - (w->lyreDisp.top_padding + 
					    w->lyreDisp.bottom_padding),
			  w->tsd.threshold, DatumPerPix);
	break;
    case 4:
	ComputeSegments4 (vdata, w->tsd.segments, w->tsd.nsegments,
			  w->core.height - w->lyreDisp.bottom_padding,
			  w->core.height - (w->lyreDisp.top_padding + 
					    w->lyreDisp.bottom_padding),
			  w->tsd.threshold, DatumPerPix);
	break;
    }
}


#define COMPUTESEGMENTS(name,type,vdata,segments,nsegments,offset,width,threshold,DatumPerPix) \
static void name (vdata_t *vdata, register XSegment *segments,              \
		  u_int nsegments, register int offset, register int width, \
		  register int threshold, double DatumPerPix)              \
{									\
    double samp;							\
    register type *eptr;						\
    register type *ptr = (type *) vdata->ptr;				\
    register type *tptr;						\
    register int min, max;						\
    register u_int xpix;						\
									\
    for (samp = 0.0, xpix = 0; xpix < nsegments; samp += DatumPerPix, xpix++) { \
	tptr = ptr + (int) samp;					\
	eptr = ptr + (int) (samp + DatumPerPix);			\
 									\
	min = max = *tptr;						\
	for (; tptr <= eptr; tptr++) {					\
	    if (*tptr > max)						\
		max = *tptr;						\
	    else if (*tptr < min)					\
		min = *tptr;						\
	}								\
        if (max >= threshold) {						\
	    segments->x1 = xpix;					\
	    segments->y1 = offset; 					\
	    segments->x2 = xpix;					\
	    segments->y2 = offset - width;				\
	}								\
	else {								\
	    segments->x1 = xpix;					\
	    segments->y1 = offset; 					\
	    segments->x2 = xpix;					\
	    segments->y2 = offset;					\
	}								\
	segments++;							\
    }									\
} 

COMPUTESEGMENTS(ComputeSegments1, char, vdata, segments, nsegments,
		offset, width, threshold, DatumPerPix)

COMPUTESEGMENTS(ComputeSegments2, short, vdata, segments, nsegments,
		offset, width, threshold, DatumPerPix)

COMPUTESEGMENTS(ComputeSegments4, int, vdata, segments, nsegments,
		offset, width, threshold, DatumPerPix)

#undef COMPUTESEGMENTS


/*
 * static void data_amp (cnt, ptr, size, max_amp, min_amp)
 *
 */

static void data_amp (u_int cnt, caddr_t ptr, u_int size, 
		      int *max_amp, int *min_amp)
{
    switch (size) {
    case 1:
	data_amp1(cnt, ptr, size, max_amp, min_amp);
	break;
    case 2:
	data_amp2(cnt, ptr, size, max_amp, min_amp);
	break;
    case 4:
	data_amp4(cnt, ptr, size, max_amp, min_amp);
	break;
    }
}


/*
 * static void data_amp1 (cnt, ptr, size, max_amp, min_amp)
 *
 */

static void data_amp1 (register u_int cnt, register char *ptr, 
		       register u_int size, int *max_amp, int *min_amp)
{
    register int max, min;
    register char *eptr;

    for (min = max = *ptr, eptr = ptr + cnt; ptr < eptr; ptr++) {
	if (*ptr > max)
	    max = *ptr;
	else if (*ptr < min)
	    min = *ptr;
    }
    *min_amp = min;
    *max_amp = max;
}


/*
 * static void data_amp2 (cnt, ptr, size, max_amp, min_amp)
 *
 */

static void data_amp2 (register u_int cnt, register short *ptr, 
		       register u_int size, int *max_amp, int *min_amp)
{
    register int max, min;
    register short *eptr;

    for (min = max = *ptr, eptr = ptr + cnt; ptr < eptr; ptr++) {
	if (*ptr > max)
	    max = *ptr;
	else if (*ptr < min)
	    min = *ptr;
    }
    *min_amp = min;
    *max_amp = max;
}


/*
 * static void data_amp4 (cnt, ptr, size, max_amp, min_amp)
 *
 */

static void data_amp4 (register u_int cnt, register int *ptr, 
		       register u_int size, int *max_amp, int *min_amp)
{
    register int max, min;
    register int *eptr;

    for (min = max = *ptr, eptr = ptr + cnt; ptr < eptr; ptr++) {
	if (*ptr > max)
	    max = *ptr;
	else if (*ptr < min)
	    min = *ptr;
    }
    *min_amp = min;
    *max_amp = max;
}

