static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Scale.c,v 4.5 1993/05/28 21:27:40 johans Exp $";

/*
 * Scale.c - Scale widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 *  3-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added an initialization for the unit_per_tm field in ScalePart.
 *
 * 16-Apr-93 Johan Schalkwyk at Oregon Graduate Institute
 *     changed to ANSI style declarations
 *
 */

/* Standard C library include file directives */
#include <c.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Xmu/Misc.h>

/* Lyre include file directives */
#include <ScaleP.h>
#include <LyreStringDefs.h>


/* RESCOURCES
 */
static int Zero = 0;
static Boolean defTRUE = TRUE;

#define offset(field) XtOffset(ScaleWidget, scale.field)
#define Coffset(field) XtOffset(ScaleWidget, core.field)

static XtResource resources[] = { 
   {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(foreground_pixel), XtRString, "Black"},
   {XtNfont, XtCFont, XtRFont, sizeof(Font),
	offset (font), XtRString, "Fixed"},

   {XtNhorizontal, XtCBoolean, XtRBoolean, sizeof(Boolean), 
      offset(horizontal), XtRBoolean, (caddr_t)&defTRUE},
   {XtNscaleBottom, XtCBoolean, XtRBoolean, sizeof(Boolean), 
      offset(scale_bottom), XtRBoolean, (caddr_t)&defTRUE},
   {XtNscaleLeft, XtCBoolean, XtRBoolean, sizeof(Boolean), 
      offset(scale_left), XtRBoolean, (caddr_t)&defTRUE},
   {XtNshowExtent, XtCBoolean, XtRBoolean, sizeof(Boolean), 
      offset(show_extent), XtRBoolean, (caddr_t)&defTRUE},
   {XtNcountUp, XtCBoolean, XtRBoolean, sizeof(Boolean), 
      offset(count_up), XtRBoolean, (caddr_t)&defTRUE},

   {XtNunitsLabel, XtNunitsLabel, XtRString, sizeof(char *),
	offset (units_label), XtRString, ""},
   {XtNfpDigits, XtNfpDigits, XtRInt, sizeof(int),
	offset (fp_digits), XtRString, "0"},
   {XtNunitPerPix, XtNunitPerPix, XtRFloat, sizeof(float),
	offset (unit_per_pix), XtRString, "1.0"},
   {XtNunitPerTm, XtNunitPerTm, XtRFloat, sizeof(float),
	offset (unit_per_tm), XtRString, "1.0"},
   {XtNpixPerTm, XtNpixPerTm, XtRFloat, sizeof(float),
	offset (pix_per_tm), XtRString, "10.0"},
   {XtNtmPerMtm, XtNtmPerMtm, XtRInt, sizeof(int),
	offset (tm_per_mtm), XtRString, "10"},
   {XtNmtmPerLabel, XtNmtmPerLabel, XtRInt, sizeof(int),
	offset (mtm_per_label), XtRString, "1"},

   {XtNminorTmLength, XtNminorTmLength, XtRInt, sizeof(int),
	offset (minor_tm_length), XtRString, "3"},
   {XtNmajorTmLength, XtNmajorTmLength, XtRInt, sizeof(int),
	offset (major_tm_length), XtRString, "10"},
   {XtNmaxPixPerTm, XtNmaxPixPerTm, XtRInt, sizeof(int),
	offset (max_pix_per_tm), XtRString, "40"},
   {XtNminPixPerTm, XtNminPixPerTm, XtRInt, sizeof(int),
	offset (min_pix_per_tm), XtRString, "4"},

   {XtNzeroPixOffset, XtNzeroPixOffset, XtRInt, sizeof(int),
	offset (zero_pix_offset), XtRString, "0"},
   {XtNvirtualY, XtNvirtualY, XtRPointer, sizeof(caddr_t),
	offset (virtual_y), XtRPointer, (caddr_t) NULL},

};
#undef offset

/* private procedure header declarations */
static void Initialize (Widget request, Widget new, ArgList arglist,
			Cardinal *num_args);
static void Realize (Widget w_in, XtValueMask *valueMask, 
		     XSetWindowAttributes *attrs);
static void Resize (Widget gw);
static void Destroy (Widget gw);
static void Redisplay (Widget w_in, XEvent *expose_in, 
		       Region region);
static Boolean SetValues (Widget current_in, Widget request_in, Widget new_in,
			  ArgList arglist, Cardinal *num_args);
static void AdjustScale (register ScaleWidget w);
static void AdjustGeometry (register ScaleWidget w);


ScaleClassRec scaleClassRec = {
  {
    (WidgetClass) &lyreDispClassRec,	/* superclass		  */	
    "Scale",				/* class_name		  */
    sizeof(ScaleRec),			/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    (TRUE | XtExposeGraphicsExpose),	/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    Resize,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL,				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    0,		                 	/* unused */
  },  /* ScaleClass fields initialization */
};

WidgetClass scaleWidgetClass = (WidgetClass) &scaleClassRec;

/*
 * Private Procedures
 */


/*
 * Initialize (request, new)
 *
 */

static void Initialize (Widget request, Widget new, ArgList arglist,
			Cardinal *num_args)
{
    ScaleWidget      w = (ScaleWidget) new;
    XtGCMask            valuemask;
    XGCValues           myXGCV;
    XFontStruct		*FontInfo;

#ifdef debuglyre
    printf("%d %f %f %f %d %d %d %d %d %d\n",
	   w->scale.fp_digits, w->scale.unit_per_pix,
	   w->scale.unit_per_tm, w->scale.pix_per_tm, 
	   w->scale.tm_per_mtm, w->scale.mtm_per_label,
	   w->scale.minor_tm_length, w->scale.major_tm_length,
	   w->scale.max_pix_per_tm, w->scale.min_pix_per_tm,
	   w->scale.zero_pix_offset);
    w->scale.unit_per_pix = 1.0;
    w->scale.unit_per_tm  = 1.0;
    w->scale.pix_per_tm   = 10.0;
#endif

    valuemask = GCForeground | GCBackground | GCLineWidth | GCFont;

    myXGCV.foreground = w->scale.foreground_pixel;
    myXGCV.background = w->core.background_pixel;
    myXGCV.line_width = 0;
    myXGCV.font = w->scale.font;
    w->scale.scaleGC = XtGetGC ((Widget) w, valuemask, &myXGCV);

    FontInfo = XQueryFont (XtDisplay(w), w->scale.font);
    w->scale.ascent = FontInfo->ascent;
    w->scale.descent = FontInfo->descent;
    /*
     * The * 2 is a hack till figure out what is causing us to get a bad
     * width
     */
    w->scale.font_width = 2 * (FontInfo->max_bounds.rbearing -
			  FontInfo->max_bounds.lbearing);

    w->scale.font_info = FontInfo;

    
    w->scale.unit_per_tm = w->scale.unit_per_pix * w->scale.pix_per_tm;
    sprintf (w->scale.ctl_string, "%%.%df%s", w->scale.fp_digits,
	     w->scale.units_label);

    AdjustScale (w);
    AdjustGeometry (w);
}


/*
 * Realize (w, valueMask, attrs)
 *
 */

static void Realize (Widget w_in, XtValueMask *valueMask, 
		     XSetWindowAttributes *attrs)
{
    ScaleWidget w  = (ScaleWidget) w_in;
    XtCreateWindow ((Widget) w, InputOutput, (Visual *) CopyFromParent,
		    *(valueMask), attrs);
    Resize( (Widget)w );
}


/*
 * Resize (gw)
 *
 */

static void Resize (Widget gw)
{
    ScaleWidget         w = (ScaleWidget) gw;

    /* don't do this computation if window hasn't been realized yet. */
    if (XtIsRealized ((Widget) w)) {
    }
}


/*
 * Destroy (gw)
 *
 */

static void Destroy (Widget gw)
{
     ScaleWidget w = (ScaleWidget) gw;
     XtFree ((char *) w->scale.font_info);
     XtDestroyGC (w->scale.scaleGC);
}


/*
 * Redisplay (w, expose, region)
 *
 */

static void Redisplay (Widget w_in, XEvent *expose_in, Region region)
{
    ScaleWidget  w = (ScaleWidget) w_in;
    XExposeEvent *expose = (XExposeEvent *) expose_in;
    register int End;
    register int tm, x, y;
    int virt_x = 0, virt_y = 0;
    int label_y;
    int label_x;
    int tm_start;
    int tm_end;
    int mtm_start;
    int mtm_end;
    int	tm_zero_pix = w->scale.zero_pix_offset;

    virt_x = w->lyreDisp.virtual_x;

    if (w->scale.virtual_y)
	virt_y = *(w->scale.virtual_y);
    if (w->scale.horizontal) {
	if (w->scale.scale_bottom) {
	    mtm_start =
		tm_start = w->core.height - 1;
	    tm_end = w->core.height - w->scale.minor_tm_length;
	    mtm_start = w->core.height - 1;
	    mtm_end = w->core.height - w->scale.major_tm_length;
	    label_y = w->core.height - 2 - w->scale.minor_tm_length -
		w->scale.descent;
	}
	else {
	    mtm_start =
		tm_start = 0;
	    tm_end = w->scale.minor_tm_length;
	    mtm_end = w->scale.major_tm_length;
	    label_y = 2 + w->scale.minor_tm_length + w->scale.ascent;
	}

	if (w->scale.show_extent) {
	    /*
	     * Display a label 
	     */
	    char                label[64];
	    int                 tw;

	    sprintf (label, w->scale.ctl_string,
		     w->scale.unit_per_pix * (virt_x + tm_zero_pix));
	    XDrawString (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			 2, label_y,  label, strlen (label));

	    sprintf (label, w->scale.ctl_string,
		     w->scale.unit_per_pix * (virt_x + tm_zero_pix + 
					      (int)w->core.width));
	    tw = XTextWidth (w->scale.font_info, label, strlen (label));
	    XDrawString (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			 w->core.width - (2 + tw), label_y,
			 label, strlen (label));
	}

	tm = (expose->x + virt_x + tm_zero_pix) / w->scale.pix_per_tm;
	End = expose->x + expose->width;
	x = (tm * w->scale.pix_per_tm) - virt_x - tm_zero_pix;

	for (; x < End; x = (++tm * w->scale.pix_per_tm) - virt_x - 
	     tm_zero_pix) {
	  if (abs (tm) % w->scale.tm_per_mtm) {
		/*
		 * Minor tic mark 
		 */
		XDrawLine (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			   x, tm_start,
			   x, tm_end);
	    }
	    else {
		/*
		 * Major tic mark 
		 */
		XDrawLine (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			   x, mtm_start,
			   x, mtm_end);
		if (w->scale.tm_per_mtm &&
		    (abs (tm) % 
		     (w->scale.tm_per_mtm * w->scale.mtm_per_label) == 0)) {
		    /*
		     * Display a label 
		     */
		    char  label[64];

		    sprintf (label, w->scale.ctl_string, tm * 
			     w->scale.unit_per_tm);
		    XDrawString (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
				 x + 2, label_y,
				 label, strlen (label));
		}
	    }
	}
    }
    else {
	if (!w->scale.scale_left) {
	    mtm_start =
		tm_start = w->core.width - 1;
	    tm_end = w->core.width - w->scale.minor_tm_length;
	    mtm_end = w->core.width - w->scale.major_tm_length;
	    label_x = 2;
	}
	else {
	    mtm_start =
		tm_start = 0;
	    tm_end = w->scale.minor_tm_length;
	    mtm_end = w->scale.major_tm_length;
	    label_x = 2 + w->scale.minor_tm_length;
	}

	if (w->scale.show_extent) {
	    /*
	     * Display a label 
	     */
	    char                label[64];
	    float		unit;
            int tmp;

	    unit = w->scale.unit_per_pix * (tm_zero_pix - virt_y);
	    if (! w->scale.count_up) unit = -unit;
	    sprintf (label, w->scale.ctl_string, unit);
	    XDrawString (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			 label_x, 2 + w->scale.ascent,
			 label, strlen (label));

	    unit = w->scale.unit_per_pix * (tm_zero_pix - virt_y - 
					    (int)w->core.height);
	    if (! w->scale.count_up) unit = -unit;
	    tmp = (tm_zero_pix - virt_y - w->core.height);
	    sprintf (label, w->scale.ctl_string, unit);
	    XDrawString (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			 label_x, w->core.height - (w->scale.descent + 2),
			 label, strlen (label));
	}

	tm = (tm_zero_pix - virt_y - expose->y) / w->scale.pix_per_tm;
	End = expose->y + expose->height;
	y = (tm * w->scale.pix_per_tm) - virt_y - tm_zero_pix;

	for (; y < End; ) {
	    if (abs (tm) % w->scale.tm_per_mtm) {
		/*
		 * Minor tic mark 
		 */
	      XDrawLine (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			 tm_start, y,
			 tm_end, y);
	    }
	    else {
		/*
		 * Major tic mark 
		 */
		XDrawLine (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
			   mtm_start, y,
			   mtm_end, y);
		if (w->scale.tm_per_mtm &&
		    (abs (tm) % (w->scale.tm_per_mtm * w->scale.mtm_per_label)
		     == 0)) {
		    /*
		     * Display a label 
		     */
		    char                label[64];

		    sprintf (label, w->scale.ctl_string, tm * 
			     w->scale.unit_per_tm);
		    XDrawString (XtDisplay (w), XtWindow (w), w->scale.scaleGC,
				 label_x, y - 2,
				 label, strlen (label));
		  }
	      }
	    y = (--tm * w->scale.pix_per_tm) - virt_y - tm_zero_pix;
	    if (w->scale.count_up) y = -y;
	  }
      }
  }


/*
 * Boolean (current, request, new)
 *
 */

static Boolean SetValues (Widget current_in, Widget request_in, Widget new_in,
			  ArgList arglist, Cardinal *num_args)
{
    ScaleWidget current = (ScaleWidget) current_in;
    ScaleWidget request = (ScaleWidget) request_in;
    ScaleWidget new     = (ScaleWidget) new_in;
    Boolean redisplay = FALSE;

    if ((new->scale.unit_per_pix != current->scale.unit_per_pix) ||
	(new->scale.pix_per_tm != current->scale.pix_per_tm)) {
	new->scale.unit_per_tm = new->scale.unit_per_pix * 
	  new->scale.pix_per_tm;
  	AdjustScale (new);
	AdjustGeometry (new);
	redisplay = TRUE;
    }

    return (redisplay);
}


/*
 * AdjustScale (w)
 *
 * Description
 *	Recompute pix_per_tm and unit_per_tm if they fall out
 * outside the defined bounds.
 *
 */
 
static void AdjustScale (register ScaleWidget w)
{
  int i= 0;
    w->scale.pix_per_tm *= (10.0 / w->scale.unit_per_tm);
    w->scale.unit_per_tm = 10.0;
    while (w->scale.pix_per_tm > w->scale.max_pix_per_tm) {
	w->scale.pix_per_tm /= 5.0;
        w->scale.unit_per_tm /= 5.0;
    }
    while (w->scale.pix_per_tm < w->scale.min_pix_per_tm) {
	w->scale.pix_per_tm *= 5.0;
        w->scale.unit_per_tm *= 5.0;
    }
}


/*
 * AdjustGeometry (w)
 *
 */

static void AdjustGeometry (register ScaleWidget w)
{
    if (w->scale.horizontal) {
	w->core.height = w->scale.ascent + w->scale.descent +
	    w->scale.minor_tm_length + 2;
    }
    else {
	char label1[64];
	char label2[64];
	int  virt_y = 0;
	int  max_strlen;

	if (w->scale.virtual_y)
	    virt_y = *(w->scale.virtual_y);
	sprintf (label1, w->scale.ctl_string,
		 w->scale.unit_per_pix * (w->scale.zero_pix_offset - virt_y));
	sprintf (label2, w->scale.ctl_string,
		 w->scale.unit_per_pix * (w->scale.zero_pix_offset - virt_y - 
					  (int)w->core.height));
	max_strlen = strlen (label1);
	max_strlen = MAX (max_strlen, (int) strlen (label2));
	max_strlen = 4;
	w->core.width = (w->scale.font_width * max_strlen) +
	    w->scale.minor_tm_length + 2;
    }
}


