static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Mark.c,v 4.4 1993/05/28 21:27:40 johans Exp $";

/*
 * Mark.c - Line Graph Widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 */

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>

/* Lyre include file directives */
#include <MarkP.h>
#include <Scale.h>
#include <LyreDisp.h>

/* Standard C library include file directives */
#include <malloc.h>
#include <c.h>


/* Private Definitions */
static char defaultTranslations[] =
    "<Btn1Down>:   ToggleMark() \n\
     <Btn2Down>:   HighlightMark() \n\
     <Btn3Down>:   LowlightMark() \n\
     <Enter>:       TrackMouse(e) \n\
     <Leave>:       TrackMouse(l) \n\
     <Motion>:      TrackMouse(m) \n\
";

#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}

/* Initialization of defaults */

#define OFFSET(field) XtOffset(MarkWidget,mark.field)
#define GOFFSET(field) XtOffset(Widget,core.field)

static int Zero = 0;

static XtResource resources[] = {
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
        OFFSET(foreground_pixel), XtRString, "Black"},
    {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
	GOFFSET(width), XtRString, "10"},
    {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
	GOFFSET(height), XtRString, "0"},
    {XtNmarkLength, XtNmarkLength, XtRInt, sizeof(int),
	OFFSET(mark_length), XtRString, "10"},
    {XtNreverseVideo, XtCReverseVideo, XtRBoolean, sizeof (Boolean),
	OFFSET (reverse_video), XtRString, "FALSE"},
    {XtNstoreData, XtNstoreData, XtRPointer, sizeof(caddr_t),
	OFFSET (store_data), XtRPointer, NULL},
    {XtNinputData, XtNinputData, XtRPointer, sizeof(caddr_t),
	OFFSET (input_data), XtRPointer, NULL},
    {XtNstoreHighlight, XtNstoreHighlight, XtRPointer, sizeof(caddr_t),
	OFFSET (store_highlight), XtRPointer, NULL},
    {XtNinputHighlight, XtNinputHighlight, XtRPointer, sizeof(caddr_t),
	OFFSET (input_highlight), XtRPointer, NULL},

    {XtNhscaleWidget, XtCParameter, XtRPointer, sizeof(caddr_t),
	OFFSET (hscale_widget), XtRPointer, NULL},
    {XtNvscaleWidget, XtCParameter, XtRPointer, sizeof(caddr_t),
	OFFSET (vscale_widget), XtRPointer, NULL},
};

#undef OFFSET
#undef GOFFSET

/* Private procedure header declarations */
static void Initialize (Widget request, Widget new, ArgList arglist,
			Cardinal *num_args);
static void Realize (Widget w_in, XtValueMask *valueMask, 
		     XSetWindowAttributes *attrs);
static void Destroy (Widget w_in);
static void Resize (Widget gw);
static void Redisplay (Widget w_in, XEvent *event_in, Region region);
static void ComputeSegments (register MarkWidget w);
static Boolean SetValues (Widget gcurrent, Widget grequest, Widget gnew,
			  ArgList arglist, Cardinal *num_args);

/*
static void ComputeSegments1 (vdata_t *vdata, vdata_t *hdata, 
			      register XSegment *segments, 
			      register BigSegment *bigsegments, 
			      u_int nsegments, register int offset, 
			      double TimeScale, int length);

static void ComputeSegments2 (vdata_t *vdata, vdata_t *hdata, 
			      register XSegment *segments, 
			      register BigSegment *bigsegments, 
			      u_int nsegments, register int offset, 
			      double TimeScale, int length);

static void ComputeSegments4 (vdata_t *vdata, vdata_t *hdata, 
			      register XSegment *segments, 
			      register BigSegment *bigsegments, 
			      u_int nsegments, register int offset, 
			      double TimeScale, int length);
*/

static void HighlightMark (MarkWidget w, XEvent *event, String *params,
			   Cardinal *num_params);
static void LowlightMark (MarkWidget w, XEvent *event, String *params,
			   Cardinal *num_params);
static void ToggleMark (MarkWidget w, XEvent *event, String *params,
			   Cardinal *num_params);


static XtActionsRec actions[] = {
	{"ToggleMark",		(XtActionProc) ToggleMark},
	{"HighlightMark",	(XtActionProc) HighlightMark},
	{"LowlightMark",	(XtActionProc) LowlightMark},
	{"TrackMouse",		(XtActionProc) LyreDispTrackMouse},
	{NULL,NULL}
};
MarkClassRec markClassRec = {
    { /* core fields */
    /* superclass		*/	(WidgetClass) &lyreDispClassRec,
    /* class_name		*/	"Mark",
    /* widget_size		*/	sizeof(MarkRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* resource_count		*/	XtNumber(resources),
    /* xrm_class		*/	NULL,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	(TRUE | XtExposeGraphicsExpose),
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry           */	NULL,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,	
    /* extension		*/	NULL,
    }
};

WidgetClass markWidgetClass = (WidgetClass) &markClassRec;


/*
 * Initialize (request, new)
 *
 */

static void Initialize (Widget request, Widget new, ArgList arglist,
			Cardinal *num_args)
{
  MarkWidget w = (MarkWidget) new;
  XtGCMask valuemask;
  XGCValues myXGCV;

  valuemask = GCForeground | GCBackground | GCLineWidth | GCGraphicsExposures;

    if (w->mark.reverse_video) {
	Pixel fg = w->mark.foreground_pixel;
	Pixel bg = w->core.background_pixel;

	if (w->core.border_pixel == fg)
	    w->core.border_pixel = bg;
	w->mark.foreground_pixel = bg;
	w->core.background_pixel = fg;
    }

    myXGCV.foreground = w->mark.foreground_pixel;
    myXGCV.background = w->core.background_pixel;
    myXGCV.line_width = 0;
    myXGCV.graphics_exposures = TRUE;	/* default */
    w->mark.myGC = XtGetGC ((Widget) w, valuemask, &myXGCV);

    w->mark.store_data = w->mark.input_data;
    w->mark.input_data = 0;
    w->mark.nsegments = 0;
    w->mark.segments = 0;
    w->mark.bigsegments = 0;
    w->core.height = w->mark.mark_length;
}


/*
 * Realize (w, valueMask, attrs)
 *
 */

static void Realize (Widget w_in, XtValueMask *valueMask, 
		     XSetWindowAttributes *attrs)
{
    MarkWidget w = (MarkWidget) w_in;
    XtCreateWindow ((Widget) w, InputOutput, (Visual *) CopyFromParent,
		    *valueMask, attrs);
    Resize ((Widget) w);
}


/*
 * Destroy (w)
 *
 */

static void Destroy (Widget w_in)
{
     MarkWidget w = (MarkWidget) w_in;

     XtDestroyGC (w->mark.myGC);
     XtFree ((char *) w->mark.segments);
}


/*
 * Destroy (gw)
 *
 */
 
static void Resize (Widget gw)
{
    MarkWidget w = (MarkWidget) gw;

    /*
     * don't do this computation if window hasn't been realized yet.
     */
    if (XtIsRealized ((Widget) w)) {
	ComputeSegments (w);
    }
}


/*
 * Redisplay (w, event, region)
 *
 */

static void Redisplay (Widget w_in, XEvent *event_in, Region region)
{
    MarkWidget        w = (MarkWidget) w_in;
    XExposeEvent *event = (XExposeEvent *) event_in;
    register int        i;
    register int        EndX;
    register int        StartX;
    register int        VirtualX;
    register XSegment  *seg;
    register XSegment  *xseg;
    register BigSegment *bseg;

    if (w->mark.nsegments && w->mark.segments) {
	VirtualX = w->lyreDisp.virtual_x;
	StartX = event->x + VirtualX;
	EndX = event->width + StartX;

	/* the x values are in the integer structure bigsegments */
	for (bseg = w->mark.bigsegments,xseg = w->mark.segments, i = 0;
	     i < w->mark.nsegments;
	     i++, xseg++,bseg++) {
	    if (bseg->x1 >= StartX)
		break;
	}

	seg = xseg;

	for (; i < w->mark.nsegments; i++, xseg++,bseg++) {
	    if (bseg->x1 > EndX)
		break;
	    /* copy the adjusted (visual-window-relative) x values to
	       the XSegment structure fromt the BigSegment structure
	     */
	    xseg->x1 = bseg->x1 - VirtualX;
	    xseg->x2 = bseg->x2 - VirtualX;
	}

	XDrawSegments (XtDisplay (w), XtWindow (w), w->mark.myGC,
		       seg, xseg-seg);

    }
}


/*
 * Boolean SetValues (gcurrent, grequest, gnew)
 *
 */

static Boolean SetValues (Widget gcurrent, Widget grequest, Widget gnew,
			  ArgList arglist, Cardinal *num_args)
{
    MarkWidget   current = (MarkWidget) gcurrent;
    MarkWidget   new = (MarkWidget) gnew;
    MarkWidget   req = (MarkWidget) grequest;
    Boolean      redisplay = FALSE;
    Boolean      recompute = FALSE;
    XtGCMask     valuemask;
    XGCValues    myXGCV;

    if ((new->mark.foreground_pixel != current->mark.foreground_pixel)
	|| (new->core.background_pixel != current->core.background_pixel)) {
	valuemask = GCForeground | GCBackground | GCFont | GCLineWidth;
	myXGCV.foreground = new->mark.foreground_pixel;
	myXGCV.background = new->core.background_pixel;
	myXGCV.line_width = 0;
	XtDestroyGC (current->mark.myGC);
	new->mark.myGC = XtGetGC (gcurrent, valuemask, &myXGCV);
	redisplay = TRUE;
    }

    if (new->core.background_pixel != current->core.background_pixel) {
	valuemask = GCForeground | GCLineWidth;
	myXGCV.foreground = new->core.background_pixel;
	myXGCV.line_width = 0;
	redisplay = TRUE;
    }

    if (new->mark.input_data) {
	free (new->mark.store_data);
	new->mark.store_data = new->mark.input_data;
	new->mark.input_data = 0;
	recompute = TRUE;
    }

    if (new->mark.input_highlight) {
	free (new->mark.store_highlight);
	new->mark.store_highlight = new->mark.input_highlight;
	new->mark.input_highlight = 0;
	recompute = TRUE;
    }

    if (new->lyreDisp.secs_ppix != current->lyreDisp.secs_ppix) {
	if (new->mark.hscale_widget) {
	    int arg_cnt = 0;
	    Arg 	args[20];
	    union {
		float f;
		unsigned int i;
	    }                   unit_per_pix;

	    unit_per_pix.f = (float) 1000.0 * new->lyreDisp.secs_ppix;

	    arg_cnt = 0;
	    MyXtSetArg (args, arg_cnt, XtNunitPerPix, unit_per_pix.i);
	    XtSetValues (new->mark.hscale_widget, args, arg_cnt);
	}
	recompute = TRUE;
    }

    if (recompute) {
	ComputeSegments (new);
	redisplay = TRUE;
    }

    if (current->lyreDisp.virtual_width != new->lyreDisp.virtual_width)
	XtCallCallbacks((Widget) new,XtNwidthProc, 
			(XtPointer) new->lyreDisp.virtual_width);

    return (redisplay);
}


#define COMPUTESEGMENTS(name,type,vdata,segments,bigsegments,nsegments,length,offset,TimeScale) \
static void name (vdata_t *vdata, vdata_t *hdata, register XSegment *segments,\
		  register BigSegment *bigsegments, u_int nsegments, \
		  int length, register int offset, double TimeScale) \
{ \
    register type *ptr = (type *) vdata->ptr; \
    register type *hptr; \
    register int seg; \
    register u_int xpix; \
 \
    if (hdata) \
	hptr = (type *) hdata->ptr; \
    for (seg = 0; seg < nsegments; seg++) { \
	xpix = *ptr++ * TimeScale; \
	bigsegments->x1 = xpix; \
	if (hdata) { \
	    if (*hptr++) \
		segments->y1 = 0; \
	    else \
		segments->y1 = offset; \
	} \
	else \
	    segments->y1 = offset; \
	bigsegments->x2 = xpix; \
	segments->y2 = length; \
	segments++; \
	bigsegments++; \
    } \
} 

COMPUTESEGMENTS(ComputeSegments1, char, vdata, segments, bigsegments, nsegments, length, offset, TimeScale)

COMPUTESEGMENTS(ComputeSegments2, short, vdata, segments, bigsegments, nsegments, length, offset, TimeScale)

COMPUTESEGMENTS(ComputeSegments4, int, vdata, segments, bigsegments, nsegments, length, offset, TimeScale)

#undef COMPUTESEGMENTS


/*
 * ComputeSegments (w)
 *
 */

static void ComputeSegments (register MarkWidget w)
{
    double      TimeScale;
    register vdata_t   *vdata = w->mark.store_data;
    register vdata_t   *hdata = w->mark.store_highlight;
    register int        offset;

    if (vdata == 0)
	return;

    XtFree ((char *) w->mark.segments);
    w->mark.segments = 0;
    w->mark.nsegments = 0;

    if ((vdata->ptr == 0) || (vdata->count == 0))
	return;

    TimeScale = (float) vdata->ns_per_datum / 
      (w->lyreDisp.secs_ppix * 1000000000.0);

    offset = w->lyreDisp.top_padding;

    w->mark.nsegments = vdata->count;
    w->mark.segments = (XSegment *) XtMalloc (w->mark.nsegments *
					      sizeof (XSegment));
    w->mark.bigsegments = (BigSegment *) XtMalloc (w->mark.nsegments *
						sizeof (BigSegment));

    switch (vdata->bsize) {
    case 1:
	ComputeSegments1 (vdata, hdata, w->mark.segments, w->mark.bigsegments,
			  w->mark.nsegments, w->mark.mark_length, offset, 
			  TimeScale);
	break;
    case 2:
	ComputeSegments2 (vdata, hdata, w->mark.segments, w->mark.bigsegments,
			  w->mark.nsegments, w->mark.mark_length, offset, 
			  TimeScale);
	break;
    case 4:
	ComputeSegments4 (vdata, hdata, w->mark.segments, w->mark.bigsegments,
			  w->mark.nsegments, w->mark.mark_length, offset, 
			  TimeScale);
	break;
    }
}


/*
 * HighlightMark (w, event, params, num_params)
 *
 */

static void HighlightMark (MarkWidget w, XEvent *event, String *params, 
			   Cardinal *num_params)
{
    register int        idx;
    register int        virt_x = w->lyreDisp.virtual_x;

    if (w->mark.nsegments && w->mark.segments) {
	idx = get_mark_idx (w, event->xbutton.x + virt_x);
	((int *) w->mark.store_highlight->ptr)[idx] = TRUE;
	w->mark.segments[idx].y1 = 0;
	XClearArea (XtDisplay (w), XtWindow (w),
	      w->mark.bigsegments[idx].x1 - virt_x, 0, 1, w->core.height, TRUE);
    }
}


/*
 * LowlightMark (w, event, params, num_params)
 *
 */

static void LowlightMark (MarkWidget w, XEvent *event, String *params, 
			  Cardinal *num_params)
{
    register int        idx;
    register int        virt_x = w->lyreDisp.virtual_x;

    if (w->mark.nsegments && w->mark.segments) {
	idx = get_mark_idx (w, event->xbutton.x + virt_x);
	((int *) w->mark.store_highlight->ptr)[idx] = FALSE;
	w->mark.segments[idx].y1 = w->lyreDisp.top_padding;
	XClearArea (XtDisplay (w), XtWindow (w),
		    w->mark.bigsegments[idx].x1 - virt_x, 0, 1, 
		    w->core.height, TRUE);
    }
}


/*
 * ToggleMark(w, event, params, num_params)
 *
 */

static void ToggleMark (MarkWidget w, XEvent *event, String *params, 
			Cardinal *num_params)
{
    register int        idx;
    register int        virt_x = w->lyreDisp.virtual_x;

    if (w->mark.nsegments && w->mark.segments) {
	idx = get_mark_idx (w, event->xbutton.x + virt_x);
	if (((int *) w->mark.store_highlight->ptr)[idx]) {
	    ((int *) w->mark.store_highlight->ptr)[idx] = FALSE;
	    w->mark.segments[idx].y1 = w->lyreDisp.top_padding;
	}
	else {
	    ((int *) w->mark.store_highlight->ptr)[idx] = TRUE;
	    w->mark.segments[idx].y1 = 0;
	}
	XClearArea (XtDisplay (w), XtWindow (w),
		    w->mark.bigsegments[idx].x1 - virt_x, 0, 1, 
		    w->core.height, TRUE);
    }
}


/*
 * get_mark_idx (w, x)
 *
 */

get_mark_idx (MarkWidget w, register int x)
{
    register int i, segcnt;
    register BigSegment *seg;

    segcnt = w->mark.nsegments;
    seg =  w->mark.bigsegments;

    if ((0 <= x) && (x <= seg[1].x1))
        return (0);

    for (i = 0; i < segcnt-1; i++) {
	if ((seg[i].x1 <= x) && (x <= seg[i+1].x1))
	    break;
    }
    if ((x - seg[i].x1) > (seg[i+1].x1 - x))
	return (i+1);
    else
	return (i);
}

