/* LyreDisp.h - Public LyreDisp Widget Defs
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 *  6-Sep-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added XtCdefFn.
 *
 * 27-Jun-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added extern def of LyreDispTrackMouse().
 *
 */

#ifndef _XtLyreDisp_h
#define _XtLyreDisp_h

#define NS_PER_SEC 1000000000


/* Resource names used to the lyreDisp widget
 */
#define XtNresolution	"resolution"	/* (u_int) Resolution */
#define XtNsecsPpix	"secsppix"	/* Seconds per pixel */
#define XtNunitsPsec	"unitspsec"	/* Units per second */
#define XtNunitsPpix	"unitsppix"	/* Units per pix */
#define XtNtopPadding	"toppadding"	/* (u_int) padding */
#define XtNbottomPadding "bottompadding"	/* (u_int) padding */
#define XtCPadding	"padding"	/* (u_int) padding */
#define XtNvirtualX	"virtualX"	/* (int) */
#define XtNvirtualWidth	"virtualWidth"	/* (int) */
#define XtNwidthProc	"widthProc"	/* (XtCallbackList) */

#ifndef XtNscrollWidget
#define XtNscrollWidget "scrollwidget"	/* Scroll Widget */
#endif

#define XtNyokeWidget	"yokewidget"	/* Yoke Widget */
#define XtNtoolWidget   "toolwidget"    /* Tool Widget */

#define XtCdefFn	"deffn"		/* Default File Name */

typedef struct _LyreDispRec *LyreDispWidget;	   /* defined in LyreDispP.h */
typedef struct _LyreDispClassRec *LyreDispWidgetClass; /* defined in LyreDispP.h */

extern WidgetClass lyreDispWidgetClass;

extern void LyreDispTrackMouse();

#define PixToSecs(w,x)	((x + (w)->lyreDisp.virtual_x) * \
					(w)->lyreDisp.secs_ppix)
/*------------------------------------------------------------*
 * Convert pixels to seconds
 */

#define SecsToPix(w,s)	((s / (w)->lyreDisp.secs_ppix) - \
					(w)->lyreDisp.virtual_x)
/*------------------------------------------------------------*
 * Convert seconds to pixels
 */

#define SecsToAbsPix(w,s)	(s / (w)->lyreDisp.secs_ppix)
/*------------------------------------------------------------*
 * Convert seconds to absolute pixels
 */

#endif _XtLyreDisp_h


