static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/LyreDisp.c,v 4.3 1993/05/28 21:27:40 johans Exp $";

/*
 * LyreDisp.c - LyreDisp widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 *  16-Apr-93 Johan Schalkwyk at Oregon Graduate Institute
 *      changes headers to ANSI style declarations
 *
 */

/* Standard C library include file directives */
#include <c.h>
#include <stdio.h>
#include <ctype.h>

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Xmu/Misc.h>

/* Lyre include file directives */
#include <LyreDispP.h>
#include <YokeP.h>
#include <LyreStringDefs.h>


/* RESCOURCES
 */
static int Zero = 0;

#define offset(field) XtOffset(LyreDispWidget, lyreDisp.field)

static XtResource resources[] = { 
   {XtNsecsPpix, XtNsecsPpix, XtRFloat, sizeof(float), 
      offset(secs_ppix), XtRString, "0.001"},
   {XtNunitsPpix, XtNunitsPpix, XtRFloat, sizeof(float),
      offset(units_ppix), XtRString, "1.0"},
   {XtNunitsPsec, XtNunitsPsec, XtRFloat, sizeof(float), 
      offset(units_psec), XtRString, "1000.0"},
   {XtNtopPadding, XtCPadding, XtRInt, sizeof(int), 
      offset(top_padding), XtRString, "4"},
   {XtNbottomPadding, XtCPadding, XtRInt, sizeof(int), 
      offset(bottom_padding), XtRString, "4"},
   {XtNvirtualWidth, XtNvirtualWidth, XtRInt, sizeof(int), 
      offset(virtual_width), XtRInt, (caddr_t) &Zero},
   {XtNvirtualX, XtNvirtualX, XtRInt, sizeof(int), 
      offset(virtual_x), XtRInt, (caddr_t) &Zero},
   {XtNwidthProc, XtCCallback, XtRCallback, sizeof(caddr_t), 
      offset(width_proc), XtRCallback, (caddr_t) NULL},
   {XtNscrollWidget, XtCParameter, XtRPointer, sizeof(caddr_t), 
      offset(scroll_widget), XtRPointer, (caddr_t) NULL},
   {XtNyokeWidget, XtCParameter, XtRPointer, sizeof(caddr_t), 
      offset(yoke_widget), XtRPointer, (caddr_t) NULL},
   {XtNtoolWidget, XtCParameter, XtRPointer, sizeof(caddr_t), 
      offset(toolWidget), XtRPointer, (caddr_t) NULL},
};
#undef offset

/* Private procedure header declarations */
static void Destroy (Widget gw);
static void Initialize (Widget request_in, Widget new_in,
			ArgList arglist, Cardinal *num_args);
static Boolean SetValues (Widget current_in, Widget req_in, Widget new_in,
			  ArgList arglist, Cardinal *num_args);


LyreDispClassRec lyreDispClassRec = {
  {
    (WidgetClass) &widgetClassRec,	/* superclass		  */	
    "LyreDisp",				/* class_name		  */
    sizeof(LyreDispRec),		/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    XtInheritAcceptFocus,		/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL,				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    0,		                 	/* unused */
  },  /* LyreDispClass fields initialization */
};

WidgetClass lyreDispWidgetClass = (WidgetClass) &lyreDispClassRec;

/*
 * Private Procedures
 */


/*
 * Destroy (gw)
 *
 */

static void Destroy (Widget gw)
{
     LyreDispWidget w = (LyreDispWidget) gw;

     XtRemoveAllCallbacks ((Widget) w, XtNwidthProc); 
}


/*
 * Initialize (request, new)
 *
 */

static void Initialize (Widget request_in, Widget new_in, ArgList arglist,
			Cardinal *num_args)
{
    LyreDispWidget request = (LyreDispWidget) request_in;
    LyreDispWidget new     = (LyreDispWidget) new_in;
    XtGCMask mask;
    XGCValues myXGCV;

    mask = GCLineWidth | GCFunction;
    myXGCV.line_width = 0;
    myXGCV.function = GXinvert;
    new->lyreDisp.cursorGC = XtGetGC ((Widget) new, mask, &myXGCV);

    if (new->lyreDisp.cursor_timeP == NULL)
	new->lyreDisp.cursor_timeP = &(new->lyreDisp.cursor_time);
    new->lyreDisp.pixToHZ = 0;
    new->lyreDisp.hzToPix = 0;
    new->lyreDisp.units_ppix = new->lyreDisp.secs_ppix * 
                               new->lyreDisp.units_psec;

}


/*
 * LyreDispTrackMouse (w, event, params, num_params)
 *
 */

void LyreDispTrackMouse (LyreDispWidget w, XMotionEvent *event, String *params,
			 Cardinal *num_params)
{
    register int        i;
    register float      time;
    char                ctl = *params[0];
    YokeWidget          yw = (YokeWidget) w->lyreDisp.yoke_widget;
    WidgetList          wl;
    int                 wc;
    Position		x, y;
    LyreDispWidget	ldw;
    static char		state = 'l';

    if (yw == 0)
	return;
    wl = yw->yoke.widgets;
    wc = yw->yoke.widget_count;

    time = PixToSecs( w, event->x );

    switch (ctl) {
    case 'e':
	/* Draw cursor */
	if (state == 'e')	/* Can't enter unless we're out */
	    break;
	state = 'e';
	for (i = 0; i < wc; i++) {
	    ldw = (LyreDispWidget) wl[i];
	    x = SecsToPix( ldw, time );
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
		       x, 0, x, ldw->core.height);

	    ldw->lyreDisp.cursor_x = x + ldw->lyreDisp.virtual_x;

#ifdef CROSS_HAIR
	    y = event->y;
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
			 x-10, y, x+10, y);
	    ldw->lyreDisp.cursor_y = y;
#endif
	}
	break;
    case 'b':
    case 'm':
	if (state == 'l')	/* Can't move unless we're in */
	    break;
	/* Move cursor */
	for (i = 0; i < wc; i++) {
	    ldw = (LyreDispWidget) wl[i];
	    x = ldw->lyreDisp.cursor_x - ldw->lyreDisp.virtual_x;
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
		       x, 0, x, ldw->core.height);

#ifdef CROSS_HAIR
	    y = ldw->lyreDisp.cursor_y;
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
			 x-10, y, x+10, y);
#endif

	    x = SecsToPix( ldw, time );
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
		       x, 0, x, ldw->core.height);

	    ldw->lyreDisp.cursor_x = x + ldw->lyreDisp.virtual_x;

#ifdef CROSS_HAIR
	    y = event->y;
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
			 x-10, y, x+10, y);
	    ldw->lyreDisp.cursor_y = y;
#endif
	}
	break;
    case 'l':
	/* Erase cursor */
	if (state == 'l')	/* Can't leave twice */
	    break;
 	state = 'l';
	for (i = 0; i < wc; i++) {
	    ldw = (LyreDispWidget) wl[i];
	    x = ldw->lyreDisp.cursor_x - ldw->lyreDisp.virtual_x;
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
		       x, 0, x, ldw->core.height);

#ifdef CROSS_HAIR
	    y = ldw->lyreDisp.cursor_y;
	    XDrawLine (XtDisplay (ldw), XtWindow(ldw), ldw->lyreDisp.cursorGC,
			 x-10, y, x+10, y);
#endif
	}
	break;
    default:
	fprintf (stderr, "%s: Unknown parameter [%c]\n", ctl);
    }
}


/*
 * Boolean SetValues (current, req, new)
 *
 */

static Boolean SetValues (Widget current_in, Widget req_in, Widget new_in,
			  ArgList arglist, Cardinal *num_args)
{
    LyreDispWidget current = (LyreDispWidget) current_in;
    LyreDispWidget req     = (LyreDispWidget) req_in;
    LyreDispWidget new     = (LyreDispWidget) new_in;
    Boolean               redisplay = FALSE;
    float                 centerTime;
    int                  centerX;

    if (new->lyreDisp.secs_ppix != current->lyreDisp.secs_ppix) {
        centerTime = PixToSecs (current, ((float) current->core.width / 2.0));
	centerX = SecsToAbsPix (new, centerTime);
	new->lyreDisp.virtual_x = centerX - (new->core.width / 2);
    }
    return (redisplay);
}

