/* LspectoolP.h - Private definitions for Lspec tool widget
 * 
 */

#ifndef _XtLspectooltP_h
#define _XtLspectooltP_h

#include <Lspectool.h>
#include <X11/Xaw/FormP.h>

typedef struct _LspectoolClass 
{
    int makes_compiler_happy;	/* not used */
} LspectoolClassPart;

typedef struct _LspectoolClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    LspectoolClassPart    lspectool_class;
}                   LspectoolClassRec;

extern LspectoolClassRec lspectoolClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

/* New fields for the Lspectool widget record */
typedef struct {
    /* resources */
    XtCallbackList      callbacks;
    Widget              child;		/* Graphic part */

    int			first_channel;	/* First channel to display */
    int			last_channel;	/* Last channel to display */

    Boolean             horiz_scale_on; /* Display a horizontal scale */
    Boolean             vert_scale_on; /* Display a vertical scale */
    Widget		hscale;		/* The (optional) hscale widget */
    Widget		vscale;		/* The (optional) vscale widget */
    Widget		scroll;		/* The (optional) scroll widget */
}                   LspectoolPart;


/* Full widget declaration */
typedef struct _LspectoolRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    LspectoolPart         lspectool;
}                   LspectoolRec;

typedef struct _LspectoolConstraintsPart
{
    int makes_compiler_happy;	/* not used */
} LspectoolConstraintsPart;

typedef struct _LspectoolConstraintsRec {
    FormConstraintsPart		form;    
    LspectoolConstraintsPart	lspectool;
} LspectoolConstraintsRec, *LspectoolConstraints;

#endif _XtLspectoolP_h
