static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Lspectool.c,v 4.3 1993/05/28 21:27:40 johans Exp $";

/*
 * Lspectool.c - Lspectool widget
 *------------------------------------------------------------*
 * HISTORY
 *    Jun 14, 1989 Fil Alleva @ OGC
 *        - Changed default to test.psdft
 *
 *    16-Apr-93 Johan Schalkwyk at Oregon graduate Institute changes
 *          to ANSI type header declarations
 *
 */

/* standard C library include file directives */
#include <stdio.h>
#include <ctype.h>
#include <math.h>

/* Speech library include file directives */
#include <speech.h>

/* X library include file directives */
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/CommandP.h>
#include <X11/Xaw/DialogP.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

/* Lyre include file directives */
#include <LspecP.h>
#include <LspectoolP.h>
#include <Scale.h>
#include <ToolUtil.h>
#include <dft.h>
#include <syncstruct.h>

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* external procedure declarations */
Widget MakeButtonPopup (Widget GodParent, Widget Parent, Widget AboveWidget, 
			Widget LeftWidget, caddr_t CallData,
			char *ButtonName, char *Prompt, char *Default, 
			char *GoLabel, char *AbortLabel, caddr_t GoAction, 
			char *Resource);


/* private procedure header declarations */
static void GetData (Widget w, WidgetList client_data);
static void GetDataS (Widget w, WidgetList client_data);
static void Destroy (Widget w, Widget target_widget, caddr_t call_data);
static void Initialize (Widget request_in, Widget new_in, ArgList arglist,
			Cardinal *num_args);
static void PutData (Widget w, WidgetList client_data);
static void SetOffset (Widget w, WidgetList client_data);
static void ToggleExtent(Widget cw, LspectoolWidget tw, caddr_t call_data);


#define offset(field) XtOffset(LspectoolWidget, field)

static Boolean defTRUE = TRUE;

static XtResource resources[] = { 
   {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t), 
      offset(lspectool.callbacks), XtRCallback, (caddr_t)NULL},
   {XtNchild, XtCChild, XtRPointer, sizeof(caddr_t), 
      offset(lspectool.child), XtRPointer, (caddr_t)NULL},
   {XtNvertScaleOn, XtNvertScaleOn, XtRBoolean, sizeof(Boolean), 
      offset(lspectool.vert_scale_on), XtRBoolean, (caddr_t)&defTRUE},
   {XtNhorizScaleOn, XtNhorizScaleOn, XtRBoolean, sizeof(Boolean), 
      offset(lspectool.horiz_scale_on), XtRBoolean, (caddr_t)&defTRUE},
};
#undef offset

LspectoolClassRec lspectoolClassRec = {
  {
    (WidgetClass) &formClassRec,	/* superclass		  */	
    "Lspectool",			/* class_name		  */
    sizeof(LspectoolRec),		/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL,				/* extension		  */
  },  /* CoreClass fields initialization */
  { /* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
  },
  { /* constraint_class fields */
    /* subresourses       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(LspectoolConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL
  },
  {
    0,
  }, /* FormClass fields */
  {
    0,                                     /* field not used    */
  },  /* LspectoolClass fields initialization */
};

  /* for public consumption */
WidgetClass lspectoolWidgetClass = (WidgetClass) &lspectoolClassRec;


/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}

/*
 * Initialize (request, new)
 *
 */

static void Initialize (Widget request_in, Widget new_in,
			ArgList arglist, Cardinal *num_args)
{
    LspectoolWidget request = (LspectoolWidget) request_in;
    LspectoolWidget new     = (LspectoolWidget) new_in;
    Widget ControlWidget, child;
    Widget vscale = NULL, hscale = NULL, command, menu, entry;
    char   stmp[128];
    Arg    args[10];
    int    arg_cnt;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    ControlWidget = XtCreateManagedWidget ("controls", formWidgetClass,
					   (Widget) new, args, arg_cnt);

    if (new->lspectool.horiz_scale_on) {
	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
	MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
	MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
	MyXtSetArg (args, arg_cnt, XtNhorizontal, TRUE);
        MyXtSetArg (args, arg_cnt, XtNborderWidth, 1);
        MyXtSetArg (args, arg_cnt, XtNunitsLabel, "ms");
        MyXtSetArg (args, arg_cnt, XtNshowExtent, FALSE);
	hscale = XtCreateManagedWidget ("scale", scaleWidgetClass, 
					(Widget) new, args, arg_cnt);
        new->lspectool.hscale = hscale;
    }

    if (new->lspectool.vert_scale_on) {
	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
	MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright, XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
	if (new->lspectool.horiz_scale_on)
	     MyXtSetArg (args, arg_cnt, XtNfromVert, hscale);
	MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
	MyXtSetArg (args, arg_cnt, XtNhorizontal, FALSE);
        MyXtSetArg (args, arg_cnt, XtNborderWidth, 1);
        MyXtSetArg (args, arg_cnt, XtNunitsLabel, "kHz");
	vscale = XtCreateManagedWidget ("scale", scaleWidgetClass, 
					(Widget) new, args, arg_cnt);
        new->lspectool.vscale = vscale;
    }

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
    if (new->lspectool.horiz_scale_on)
        MyXtSetArg (args, arg_cnt, XtNfromVert, hscale);
    MyXtSetArg (args, arg_cnt, XtNvscaleWidget, vscale);
    MyXtSetArg (args, arg_cnt, XtNhscaleWidget, hscale);
    MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
    child = XtCreateManagedWidget ("graph", lspecWidgetClass, (Widget) new,
				   args, arg_cnt);
    new->lspectool.child = child;

    /*
     * Build the menu and its actions
     */
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 2);
    MyXtSetArg (args, arg_cnt, XtNhorizDistance, 4);
    MyXtSetArg (args, arg_cnt, XtNvertDistance, 4);
    command = XtCreateManagedWidget("Line Spec Tool", menuButtonWidgetClass, 
				    ControlWidget, args, arg_cnt);
    menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, command, 
			      NULL, 0);

    entry = XtCreateManagedWidget("Set Data File", smeBSBObjectClass, menu, 
				  NULL, 0);
    MakePopup ((Widget)new, entry, (caddr_t)child, "Lspec file name:", 
	       "test.psdft", "Display", "Abort", (caddr_t)GetDataS);

    entry = XtCreateManagedWidget("Write Forms File", smeBSBObjectClass, menu,
				  NULL, 0);
    MakePopup ((Widget)new, entry, (caddr_t)child, "Forms File Name:", 
	       "test.forms", "Write", "Abort", (caddr_t)PutData);

    sprintf (stmp, "%g", ((LspecWidget)child)->lyreDisp.secs_ppix);
    MakeMenuEntry ((Widget)new, menu, (caddr_t)child, "Set Resolution",
		   "Seconds per pixel:", stmp, "Set", "Abort",
		   (caddr_t)SetFloat, XtNsecsPpix);

    entry = XtCreateManagedWidget("Baseline Offset", smeBSBObjectClass, 
				  menu, NULL, 0);
    MakePopup ((Widget)new, entry, (caddr_t)child,
	       "Baseline Offset:", "50", "Set", "Abort", (caddr_t)SetOffset);

    entry = XtCreateManagedWidget("Show formant width", smeBSBObjectClass,
				  menu, NULL, 0);
    XtAddCallback (entry, XtNcallback, (XtCallbackProc) ToggleExtent, new);

    MakeMenuEntry ((Widget)new, menu, (caddr_t)child, 
		   "Set number of Coefficients to display",
		   "Coefficients to Display:", "128", "Set", "Abort",
		   (caddr_t)SetInt, XtNrowCount);

    entry = XtCreateManagedWidget("Delete This Display", smeBSBObjectClass, 
				  menu, NULL, 0);
    XtAddCallback (entry, XtNcallback, (XtCallbackProc) Destroy, new);
}


#if 0


/* 
 * GetData (w, client_data)
 *
 */

static void GetData (Widget w, WidgetList client_data)
{
    LspecWidget         child = (LspecWidget) client_data[0];
    DialogWidget        dw = (DialogWidget) client_data[1];
    Arg                 args[10];
    int                 arg_cnt;
    char               *file = XtDialogGetValueString (dw);
    adata_t            *adata = (adata_t *) calloc (1, sizeof (adata_t));
    dft_hdr_t           head;
    char               *sp, stmp[128];
    FCAND              *fcand = 0;
    u_int               fcount;

    dft_read ("", file, &adata->ptr, &head);
    adata->count = head.frame_count * head.ncoeff;
    adata->bsize = head.byte_per_coeff;
    adata->ns_per_col = 62500 * 48;
    adata->rows = head.ncoeff;
    adata->cols = head.frame_count;

    strcpy (stmp, file);
    sp = strrchr (stmp, '.');
    if (sp)
	strcpy (sp + 1, "forms");
    else
	strcat (stmp, ".forms");

/*
    if (!form_read (stmp, &fcand, &fcount)) {
	if (fcount != adata->cols) {
	    XtAlert ("Warning forms count = %d, frame count = %d",
		     fcount, adata->cols);
	    if (fcount < adata->cols)
		adata->cols = fcount;
	}
    }
*/

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNdata, adata);
    MyXtSetArg (args, arg_cnt, XtNfcand, fcand);
    XtSetValues (child, args, arg_cnt);
}
#endif


/*
 * GetDataS (w, clinet_data)
 *
 * get the synchronous dft data
 *
 */ 

static void GetDataS (Widget w, WidgetList client_data)
{
    LspecWidget   child = (LspecWidget) client_data[0];
    DialogWidget  dw = (DialogWidget) client_data[1];
    Arg           args[10];
    int           arg_cnt;
    char          *file = XawDialogGetValueString ((Widget) dw);
    adata_t       *adata = (adata_t *) calloc (1, sizeof (adata_t));
    char          *sp, stmp[128];
    FCAND         *fcand = 0;
    SYNC          **frame = 0;
    int           nframe;
    int           *offsets;	  

    /* frame offsets from sync struct */
    int                *sync = 0;
    int                 scount;
    int                 delta;

/*
 * This portion of the code is not right at all and
 * is not used any more, so I, Johan Schalkwyk is commenting
 * it out
 *
 */

/*
    if( TdatRead(file, (char ***) &frame, (char **) &nframe) < 0 ) {
	XtAlert ("Problems reading %s", file);
	return;
    }
*/

    frame2adata (adata, &offsets, frame, nframe);
    syncasync (&sync, &scount, &delta, offsets, nframe);
    adata->ns_per_col = 62500;

    strcpy (stmp, file);
    sp = strrchr (stmp, '.');
    if (sp)
	strcpy (sp + 1, "forms");
    else
	strcat (stmp, ".forms");

/*
    if (form_read (stmp, &fcand, &fcount)) {
	XtAlert ("Couldn't find forms file %s cooresponding to %s, won't display formant marks", stmp, file);
    }
    else {
	if (fcount != adata->cols) {
	    XtAlert ("Warning forms count = %d, frame count = %d\n",
		     fcount, adata->cols);
	}
    }
*/

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNdata, adata);
    MyXtSetArg (args, arg_cnt, XtNasync, offsets);
    MyXtSetArg (args, arg_cnt, XtNsync, sync);
    MyXtSetArg (args, arg_cnt, XtNsynccnt, scount);
    MyXtSetArg (args, arg_cnt, XtNsyncdelta, delta);
    MyXtSetArg (args, arg_cnt, XtNfcand, fcand);
    XtSetValues ((Widget) child, args, arg_cnt);
}


/*
 * LspecUnmap(tool)
 *
 * make a spectogram display disappear; space appears blank, not remapped 
 *
 */

int LspecUnmap(LspectoolWidget tool)
{
  XtUnmapWidget(tool->lspectool.child);
}


/*
 * LspecMap(tool)
 * 
 * make an spectogram display reappear 
 *
 */

int LspecMap(LspectoolWidget tool)
{
 XtMapWidget(tool->lspectool.child);
}


/*
 * LspecPollRead(tool, file)
 *
 */

int LspecPollRead (LspectoolWidget tool, char *file)
{
    LspecWidget         child = (LspecWidget) tool->lspectool.child;
    Arg                 args[10];
    int                 arg_cnt;
    adata_t            *adata = (adata_t *) calloc (1, sizeof (adata_t));
    char               *sp, stmp[128];
    FCAND              *fcand = 0;
    SYNC              **frame = 0;
    int                 nframe;
    int                *offsets;           /* These are the cooresponding */
    /* frame offsets from sync struct */
    int                *sync = 0;
    int                 scount;
    int                 delta;

    if(PollForFile (file, 1 /* Interval secs */, 1 /* Attempts */) == -1)
      return -1;
/* 
 * This code is totally wrong and not used any more
 * so I, Johan Schalkwyk is commenting it out
 *
 */

/*
    if ( TdatRead (&nframe, file) < 0 ) {
        XtAlert ("Problems reading %s", file);
        return -1;
    }
*/

    frame2adata (adata, &offsets, frame, nframe);
    syncasync (&sync, &scount, &delta, offsets, nframe);
    adata->ns_per_col = 62500;


    strcpy (stmp, file);
    sp = strrchr (stmp, '.');
    if (sp)
	strcpy (sp + 1, "forms");
    else
	strcat (stmp, ".forms");

/*
    if (form_read (stmp, &fcand, &fcount)) {
        XtAlert ("Couldn't find forms file %s cooresponding to %s, won't display formant marks", stmp, file);
    }
    else {
        if (fcount != adata->cols) {
            XtAlert ("Warning forms count = %d, frame count = %d\n",
                     fcount, adata->cols);
        }
    }
*/

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNdata, adata);
    MyXtSetArg (args, arg_cnt, XtNasync, offsets);
    MyXtSetArg (args, arg_cnt, XtNsync, sync);
    MyXtSetArg (args, arg_cnt, XtNsynccnt, scount);
    MyXtSetArg (args, arg_cnt, XtNsyncdelta, delta);
    MyXtSetArg (args, arg_cnt, XtNfcand, fcand);
    XtSetValues ((Widget) child, args, arg_cnt);
    return 0;
}


/*
 * PutData(w, client_data)
 *
 */

static void PutData (Widget w, WidgetList client_data)
{
    LspecWidget         child = (LspecWidget) client_data[0];
    DialogWidget        dw = (DialogWidget) client_data[1];
    char               *file = XawDialogGetValueString ((Widget) dw);

/*
    form_write (file, child->lspec.fcand, child->lspec.data->cols);
*/
}


/*
 * Destroy (w, target_widget, call_data)
 *
 */

static void Destroy (Widget w, Widget target_widget, caddr_t call_data)
{
    XtDestroyWidget (target_widget);
}


/*
 * SetOffset(w, client_data)
 *
 */

static void SetOffset (Widget w, WidgetList client_data)
{
    Widget       child = (Widget) client_data[0];
    DialogWidget dw = (DialogWidget) client_data[1];
    Widget       tool = (Widget) client_data[2];
    Arg    args[10];
    int arg_cnt = 0;
    char *in = XawDialogGetValueString((Widget) dw);
    int value = atoi (in);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNminOffset, value);
    XtSetValues (child, args, arg_cnt);
}



/*
 * ToggleExtent (cw, tw, call_data)
 *
 *
 * DESCRIPTION
 *    Cause the Lspec widget to toggle it's display of the
 * peak extent marks
 *
 */

static void ToggleExtent  (Widget cw, LspectoolWidget tw, caddr_t call_data)
{
  LspecWidget lw = (LspecWidget) tw->lspectool.child;
  Arg    args[10];
  int arg_cnt = 0;

  MyXtSetArg (args, arg_cnt, XtNdispPeakExtent, ! lw->lspec.disp_peak_extent);
  XtSetValues ((Widget) lw, args, arg_cnt);
}
