/* LspecP.h - Private Lspec Widget Defs
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtLspecP_h
#define _XtLspecP_h

#include <Lspec.h>
#include <LyreDispP.h>

#include <sys/types.h>
#include <adata.h>
#include <form_peak.h>

/*
 * New fields for the Lspec widget instance record
 */
typedef struct {
    Pixel	foreground_pixel; /* Foreground Pixel */
    GC		myGC;		/* Pointer to Graphics Context */
    GC		labelGC;	/* Pointer to label Graphics Context */
    Boolean 	reverse_video;	/* Reverse Video Flag */
    adata_t	*input_data;	/* New data is placed here */
    adata_t	*data;		/* Data object */
    int	        *async;          /* Synchonization for data, when this is
				   Null then we assume equally spaced
				   data. We also assume that this sorted from
				   from smallest to largest
				 */
    int         *sync;		/* Synchronous Map to Asynchronous */
    int		sync_cnt;	/* Number of entries in sync_index */
    int		sync_delta;	/* The sync delta */
    FCAND       *fcand;         /* Formant candidate data */
    float 	pix_per_datum;	/* a derived value */

    XPoint	*points;	/* The line vectors */
    XSegment    *segments;      /* The format display */

    int         current_frame;  /* Frame index for edit */
    int         current_peak;   /* Peak index for edit */

    int		global_min;	/* Global Data Minumum */
    int		global_max;	/* Global Data Maximum */
    Boolean     all_rows;       /* Display All Rows when true */
    Boolean     disp_peak_extent; /* Display lines on either side of formant */
    int         start_row;      /* First row ro display */
    int         row_count;      /* Number of rows to display */
    int		min_offset;	/* Data offset from Min */
    int		max_height;	/* Max Pixel Height of graph */
    Boolean	right_up;	/* Which way is up, right or left? */
    float	skew;		/* perspective skew of the graph */

    int		height;		/* height before resize */
    float	pix_per_row;	/* Pixels per row */

    Widget      hscale_widget;  /* Horizontal scale widget */
    Widget      vscale_widget;  /* Vertical scale widget */
}   LspecPart;

/*
 * Full instance record declaration
 */
typedef struct _LspecRec {
    CorePart core;
    LyreDispPart lyreDisp;
    LspecPart lspec;
}   LspecRec;

/*
 * New fields for the Lspec widget class record
 */
typedef struct {int dummy;} LspecClassPart;

/*
 * Full class record declaration.
 */
typedef struct _LspecClassRec {
    CoreClassPart core_class;
    LyreDispClassPart lyreDisp_class;
    LspecClassPart lspec_class;
}   LspecClassRec;

/*
 * Class pointer.
 */
extern LspecClassRec lspecClassRec;

#endif _XtLspecP_h
