/* LolaP.h - Private Lola Widget Defs
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 *  6-Jul-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added labelFileName field.
 *
 */

#ifndef _XtLolaP_h
#define _XtLolaP_h

#include <Lola.h>
#include <LyreDispP.h>
#include <X11/CoreP.h>

#include <sys/types.h>

#include <speech.h>

/*
 * New fields for the Lola widget instance record
 */
typedef struct {
    GC                  lolaGC;		   /* Pointer to Lola Graphics
					    * Context */
    Pixel               foreground_pixel;  /* Fore ground color */
    Font                font;		   /* Font to use */
    XFontStruct		*font_info;	   /* font_struct */

    SegmentList		*seg;		   /* The segments */
    SegmentList		*cur_edit;	   /* segment begin edited */
    SegmentList		*input_seg;	   /* Input segments */

    Widget	        hscale_widget;	   /* Hscale widget (if there's one) */
    Widget	        vscale_widget;	   /* Vscale widget (if there's one) */
    Widget              shell;             /* Popup w/ list */
    Widget              labelList;         /* Label list */
    char		*labelFileName;	   /* Name of label file */


}                   LolaPart;

/*
 * Full instance record declaration
 */
typedef struct _LolaRec {
    CorePart            core;
    LyreDispPart        lyreDisp;
    LolaPart            lola;
}                   LolaRec;

/*
 * New fields for the Lola widget class record
 */
typedef struct {
	int keep_compiler_happy_field;
} LolaClassPart;

/*
 * Full class record declaration.
 */
typedef struct _LolaClassRec {
    CoreClassPart       core_class;
    LyreDispClassPart   lyreDisp_class;
    LolaClassPart      lola_class;
}                   LolaClassRec;

/*
 * Class pointer.
 */
extern LolaClassRec lolaClassRec;

#endif _XtLolaP_h
